/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.profiles.MavenProfilesBuilder;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.build.ProfileAdvisor;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectBuildingResult;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.builder.DefaultPomArtifactResolver;
import org.apache.maven.project.builder.PomArtifactResolver;
import org.apache.maven.project.builder.PomInterpolatorTag;
import org.apache.maven.project.builder.ProjectBuilder;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

@Component(role=MavenProjectBuilder.class)
public class DefaultMavenProjectBuilder
implements MavenProjectBuilder,
LogEnabled {
    @Requirement
    protected MavenProfilesBuilder profilesBuilder;
    @Requirement
    private ModelValidator validator;
    @Requirement
    private ProfileAdvisor profileAdvisor;
    @Requirement
    private MavenTools mavenTools;
    @Requirement
    private ProjectBuilder projectBuilder;
    private Logger logger;
    @Requirement
    protected ArtifactResolver artifactResolver;
    @Requirement
    protected ArtifactMetadataSource artifactMetadataSource;
    @Requirement
    private ArtifactFactory artifactFactory;
    private Map processedProjectCache = new HashMap();
    private static HashMap<String, MavenProject> hm = new HashMap();
    private MavenProject superProject;

    public MavenProject build(File project, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        DefaultProjectBuilderConfiguration cbf = new DefaultProjectBuilderConfiguration();
        cbf.setLocalRepository(localRepository);
        cbf.setGlobalProfileManager(profileManager);
        return this.build(project, cbf);
    }

    public MavenProject build(File projectDescriptor, ProjectBuilderConfiguration config) throws ProjectBuildingException {
        ArrayList<ArtifactRepository> artifactRepositories = new ArrayList<ArtifactRepository>();
        artifactRepositories.addAll(this.mavenTools.buildArtifactRepositories(this.projectBuilder.getSuperModel()));
        if (config.getRemoteRepositories() != null) {
            artifactRepositories.addAll(config.getRemoteRepositories());
        }
        MavenProject project = this.readModelFromLocalPath("unknown", projectDescriptor, new DefaultPomArtifactResolver(config.getLocalRepository(), artifactRepositories, this.artifactResolver), config);
        project.setFile(projectDescriptor);
        project = this.buildWithProfiles(project.getModel(), config, projectDescriptor, project.getParentFile(), true);
        Build build = project.getBuild();
        project.addScriptSourceRoot(build.getScriptSourceDirectory());
        project.addCompileSourceRoot(build.getSourceDirectory());
        project.addTestCompileSourceRoot(build.getTestSourceDirectory());
        project.setFile(projectDescriptor);
        DefaultMavenProjectBuilder.setBuildOutputDirectoryOnParent(project);
        return project;
    }

    public MavenProject buildFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository, boolean allowStubs) throws ProjectBuildingException {
        return this.buildFromRepository(artifact, remoteArtifactRepositories, localRepository);
    }

    public MavenProject buildFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        MavenProject project = hm.get(artifact.getId());
        if (project != null) {
            return project;
        }
        ArrayList<ArtifactRepository> artifactRepositories = new ArrayList<ArtifactRepository>(remoteArtifactRepositories);
        artifactRepositories.addAll(this.mavenTools.buildArtifactRepositories(this.projectBuilder.getSuperModel()));
        File f = artifact.getFile() != null ? artifact.getFile() : new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
        this.mavenTools.findModelFromRepository(artifact, artifactRepositories, localRepository);
        ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setLocalRepository(localRepository);
        project = this.readModelFromLocalPath("unknown", artifact.getFile(), new DefaultPomArtifactResolver(config.getLocalRepository(), artifactRepositories, this.artifactResolver), config);
        project = this.buildWithProfiles(project.getModel(), config, artifact.getFile(), project.getParentFile(), false);
        artifact.setFile(f);
        project.setVersion(artifact.getVersion());
        hm.put(artifact.getId(), project);
        return project;
    }

    public MavenProject buildStandaloneSuperProject(ProjectBuilderConfiguration config) throws ProjectBuildingException {
        Model superModel = this.projectBuilder.getSuperModel();
        MavenProject project = null;
        try {
            project = new MavenProject(superModel, this.artifactFactory, this.mavenTools, this, config);
        }
        catch (InvalidRepositoryException e) {
            // empty catch block
        }
        try {
            project.setRemoteArtifactRepositories(this.mavenTools.buildArtifactRepositories(superModel.getRepositories()));
            project.setPluginArtifactRepositories(this.mavenTools.buildArtifactRepositories(superModel.getRepositories()));
        }
        catch (InvalidRepositoryException e) {
            // empty catch block
        }
        project.setExecutionRoot(true);
        return project;
    }

    public MavenProjectBuildingResult buildProjectWithDependencies(File projectDescriptor, ProjectBuilderConfiguration config) throws ProjectBuildingException {
        MavenProject project = this.build(projectDescriptor, config);
        try {
            project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, null, null));
        }
        catch (InvalidDependencyVersionException e) {
            throw new ProjectBuildingException(DefaultMavenProjectBuilder.safeVersionlessKey(project.getGroupId(), project.getArtifactId()), "Unable to build project due to an invalid dependency version: " + e.getMessage(), projectDescriptor, e);
        }
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(project.getArtifact()).setArtifactDependencies(project.getDependencyArtifacts()).setLocalRepository(config.getLocalRepository()).setRemoteRepostories(project.getRemoteArtifactRepositories()).setManagedVersionMap(project.getManagedVersionMap()).setMetadataSource(this.artifactMetadataSource);
        ArtifactResolutionResult result = this.artifactResolver.resolve(request);
        project.setArtifacts(result.getArtifacts());
        return new MavenProjectBuildingResult(project, result);
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    private Logger getLogger() {
        return this.logger;
    }

    private MavenProject buildWithProfiles(Model model, ProjectBuilderConfiguration config, File projectDescriptor, File parentDescriptor, boolean isReactorProject) throws ProjectBuildingException {
        MavenProject project;
        ProfileActivationContext profileActivationContext;
        String projectId = DefaultMavenProjectBuilder.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
        ProfileManager externalProfileManager = config.getGlobalProfileManager();
        if (externalProfileManager != null) {
            try {
                externalProfileManager.getActiveProfiles();
            }
            catch (ProfileActivationException e) {
                throw new ProjectBuildingException(projectId, "Failed to activate external profiles.", projectDescriptor, e);
            }
            profileActivationContext = externalProfileManager.getProfileActivationContext();
        } else {
            profileActivationContext = new DefaultProfileActivationContext(config.getExecutionProperties(), false);
        }
        try {
            project = new MavenProject(model, this.artifactFactory, this.mavenTools, this, config);
            this.validateModel(model, projectDescriptor);
            Artifact projectArtifact = this.artifactFactory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
            project.setArtifact(projectArtifact);
            project.setParentFile(parentDescriptor);
        }
        catch (InvalidRepositoryException e) {
            throw new InvalidProjectModelException(projectId, e.getMessage(), projectDescriptor, e);
        }
        ArrayList projectProfiles = new ArrayList();
        projectProfiles.addAll(this.profileAdvisor.applyActivatedProfiles(project.getModel(), project.getFile(), isReactorProject, profileActivationContext));
        projectProfiles.addAll(this.profileAdvisor.applyActivatedExternalProfiles(project.getModel(), project.getFile(), externalProfileManager));
        project.setActiveProfiles(projectProfiles);
        return project;
    }

    private MavenProject getSuperProject(ProjectBuilderConfiguration config, File projectDescriptor) {
        if (this.superProject != null) {
            return this.superProject;
        }
        Model model = this.projectBuilder.getSuperModel();
        try {
            this.superProject = new MavenProject(model, this.artifactFactory, this.mavenTools, this, config);
        }
        catch (InvalidRepositoryException e) {
            // empty catch block
        }
        return this.superProject;
    }

    private MavenProject readModelFromLocalPath(String projectId, File projectDescriptor, PomArtifactResolver resolver, ProjectBuilderConfiguration config) throws ProjectBuildingException {
        MavenProject mavenProject;
        if (projectDescriptor == null) {
            throw new IllegalArgumentException("projectDescriptor: null, Project Id =" + projectId);
        }
        ArrayList<InterpolatorProperty> interpolatorProperties = new ArrayList<InterpolatorProperty>();
        interpolatorProperties.addAll(InterpolatorProperty.toInterpolatorProperties((Properties)config.getExecutionProperties(), (String)PomInterpolatorTag.EXECUTION_PROPERTIES.name()));
        interpolatorProperties.addAll(InterpolatorProperty.toInterpolatorProperties((Properties)config.getUserProperties(), (String)PomInterpolatorTag.USER_PROPERTIES.name()));
        if (config.getBuildStartTime() != null) {
            interpolatorProperties.add(new InterpolatorProperty("${build.timestamp}", new SimpleDateFormat("yyyyMMdd-hhmm").format(config.getBuildStartTime()), PomInterpolatorTag.PROJECT_PROPERTIES.name()));
        }
        try {
            mavenProject = this.projectBuilder.buildFromLocalPath(projectDescriptor, null, interpolatorProperties, resolver, config);
        }
        catch (IOException e) {
            throw new ProjectBuildingException(projectId, "File = " + projectDescriptor.getAbsolutePath(), e);
        }
        return mavenProject;
    }

    private void validateModel(Model model, File pomFile) throws InvalidProjectModelException {
        ModelValidationResult validationResult = this.validator.validate(model);
        String projectId = DefaultMavenProjectBuilder.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
        if (validationResult.getMessageCount() > 0) {
            for (String s : validationResult.getMessages()) {
                this.logger.debug(s);
            }
            throw new InvalidProjectModelException(projectId, "Failed to validate POM", pomFile, validationResult);
        }
    }

    private static String safeVersionlessKey(String groupId, String artifactId) {
        String aid;
        String gid = groupId;
        if (StringUtils.isEmpty((String)gid)) {
            gid = "unknown";
        }
        if (StringUtils.isEmpty((String)(aid = artifactId))) {
            aid = "unknown";
        }
        return ArtifactUtils.versionlessKey((String)gid, (String)aid);
    }

    private static void setBuildOutputDirectoryOnParent(MavenProject project) {
        MavenProject parent = project.getParent();
        if (parent != null) {
            parent.getModel().getBuild().setDirectory(parent.getFile().getAbsolutePath());
            DefaultMavenProjectBuilder.setBuildOutputDirectoryOnParent(parent);
        }
    }

    class ProjectCache {
        private Map<String, MavenProject> projects = new HashMap<String, MavenProject>();

        ProjectCache() {
        }

        public MavenProject get(String key) {
            MavenProject p = this.projects.get(key);
            return p;
        }

        public MavenProject put(String key, MavenProject project) {
            return this.projects.put(key, project);
        }
    }
}

