/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.builder.PomTransformer;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.shared.model.InputStreamDomainModel;
import org.apache.maven.shared.model.ModelMarshaller;
import org.apache.maven.shared.model.ModelProperty;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PomClassicDomainModel
implements InputStreamDomainModel {
    private byte[] inputBytes;
    private String eventHistory;
    private Model model;
    private String id;
    private File file;
    private File parentFile;
    private File projectDirectory;
    private List<ModelProperty> modelProperties;
    private int lineageCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomClassicDomainModel(Model model) throws IOException {
        if (model == null) {
            throw new IllegalArgumentException("model: null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlStreamWriter out = null;
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            out = WriterFactory.newXmlWriter((OutputStream)baos);
            writer.write((Writer)out, model);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        this.inputBytes = baos.toByteArray();
    }

    public PomClassicDomainModel(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream: null");
        }
        this.inputBytes = IOUtil.toByteArray((InputStream)inputStream);
    }

    public PomClassicDomainModel(File file) throws IOException {
        this(new FileInputStream(file));
        this.file = file;
    }

    public File getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(File parentFile) {
        this.parentFile = parentFile;
    }

    public void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public boolean isPomInBuild() {
        return this.projectDirectory != null && new File(this.projectDirectory, "pom.xml").isFile();
    }

    public boolean matchesModel(Model a) {
        if (a == null) {
            throw new IllegalArgumentException("a: null");
        }
        if (this.model == null) {
            try {
                this.model = this.getModel();
            }
            catch (IOException e) {
                return false;
            }
        }
        return a.getId().equals(this.getId());
    }

    public String getId() {
        if (this.id == null) {
            if (this.model == null) {
                try {
                    this.model = this.getModel();
                }
                catch (IOException e) {
                    return "";
                }
            }
            String groupId = this.model.getGroupId() == null && this.model.getParent() != null ? this.model.getParent().getGroupId() : this.model.getGroupId();
            String artifactId = this.model.getArtifactId() == null && this.model.getParent() != null ? this.model.getParent().getArtifactId() : this.model.getArtifactId();
            String version = this.model.getVersion() == null && this.model.getParent() != null ? this.model.getParent().getVersion() : this.model.getVersion();
            this.id = groupId + ":" + artifactId + ":" + version;
        }
        return this.id;
    }

    public boolean matchesParent(Parent parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent: null");
        }
        return this.getId().equals(parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion());
    }

    public String asString() {
        try {
            return IOUtil.toString((Reader)ReaderFactory.newXmlReader((InputStream)new ByteArrayInputStream(this.inputBytes)));
        }
        catch (IOException ioe) {
            return "";
        }
    }

    public Model getModel() throws IOException {
        if (this.model != null) {
            return this.model;
        }
        try {
            return new MavenXpp3Reader().read((Reader)ReaderFactory.newXmlReader((InputStream)new ByteArrayInputStream(this.inputBytes)));
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage());
        }
    }

    public InputStream getInputStream() {
        byte[] copy = new byte[this.inputBytes.length];
        System.arraycopy(this.inputBytes, 0, copy, 0, this.inputBytes.length);
        return new ByteArrayInputStream(copy);
    }

    public File getFile() {
        return this.file;
    }

    public List<ModelProperty> getModelProperties() throws IOException {
        if (this.modelProperties == null) {
            HashSet<String> s = new HashSet<String>();
            s.addAll(PomTransformer.URIS);
            s.add(ProjectUri.Build.PluginManagement.Plugins.Plugin.Executions.xUri);
            s.add(ProjectUri.Build.Plugins.Plugin.Executions.xUri);
            this.modelProperties = ModelMarshaller.marshallXmlToModelProperties((InputStream)this.getInputStream(), (String)ProjectUri.baseUri, s);
        }
        return new ArrayList<ModelProperty>(this.modelProperties);
    }

    public String getEventHistory() {
        return this.eventHistory;
    }

    public void setEventHistory(String eventHistory) {
        if (eventHistory == null) {
            throw new IllegalArgumentException("eventHistory: null");
        }
        this.eventHistory = eventHistory;
    }

    public int getLineageCount() {
        return this.lineageCount;
    }

    public void setLineageCount(int lineageCount) {
        this.lineageCount = lineageCount;
    }

    public boolean equals(Object o) {
        return o instanceof PomClassicDomainModel && this.getId().equals(((PomClassicDomainModel)o).getId());
    }
}

