/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.v4;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Plugin
implements Serializable {
    final String name;
    final String prefix;
    final String artifactId;

    Plugin(String name, String prefix, String artifactId) {
        this.name = name;
        this.prefix = prefix;
        this.artifactId = artifactId;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nonnull
    public Builder with() {
        return Plugin.newBuilder(this);
    }

    @Nonnull
    public Plugin withName(String name) {
        return Plugin.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Plugin withPrefix(String prefix) {
        return Plugin.newBuilder(this, true).prefix(prefix).build();
    }

    @Nonnull
    public Plugin withArtifactId(String artifactId) {
        return Plugin.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public static Plugin newInstance() {
        return Plugin.newInstance(true);
    }

    @Nonnull
    public static Plugin newInstance(boolean withDefaults) {
        return Plugin.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Plugin.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Plugin from) {
        return Plugin.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Plugin from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Plugin base;
        String name;
        String prefix;
        String artifactId;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Plugin base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.prefix = base.prefix;
                this.artifactId = base.artifactId;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Plugin build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.prefix != null && this.prefix != this.base.prefix || this.artifactId != null && this.artifactId != this.base.artifactId)) {
                return this.base;
            }
            return new Plugin(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.prefix != null ? this.prefix : (this.base != null ? this.base.prefix : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null));
        }
    }
}

