// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model-v3.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.artifact.repository.metadata;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;

@Generated
public class Metadata
    extends BaseObject
{

    public Metadata() {
        this(org.apache.maven.api.metadata.Metadata.newInstance());
    }

    public Metadata(org.apache.maven.api.metadata.Metadata delegate) {
        this(delegate, null);
    }

    public Metadata(org.apache.maven.api.metadata.Metadata delegate, BaseObject parent) {
        super(delegate, parent);
    }

    public Metadata clone(){
        return new Metadata(getDelegate());
    }

    public org.apache.maven.api.metadata.Metadata getDelegate() {
        return (org.apache.maven.api.metadata.Metadata) super.getDelegate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata) o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return getDelegate().hashCode();
    }

    public String getModelEncoding() {
        return getDelegate().getModelEncoding();
    }

    public String getModelVersion() {
        return getDelegate().getModelVersion();
    }

    public void setModelVersion(String modelVersion) {
        if (!Objects.equals(modelVersion, getModelVersion())) {
            update(getDelegate().withModelVersion(modelVersion));
        }
    }

    public String getGroupId() {
        return getDelegate().getGroupId();
    }

    public void setGroupId(String groupId) {
        if (!Objects.equals(groupId, getGroupId())) {
            update(getDelegate().withGroupId(groupId));
        }
    }

    public String getArtifactId() {
        return getDelegate().getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        if (!Objects.equals(artifactId, getArtifactId())) {
            update(getDelegate().withArtifactId(artifactId));
        }
    }

    public Versioning getVersioning() {
        return getDelegate().getVersioning() != null ? new Versioning(getDelegate().getVersioning(), this) : null;
    }

    public void setVersioning(Versioning versioning) {
        if (!Objects.equals(versioning, getVersioning())){
            if (versioning != null) {
                update(getDelegate().withVersioning(versioning.getDelegate()));
                versioning.childrenTracking = this::replace;
            } else {
                update(getDelegate().withVersioning(null));
            }
        }
    }

    public String getVersion() {
        return getDelegate().getVersion();
    }

    public void setVersion(String version) {
        if (!Objects.equals(version, getVersion())) {
            update(getDelegate().withVersion(version));
        }
    }

    @Nonnull
    public List<Plugin> getPlugins() {
        return new WrapperList<Plugin, org.apache.maven.api.metadata.Plugin>(
                    () -> getDelegate().getPlugins(), l -> update(getDelegate().withPlugins(l)),
                    d -> new Plugin(d, this), Plugin::getDelegate);
    }

    public void setPlugins(List<Plugin> plugins) {
        if (plugins == null) {
            plugins = Collections.emptyList();
        }
        if (!Objects.equals(plugins, getPlugins())) {
            update(getDelegate().withPlugins(
                plugins.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            plugins.forEach(e -> e.childrenTracking = this::replace);
        }
    }

    public void addPlugin(Plugin plugin) {
        update(getDelegate().withPlugins(
               Stream.concat(getDelegate().getPlugins().stream(), Stream.of(plugin.getDelegate()))
                        .collect(Collectors.toList())));
        plugin.childrenTracking = this::replace;
    }

    public void removePlugin(Plugin plugin) {
        update(getDelegate().withPlugins(
               getDelegate().getPlugins().stream()
                        .filter(e -> !Objects.equals(e, plugin))
                        .collect(Collectors.toList())));
        plugin.childrenTracking = null;
    }

    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (oldDelegate == getDelegate().getVersioning()) {
            update(getDelegate().withVersioning((org.apache.maven.api.metadata.Versioning) newDelegate));
            return true;
        }
        if (getDelegate().getPlugins().contains(oldDelegate)) {
            List<org.apache.maven.api.metadata.Plugin> list = new ArrayList<>(getDelegate().getPlugins());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.metadata.Plugin) newDelegate : d);
            update(getDelegate().withPlugins(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.metadata.Metadata> metadataToApiV4(List<Metadata> list) {
        return list != null ? new WrapperList<>(list, Metadata::getDelegate, Metadata::new) : null;
    }

    public static List<Metadata> metadataToApiV3(List<org.apache.maven.api.metadata.Metadata> list) {
        return list != null ? new WrapperList<>(list, Metadata::new, Metadata::getDelegate) : null;
    }


    private String getSnapshotVersionKey( SnapshotVersion sv )
    {
        return sv.getClassifier() + ":" + sv.getExtension();
    }

    public boolean merge( Metadata sourceMetadata )
    {
        boolean changed = false;

        for ( Plugin plugin : sourceMetadata.getPlugins() )
        {
            boolean found = false;

            for ( Plugin preExisting : getPlugins() )
            {
                if ( java.util.Objects.equals( preExisting.getPrefix(), plugin.getPrefix() ) )
                {
                    found = true;
                    break;
                }
            }

            if ( !found )
            {
                Plugin mappedPlugin = new Plugin();

                mappedPlugin.setArtifactId( plugin.getArtifactId() );

                mappedPlugin.setPrefix( plugin.getPrefix() );

                mappedPlugin.setName( plugin.getName() );

                addPlugin( mappedPlugin );

                changed = true;
            }
        }

        Versioning versioning = sourceMetadata.getVersioning();
        if ( versioning != null )
        {
            Versioning v = getVersioning();
            if ( v == null )
            {
                v = new Versioning();
                setVersioning( v );
                changed = true;
            }

            for ( String version : versioning.getVersions() )
            {
                if ( !v.getVersions().contains( version ) )
                {
                    changed = true;
                    v.getVersions().add( version );
                }
            }

            if ( "null".equals( versioning.getLastUpdated() ) )
            {
                versioning.setLastUpdated( null );
            }

            if ( "null".equals( v.getLastUpdated() ) )
            {
                v.setLastUpdated( null );
            }

            if ( versioning.getLastUpdated() == null || versioning.getLastUpdated().length() == 0 )
            {
                // this should only be for historical reasons - we assume local is newer
                versioning.setLastUpdated( v.getLastUpdated() );
            }

            if ( v.getLastUpdated() == null || v.getLastUpdated().length() == 0
                 || versioning.getLastUpdated().compareTo( v.getLastUpdated() ) >= 0 )
            {
                changed = true;
                v.setLastUpdated( versioning.getLastUpdated() );

                if ( versioning.getRelease() != null )
                {
                    changed = true;
                    v.setRelease( versioning.getRelease() );
                }
                if ( versioning.getLatest() != null )
                {
                    changed = true;
                    v.setLatest( versioning.getLatest() );
                }

                Snapshot s = v.getSnapshot();
                Snapshot snapshot = versioning.getSnapshot();
                if ( snapshot != null )
                {
                    boolean updateSnapshotVersions = false;
                    if ( s == null )
                    {
                        s = new Snapshot();
                        v.setSnapshot( s );
                        changed = true;
                        updateSnapshotVersions = true;
                    }

                    // overwrite
                    if ( s.getTimestamp() == null ? snapshot.getTimestamp() != null
                        : !s.getTimestamp().equals( snapshot.getTimestamp() ) )
                    {
                        s.setTimestamp( snapshot.getTimestamp() );
                        changed = true;
                        updateSnapshotVersions = true;
                    }
                    if ( s.getBuildNumber() != snapshot.getBuildNumber() )
                    {
                        s.setBuildNumber( snapshot.getBuildNumber() );
                        changed = true;
                    }
                    if ( s.isLocalCopy() != snapshot.isLocalCopy() )
                    {
                        s.setLocalCopy( snapshot.isLocalCopy() );
                        changed = true;
                    }
                    if ( updateSnapshotVersions )
                    {
                        java.util.Map<String, SnapshotVersion> versions = new java.util.LinkedHashMap<>();
                        // never convert from legacy to new format if either source or target is legacy format
                        if ( !v.getSnapshotVersions().isEmpty() )
                        {
                            for ( SnapshotVersion sv : versioning.getSnapshotVersions() )
                            {
                                String key = getSnapshotVersionKey( sv );
                                versions.put( key, sv );
                            }
                            // never convert from legacy format
                            if ( !versions.isEmpty() )
                            {
                                for ( SnapshotVersion sv : v.getSnapshotVersions() )
                                {
                                    String key = getSnapshotVersionKey( sv );
                                    if ( !versions.containsKey( key ) )
                                    {
                                        versions.put( key, sv );
                                    }
                                }
                            }
                            v.setSnapshotVersions( new java.util.ArrayList<SnapshotVersion>( versions.values() ) );
                        }

                        changed = true;
                    }
                }
            }
        }
        return changed;
    }
          
}
