/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.maven.building.Source;
import org.apache.maven.model.building.ModelCache;
import org.eclipse.aether.RepositorySystemSession;

public class DefaultModelCache
implements ModelCache {
    private static final String KEY = DefaultModelCache.class.getName();
    private final Map<Object, Supplier<?>> cache;

    public static ModelCache newInstance(RepositorySystemSession session) {
        Map cache;
        if (session.getCache() == null) {
            cache = new ConcurrentHashMap();
        } else {
            cache = (Map)session.getCache().get(session, (Object)KEY);
            if (cache == null) {
                cache = new ConcurrentHashMap();
                session.getCache().put(session, (Object)KEY, cache);
            }
        }
        return new DefaultModelCache(cache);
    }

    private DefaultModelCache(Map<Object, Supplier<?>> cache) {
        this.cache = cache;
    }

    public Object get(Source path, String tag) {
        return this.get(new SourceCacheKey(path, tag));
    }

    public void put(Source path, String tag, Object data) {
        this.put(new SourceCacheKey(path, tag), data);
    }

    public Object get(String groupId, String artifactId, String version, String tag) {
        return this.get(new GavCacheKey(groupId, artifactId, version, tag));
    }

    public void put(String groupId, String artifactId, String version, String tag, Object data) {
        this.put(new GavCacheKey(groupId, artifactId, version, tag), data);
    }

    protected Object get(Object key) {
        Supplier<?> s = this.cache.get(key);
        return s != null ? s.get() : null;
    }

    protected void put(Object key, Object data) {
        this.cache.put(key, () -> data);
    }

    public Object computeIfAbsent(String groupId, String artifactId, String version, String tag, Supplier<Supplier<?>> data) {
        return this.computeIfAbsent(new GavCacheKey(groupId, artifactId, version, tag), data);
    }

    public Object computeIfAbsent(Source path, String tag, Supplier<Supplier<?>> data) {
        return this.computeIfAbsent(new SourceCacheKey(path, tag), data);
    }

    protected Object computeIfAbsent(Object key, Supplier<Supplier<?>> data) {
        Supplier s = this.cache.computeIfAbsent(key, (? super K k) -> (Supplier)data.get());
        return s != null ? s.get() : null;
    }

    private static final class SourceCacheKey {
        private final Source source;
        private final String tag;
        private final int hash;

        SourceCacheKey(Source source, String tag) {
            this.source = source;
            this.tag = tag;
            this.hash = Objects.hash(source, tag);
        }

        public String toString() {
            return "SourceCacheKey{source=" + this.source + ", tag='" + this.tag + '\'' + '}';
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            SourceCacheKey that = (SourceCacheKey)obj;
            return Objects.equals(this.source, that.source) && Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class GavCacheKey {
        private final String gav;
        private final String tag;
        private final int hash;

        GavCacheKey(String groupId, String artifactId, String version, String tag) {
            this(GavCacheKey.gav(groupId, artifactId, version), tag);
        }

        GavCacheKey(String gav, String tag) {
            this.gav = gav;
            this.tag = tag;
            this.hash = Objects.hash(gav, tag);
        }

        private static String gav(String groupId, String artifactId, String version) {
            StringBuilder sb = new StringBuilder();
            if (groupId != null) {
                sb.append(groupId);
            }
            sb.append(":");
            if (artifactId != null) {
                sb.append(artifactId);
            }
            sb.append(":");
            if (version != null) {
                sb.append(version);
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            GavCacheKey that = (GavCacheKey)obj;
            return Objects.equals(this.gav, that.gav) && Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "GavCacheKey{gav='" + this.gav + '\'' + ", tag='" + this.tag + '\'' + '}';
        }
    }
}

