/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.repository.internal.artifact.FatArtifactTraverser;
import org.apache.maven.repository.internal.scopes.MavenDependencyContextRefiner;
import org.apache.maven.repository.internal.scopes.MavenScopeDeriver;
import org.apache.maven.repository.internal.scopes.MavenScopeSelector;
import org.apache.maven.repository.internal.scopes.MavenSystemScopeHandler;
import org.apache.maven.repository.internal.type.DefaultTypeProvider;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SystemScopeHandler;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

public class MavenSessionBuilderSupplier
implements Supplier<RepositorySystemSession.SessionBuilder> {
    protected final RepositorySystem repositorySystem;

    public MavenSessionBuilderSupplier(RepositorySystem repositorySystem) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
    }

    @Deprecated
    MavenSessionBuilderSupplier() {
        this.repositorySystem = null;
    }

    protected DependencyTraverser getDependencyTraverser() {
        return new FatArtifactTraverser();
    }

    protected SystemScopeHandler getSystemScopeHandler() {
        return new MavenSystemScopeHandler();
    }

    protected DependencyManager getDependencyManager() {
        return new ClassicDependencyManager(true, this.getSystemScopeHandler());
    }

    protected DependencySelector getDependencySelector() {
        return new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test", "provided"}), new OptionalDependencySelector(), new ExclusionDependencySelector()});
    }

    protected DependencyGraphTransformer getDependencyGraphTransformer() {
        return new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{new ConflictResolver((ConflictResolver.VersionSelector)new NearestVersionSelector(), (ConflictResolver.ScopeSelector)new MavenScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new MavenScopeDeriver()), new MavenDependencyContextRefiner()});
    }

    protected ArtifactTypeRegistry getArtifactTypeRegistry() {
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        new DefaultTypeProvider().types().forEach(arg_0 -> ((DefaultArtifactTypeRegistry)stereotypes).add(arg_0));
        return stereotypes;
    }

    protected ArtifactDescriptorPolicy getArtifactDescriptorPolicy() {
        return new SimpleArtifactDescriptorPolicy(true, true);
    }

    protected void configureSessionBuilder(RepositorySystemSession.SessionBuilder session) {
        session.setDependencyTraverser(this.getDependencyTraverser());
        session.setDependencyManager(this.getDependencyManager());
        session.setDependencySelector(this.getDependencySelector());
        session.setDependencyGraphTransformer(this.getDependencyGraphTransformer());
        session.setArtifactTypeRegistry(this.getArtifactTypeRegistry());
        session.setArtifactDescriptorPolicy(this.getArtifactDescriptorPolicy());
    }

    @Override
    public RepositorySystemSession.SessionBuilder get() {
        RepositorySystemSession.SessionBuilder builder = this.repositorySystem.createSessionBuilder();
        this.configureSessionBuilder(builder);
        return builder;
    }
}

