// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from merger.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.settings.v4;

import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputSource;

@Generated
public class SettingsMerger {

    private final boolean deepMerge;

    public SettingsMerger() {
        this(true);
    }

    public SettingsMerger(boolean deepMerge) {
        this.deepMerge = deepMerge;
    }

    /**
     * Merges the specified source object into the given target object.
     *
     * @param target The target object whose existing contents should be merged with the source, must not be
     *            <code>null</code>.
     * @param source The (read-only) source object that should be merged into the target object, may be
     *            <code>null</code>.
     * @param sourceDominant A flag indicating whether either the target object or the source object provides the
     *            dominant data.
     * @param hints A set of key-value pairs that customized merger implementations can use to carry domain-specific
     *            information along, may be <code>null</code>.
     */
    public Settings merge(Settings target, Settings source, boolean sourceDominant, Map<?, ?> hints) {
        Objects.requireNonNull(target, "target cannot be null");
        if (source == null) {
            return target;
        }
        Map<Object, Object> context = new HashMap<>();
        if (hints != null) {
            context.putAll(hints);
        }
        return mergeSettings(target, source, sourceDominant, context);
    }

    protected TrackableBase mergeTrackableBase(TrackableBase target, TrackableBase source, boolean sourceDominant, Map<Object, Object> context) {
        TrackableBase.Builder builder = TrackableBase.newBuilder(target);
        mergeTrackableBase(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeTrackableBase(TrackableBase.Builder builder, TrackableBase target, TrackableBase source, boolean sourceDominant, Map<Object, Object> context) {
    }


    protected IdentifiableBase mergeIdentifiableBase(IdentifiableBase target, IdentifiableBase source, boolean sourceDominant, Map<Object, Object> context) {
        IdentifiableBase.Builder builder = IdentifiableBase.newBuilder(target);
        mergeIdentifiableBase(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeIdentifiableBase(IdentifiableBase.Builder builder, IdentifiableBase target, IdentifiableBase source, boolean sourceDominant, Map<Object, Object> context) {
        mergeTrackableBase(builder, target, source, sourceDominant, context);
        mergeIdentifiableBase_Id(builder, target, source, sourceDominant, context);
    }

    protected void mergeIdentifiableBase_Id(IdentifiableBase.Builder builder, IdentifiableBase target, IdentifiableBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location("id", source.getLocation("id"));
        }
    }

    protected Settings mergeSettings(Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        Settings.Builder builder = Settings.newBuilder(target);
        mergeSettings(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeSettings(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        mergeTrackableBase(builder, target, source, sourceDominant, context);
        mergeSettings_LocalRepository(builder, target, source, sourceDominant, context);
        mergeSettings_InteractiveMode(builder, target, source, sourceDominant, context);
        mergeSettings_UsePluginRegistry(builder, target, source, sourceDominant, context);
        mergeSettings_Offline(builder, target, source, sourceDominant, context);
        mergeSettings_Proxies(builder, target, source, sourceDominant, context);
        mergeSettings_Servers(builder, target, source, sourceDominant, context);
        mergeSettings_Mirrors(builder, target, source, sourceDominant, context);
        mergeSettings_Repositories(builder, target, source, sourceDominant, context);
        mergeSettings_PluginRepositories(builder, target, source, sourceDominant, context);
        mergeSettings_Profiles(builder, target, source, sourceDominant, context);
        mergeSettings_ActiveProfiles(builder, target, source, sourceDominant, context);
        mergeSettings_PluginGroups(builder, target, source, sourceDominant, context);
    }

    protected void mergeSettings_LocalRepository(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getLocalRepository();
        String tgt = target.getLocalRepository();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.localRepository(src);
            builder.location("localRepository", source.getLocation("localRepository"));
        }
    }
    protected void mergeSettings_InteractiveMode(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.interactiveMode(source.isInteractiveMode());
        }
    }
    protected void mergeSettings_UsePluginRegistry(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.usePluginRegistry(source.isUsePluginRegistry());
        }
    }
    protected void mergeSettings_Offline(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.offline(source.isOffline());
        }
    }
    protected void mergeSettings_Proxies(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (deepMerge) {
            builder.proxies(merge(target.getProxies(), source.getProxies(), getProxyKey(),
                    (t, s) -> mergeProxy(t, s, sourceDominant, context)));
        } else {
            builder.proxies(merge(target.getProxies(), source.getProxies(), sourceDominant, getProxyKey()));
        }
    }
    protected void mergeSettings_Servers(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (deepMerge) {
            builder.servers(merge(target.getServers(), source.getServers(), getServerKey(),
                    (t, s) -> mergeServer(t, s, sourceDominant, context)));
        } else {
            builder.servers(merge(target.getServers(), source.getServers(), sourceDominant, getServerKey()));
        }
    }
    protected void mergeSettings_Mirrors(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (deepMerge) {
            builder.mirrors(merge(target.getMirrors(), source.getMirrors(), getMirrorKey(),
                    (t, s) -> mergeMirror(t, s, sourceDominant, context)));
        } else {
            builder.mirrors(merge(target.getMirrors(), source.getMirrors(), sourceDominant, getMirrorKey()));
        }
    }
    protected void mergeSettings_Repositories(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (deepMerge) {
            builder.repositories(merge(target.getRepositories(), source.getRepositories(), getRepositoryKey(),
                    (t, s) -> mergeRepository(t, s, sourceDominant, context)));
        } else {
            builder.repositories(merge(target.getRepositories(), source.getRepositories(), sourceDominant, getRepositoryKey()));
        }
    }
    protected void mergeSettings_PluginRepositories(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (deepMerge) {
            builder.pluginRepositories(merge(target.getPluginRepositories(), source.getPluginRepositories(), getRepositoryKey(),
                    (t, s) -> mergeRepository(t, s, sourceDominant, context)));
        } else {
            builder.pluginRepositories(merge(target.getPluginRepositories(), source.getPluginRepositories(), sourceDominant, getRepositoryKey()));
        }
    }
    protected void mergeSettings_Profiles(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        if (deepMerge) {
            builder.profiles(merge(target.getProfiles(), source.getProfiles(), getProfileKey(),
                    (t, s) -> mergeProfile(t, s, sourceDominant, context)));
        } else {
            builder.profiles(merge(target.getProfiles(), source.getProfiles(), sourceDominant, getProfileKey()));
        }
    }
    protected void mergeSettings_ActiveProfiles(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        builder.activeProfiles(merge(target.getActiveProfiles(), source.getActiveProfiles(), sourceDominant, e -> e));
    }
    protected void mergeSettings_PluginGroups(Settings.Builder builder, Settings target, Settings source, boolean sourceDominant, Map<Object, Object> context) {
        builder.pluginGroups(merge(target.getPluginGroups(), source.getPluginGroups(), sourceDominant, e -> e));
    }

    protected Proxy mergeProxy(Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        Proxy.Builder builder = Proxy.newBuilder(target);
        mergeProxy(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeProxy(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        mergeIdentifiableBase(builder, target, source, sourceDominant, context);
        mergeProxy_ActiveString(builder, target, source, sourceDominant, context);
        mergeProxy_Protocol(builder, target, source, sourceDominant, context);
        mergeProxy_Username(builder, target, source, sourceDominant, context);
        mergeProxy_Password(builder, target, source, sourceDominant, context);
        mergeProxy_PortString(builder, target, source, sourceDominant, context);
        mergeProxy_Host(builder, target, source, sourceDominant, context);
        mergeProxy_NonProxyHosts(builder, target, source, sourceDominant, context);
    }

    protected void mergeProxy_Id(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location("id", source.getLocation("id"));
        }
    }
    protected void mergeProxy_ActiveString(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getActiveString();
        String tgt = target.getActiveString();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.activeString(src);
            builder.location("activeString", source.getLocation("activeString"));
        }
    }
    protected void mergeProxy_Protocol(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getProtocol();
        String tgt = target.getProtocol();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.protocol(src);
            builder.location("protocol", source.getLocation("protocol"));
        }
    }
    protected void mergeProxy_Username(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUsername();
        String tgt = target.getUsername();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.username(src);
            builder.location("username", source.getLocation("username"));
        }
    }
    protected void mergeProxy_Password(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPassword();
        String tgt = target.getPassword();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.password(src);
            builder.location("password", source.getLocation("password"));
        }
    }
    protected void mergeProxy_PortString(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPortString();
        String tgt = target.getPortString();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.portString(src);
            builder.location("portString", source.getLocation("portString"));
        }
    }
    protected void mergeProxy_Host(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getHost();
        String tgt = target.getHost();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.host(src);
            builder.location("host", source.getLocation("host"));
        }
    }
    protected void mergeProxy_NonProxyHosts(Proxy.Builder builder, Proxy target, Proxy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getNonProxyHosts();
        String tgt = target.getNonProxyHosts();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.nonProxyHosts(src);
            builder.location("nonProxyHosts", source.getLocation("nonProxyHosts"));
        }
    }

    protected Server mergeServer(Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        Server.Builder builder = Server.newBuilder(target);
        mergeServer(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeServer(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        mergeIdentifiableBase(builder, target, source, sourceDominant, context);
        mergeServer_Username(builder, target, source, sourceDominant, context);
        mergeServer_Password(builder, target, source, sourceDominant, context);
        mergeServer_PrivateKey(builder, target, source, sourceDominant, context);
        mergeServer_Passphrase(builder, target, source, sourceDominant, context);
        mergeServer_FilePermissions(builder, target, source, sourceDominant, context);
        mergeServer_DirectoryPermissions(builder, target, source, sourceDominant, context);
        mergeServer_Configuration(builder, target, source, sourceDominant, context);
    }

    protected void mergeServer_Id(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location("id", source.getLocation("id"));
        }
    }
    protected void mergeServer_Username(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUsername();
        String tgt = target.getUsername();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.username(src);
            builder.location("username", source.getLocation("username"));
        }
    }
    protected void mergeServer_Password(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPassword();
        String tgt = target.getPassword();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.password(src);
            builder.location("password", source.getLocation("password"));
        }
    }
    protected void mergeServer_PrivateKey(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPrivateKey();
        String tgt = target.getPrivateKey();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.privateKey(src);
            builder.location("privateKey", source.getLocation("privateKey"));
        }
    }
    protected void mergeServer_Passphrase(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getPassphrase();
        String tgt = target.getPassphrase();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.passphrase(src);
            builder.location("passphrase", source.getLocation("passphrase"));
        }
    }
    protected void mergeServer_FilePermissions(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getFilePermissions();
        String tgt = target.getFilePermissions();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.filePermissions(src);
            builder.location("filePermissions", source.getLocation("filePermissions"));
        }
    }
    protected void mergeServer_DirectoryPermissions(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getDirectoryPermissions();
        String tgt = target.getDirectoryPermissions();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.directoryPermissions(src);
            builder.location("directoryPermissions", source.getLocation("directoryPermissions"));
        }
    }
    protected void mergeServer_Configuration(Server.Builder builder, Server target, Server source, boolean sourceDominant, Map<Object, Object> context) {
        XmlNode src = source.getConfiguration();
        if (src != null) {
            XmlNode tgt = target.getConfiguration();
            if (tgt == null) {
                builder.configuration(src);
                builder.location("configuration", source.getLocation("configuration"));
            } else if (sourceDominant) {
                builder.configuration(src.merge(tgt));
                builder.location("configuration", target.getLocation("configuration"));
            } else {
                builder.configuration(tgt.merge(src));
                builder.location("configuration", null);
            }
        }
    }

    protected Mirror mergeMirror(Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        Mirror.Builder builder = Mirror.newBuilder(target);
        mergeMirror(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeMirror(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        mergeIdentifiableBase(builder, target, source, sourceDominant, context);
        mergeMirror_MirrorOf(builder, target, source, sourceDominant, context);
        mergeMirror_Name(builder, target, source, sourceDominant, context);
        mergeMirror_Url(builder, target, source, sourceDominant, context);
        mergeMirror_Layout(builder, target, source, sourceDominant, context);
        mergeMirror_MirrorOfLayouts(builder, target, source, sourceDominant, context);
        mergeMirror_Blocked(builder, target, source, sourceDominant, context);
    }

    protected void mergeMirror_Id(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location("id", source.getLocation("id"));
        }
    }
    protected void mergeMirror_MirrorOf(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getMirrorOf();
        String tgt = target.getMirrorOf();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.mirrorOf(src);
            builder.location("mirrorOf", source.getLocation("mirrorOf"));
        }
    }
    protected void mergeMirror_Name(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location("name", source.getLocation("name"));
        }
    }
    protected void mergeMirror_Url(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        String tgt = target.getUrl();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.url(src);
            builder.location("url", source.getLocation("url"));
        }
    }
    protected void mergeMirror_Layout(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getLayout();
        String tgt = target.getLayout();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.layout(src);
            builder.location("layout", source.getLocation("layout"));
        }
    }
    protected void mergeMirror_MirrorOfLayouts(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getMirrorOfLayouts();
        String tgt = target.getMirrorOfLayouts();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.mirrorOfLayouts(src);
            builder.location("mirrorOfLayouts", source.getLocation("mirrorOfLayouts"));
        }
    }
    protected void mergeMirror_Blocked(Mirror.Builder builder, Mirror target, Mirror source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.blocked(source.isBlocked());
        }
    }

    protected Profile mergeProfile(Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        Profile.Builder builder = Profile.newBuilder(target);
        mergeProfile(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeProfile(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        mergeIdentifiableBase(builder, target, source, sourceDominant, context);
        mergeProfile_Activation(builder, target, source, sourceDominant, context);
        mergeProfile_Properties(builder, target, source, sourceDominant, context);
        mergeProfile_Repositories(builder, target, source, sourceDominant, context);
        mergeProfile_PluginRepositories(builder, target, source, sourceDominant, context);
    }

    protected void mergeProfile_Id(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location("id", source.getLocation("id"));
        }
    }
    protected void mergeProfile_Activation(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        Activation src = source.getActivation();
        if (src != null) {
            Activation tgt = target.getActivation();
            if (tgt == null) {
                tgt = Activation.newInstance(false);
            }
            Activation merged = mergeActivation(tgt, src, sourceDominant, context);
            builder.activation(merged);
            if (target.getActivation() == null) {
                builder.location("activation", source.getLocation("activation"));
            } else if (merged != tgt) {
                builder.location("activation", new InputLocation(-1, -1));
            }
        }
    }
    protected void mergeProfile_Properties(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        Map<String, String> src = source.getProperties();
        if (!src.isEmpty()) {
            Map<String, String> tgt = target.getProperties();
            if (tgt.isEmpty()) {
                builder.properties(src);
                builder.location("properties", source.getLocation("properties"));
            } else {
                Map<String, String> merged = new HashMap<>();
                merged.putAll(sourceDominant ? target.getProperties() : source.getProperties());
                merged.putAll(sourceDominant ? source.getProperties() : target.getProperties());
                builder.properties(merged);
                builder.location("properties", InputLocation.merge(target.getLocation("properties"), source.getLocation("properties"), sourceDominant));
            }
        }
    }
    protected void mergeProfile_Repositories(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        if (deepMerge) {
            builder.repositories(merge(target.getRepositories(), source.getRepositories(), getRepositoryKey(),
                    (t, s) -> mergeRepository(t, s, sourceDominant, context)));
        } else {
            builder.repositories(merge(target.getRepositories(), source.getRepositories(), sourceDominant, getRepositoryKey()));
        }
    }
    protected void mergeProfile_PluginRepositories(Profile.Builder builder, Profile target, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        if (deepMerge) {
            builder.pluginRepositories(merge(target.getPluginRepositories(), source.getPluginRepositories(), getRepositoryKey(),
                    (t, s) -> mergeRepository(t, s, sourceDominant, context)));
        } else {
            builder.pluginRepositories(merge(target.getPluginRepositories(), source.getPluginRepositories(), sourceDominant, getRepositoryKey()));
        }
    }

    protected Activation mergeActivation(Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        Activation.Builder builder = Activation.newBuilder(target);
        mergeActivation(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeActivation(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        mergeActivation_ActiveByDefault(builder, target, source, sourceDominant, context);
        mergeActivation_Jdk(builder, target, source, sourceDominant, context);
        mergeActivation_Os(builder, target, source, sourceDominant, context);
        mergeActivation_Property(builder, target, source, sourceDominant, context);
        mergeActivation_File(builder, target, source, sourceDominant, context);
    }

    protected void mergeActivation_ActiveByDefault(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.activeByDefault(source.isActiveByDefault());
        }
    }
    protected void mergeActivation_Jdk(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getJdk();
        String tgt = target.getJdk();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.jdk(src);
            builder.location("jdk", source.getLocation("jdk"));
        }
    }
    protected void mergeActivation_Os(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationOS src = source.getOs();
        if (src != null) {
            ActivationOS tgt = target.getOs();
            if (tgt == null) {
                tgt = ActivationOS.newInstance(false);
            }
            ActivationOS merged = mergeActivationOS(tgt, src, sourceDominant, context);
            builder.os(merged);
            if (target.getOs() == null) {
                builder.location("os", source.getLocation("os"));
            } else if (merged != tgt) {
                builder.location("os", new InputLocation(-1, -1));
            }
        }
    }
    protected void mergeActivation_Property(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationProperty src = source.getProperty();
        if (src != null) {
            ActivationProperty tgt = target.getProperty();
            if (tgt == null) {
                tgt = ActivationProperty.newInstance(false);
            }
            ActivationProperty merged = mergeActivationProperty(tgt, src, sourceDominant, context);
            builder.property(merged);
            if (target.getProperty() == null) {
                builder.location("property", source.getLocation("property"));
            } else if (merged != tgt) {
                builder.location("property", new InputLocation(-1, -1));
            }
        }
    }
    protected void mergeActivation_File(Activation.Builder builder, Activation target, Activation source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationFile src = source.getFile();
        if (src != null) {
            ActivationFile tgt = target.getFile();
            if (tgt == null) {
                tgt = ActivationFile.newInstance(false);
            }
            ActivationFile merged = mergeActivationFile(tgt, src, sourceDominant, context);
            builder.file(merged);
            if (target.getFile() == null) {
                builder.location("file", source.getLocation("file"));
            } else if (merged != tgt) {
                builder.location("file", new InputLocation(-1, -1));
            }
        }
    }

    protected RepositoryBase mergeRepositoryBase(RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryBase.Builder builder = RepositoryBase.newBuilder(target);
        mergeRepositoryBase(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeRepositoryBase(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        mergeIdentifiableBase(builder, target, source, sourceDominant, context);
        mergeRepositoryBase_Name(builder, target, source, sourceDominant, context);
        mergeRepositoryBase_Url(builder, target, source, sourceDominant, context);
        mergeRepositoryBase_Layout(builder, target, source, sourceDominant, context);
    }

    protected void mergeRepositoryBase_Id(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location("id", source.getLocation("id"));
        }
    }
    protected void mergeRepositoryBase_Name(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location("name", source.getLocation("name"));
        }
    }
    protected void mergeRepositoryBase_Url(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        String tgt = target.getUrl();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.url(src);
            builder.location("url", source.getLocation("url"));
        }
    }
    protected void mergeRepositoryBase_Layout(RepositoryBase.Builder builder, RepositoryBase target, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getLayout();
        String tgt = target.getLayout();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.layout(src);
            builder.location("layout", source.getLocation("layout"));
        }
    }

    protected Repository mergeRepository(Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        Repository.Builder builder = Repository.newBuilder(target);
        mergeRepository(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeRepository(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        mergeRepositoryBase(builder, target, source, sourceDominant, context);
        mergeRepository_Releases(builder, target, source, sourceDominant, context);
        mergeRepository_Snapshots(builder, target, source, sourceDominant, context);
    }

    protected void mergeRepository_Id(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getId();
        String tgt = target.getId();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.id(src);
            builder.location("id", source.getLocation("id"));
        }
    }
    protected void mergeRepository_Name(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location("name", source.getLocation("name"));
        }
    }
    protected void mergeRepository_Url(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        String tgt = target.getUrl();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.url(src);
            builder.location("url", source.getLocation("url"));
        }
    }
    protected void mergeRepository_Layout(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getLayout();
        String tgt = target.getLayout();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.layout(src);
            builder.location("layout", source.getLocation("layout"));
        }
    }
    protected void mergeRepository_Releases(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryPolicy src = source.getReleases();
        if (src != null) {
            RepositoryPolicy tgt = target.getReleases();
            if (tgt == null) {
                tgt = RepositoryPolicy.newInstance(false);
            }
            RepositoryPolicy merged = mergeRepositoryPolicy(tgt, src, sourceDominant, context);
            builder.releases(merged);
            if (target.getReleases() == null) {
                builder.location("releases", source.getLocation("releases"));
            } else if (merged != tgt) {
                builder.location("releases", new InputLocation(-1, -1));
            }
        }
    }
    protected void mergeRepository_Snapshots(Repository.Builder builder, Repository target, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryPolicy src = source.getSnapshots();
        if (src != null) {
            RepositoryPolicy tgt = target.getSnapshots();
            if (tgt == null) {
                tgt = RepositoryPolicy.newInstance(false);
            }
            RepositoryPolicy merged = mergeRepositoryPolicy(tgt, src, sourceDominant, context);
            builder.snapshots(merged);
            if (target.getSnapshots() == null) {
                builder.location("snapshots", source.getLocation("snapshots"));
            } else if (merged != tgt) {
                builder.location("snapshots", new InputLocation(-1, -1));
            }
        }
    }

    protected RepositoryPolicy mergeRepositoryPolicy(RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryPolicy.Builder builder = RepositoryPolicy.newBuilder(target);
        mergeRepositoryPolicy(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeRepositoryPolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        mergeRepositoryPolicy_Enabled(builder, target, source, sourceDominant, context);
        mergeRepositoryPolicy_UpdatePolicy(builder, target, source, sourceDominant, context);
        mergeRepositoryPolicy_ChecksumPolicy(builder, target, source, sourceDominant, context);
    }

    protected void mergeRepositoryPolicy_Enabled(RepositoryPolicy.Builder builder, RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            builder.enabled(source.isEnabled());
        }
    }
    protected void mergeRepositoryPolicy_UpdatePolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUpdatePolicy();
        String tgt = target.getUpdatePolicy();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.updatePolicy(src);
            builder.location("updatePolicy", source.getLocation("updatePolicy"));
        }
    }
    protected void mergeRepositoryPolicy_ChecksumPolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getChecksumPolicy();
        String tgt = target.getChecksumPolicy();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.checksumPolicy(src);
            builder.location("checksumPolicy", source.getLocation("checksumPolicy"));
        }
    }

    protected ActivationProperty mergeActivationProperty(ActivationProperty target, ActivationProperty source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationProperty.Builder builder = ActivationProperty.newBuilder(target);
        mergeActivationProperty(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeActivationProperty(ActivationProperty.Builder builder, ActivationProperty target, ActivationProperty source, boolean sourceDominant, Map<Object, Object> context) {
        mergeActivationProperty_Name(builder, target, source, sourceDominant, context);
        mergeActivationProperty_Value(builder, target, source, sourceDominant, context);
    }

    protected void mergeActivationProperty_Name(ActivationProperty.Builder builder, ActivationProperty target, ActivationProperty source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location("name", source.getLocation("name"));
        }
    }
    protected void mergeActivationProperty_Value(ActivationProperty.Builder builder, ActivationProperty target, ActivationProperty source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getValue();
        String tgt = target.getValue();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.value(src);
            builder.location("value", source.getLocation("value"));
        }
    }

    protected ActivationOS mergeActivationOS(ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationOS.Builder builder = ActivationOS.newBuilder(target);
        mergeActivationOS(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeActivationOS(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        mergeActivationOS_Name(builder, target, source, sourceDominant, context);
        mergeActivationOS_Family(builder, target, source, sourceDominant, context);
        mergeActivationOS_Arch(builder, target, source, sourceDominant, context);
        mergeActivationOS_Version(builder, target, source, sourceDominant, context);
    }

    protected void mergeActivationOS_Name(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        String tgt = target.getName();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.name(src);
            builder.location("name", source.getLocation("name"));
        }
    }
    protected void mergeActivationOS_Family(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getFamily();
        String tgt = target.getFamily();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.family(src);
            builder.location("family", source.getLocation("family"));
        }
    }
    protected void mergeActivationOS_Arch(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getArch();
        String tgt = target.getArch();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.arch(src);
            builder.location("arch", source.getLocation("arch"));
        }
    }
    protected void mergeActivationOS_Version(ActivationOS.Builder builder, ActivationOS target, ActivationOS source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getVersion();
        String tgt = target.getVersion();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.version(src);
            builder.location("version", source.getLocation("version"));
        }
    }

    protected ActivationFile mergeActivationFile(ActivationFile target, ActivationFile source, boolean sourceDominant, Map<Object, Object> context) {
        ActivationFile.Builder builder = ActivationFile.newBuilder(target);
        mergeActivationFile(builder, target, source, sourceDominant, context);
        return builder.build();
    }

    protected void mergeActivationFile(ActivationFile.Builder builder, ActivationFile target, ActivationFile source, boolean sourceDominant, Map<Object, Object> context) {
        mergeActivationFile_Missing(builder, target, source, sourceDominant, context);
        mergeActivationFile_Exists(builder, target, source, sourceDominant, context);
    }

    protected void mergeActivationFile_Missing(ActivationFile.Builder builder, ActivationFile target, ActivationFile source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getMissing();
        String tgt = target.getMissing();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.missing(src);
            builder.location("missing", source.getLocation("missing"));
        }
    }
    protected void mergeActivationFile_Exists(ActivationFile.Builder builder, ActivationFile target, ActivationFile source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getExists();
        String tgt = target.getExists();
        if (src != null && (sourceDominant || tgt == null)) {
            builder.exists(src);
            builder.location("exists", source.getLocation("exists"));
        }
    }


    protected KeyComputer<TrackableBase> getTrackableBaseKey() {
        return v -> v;
    }
    protected KeyComputer<IdentifiableBase> getIdentifiableBaseKey() {
        return v -> v;
    }
    protected KeyComputer<Settings> getSettingsKey() {
        return v -> v;
    }
    protected KeyComputer<Proxy> getProxyKey() {
        return v -> v;
    }
    protected KeyComputer<Server> getServerKey() {
        return v -> v;
    }
    protected KeyComputer<Mirror> getMirrorKey() {
        return v -> v;
    }
    protected KeyComputer<Profile> getProfileKey() {
        return v -> v;
    }
    protected KeyComputer<Activation> getActivationKey() {
        return v -> v;
    }
    protected KeyComputer<RepositoryBase> getRepositoryBaseKey() {
        return v -> v;
    }
    protected KeyComputer<Repository> getRepositoryKey() {
        return v -> v;
    }
    protected KeyComputer<RepositoryPolicy> getRepositoryPolicyKey() {
        return v -> v;
    }
    protected KeyComputer<ActivationProperty> getActivationPropertyKey() {
        return v -> v;
    }
    protected KeyComputer<ActivationOS> getActivationOSKey() {
        return v -> v;
    }
    protected KeyComputer<ActivationFile> getActivationFileKey() {
        return v -> v;
    }

    /**
     * Use to compute keys for data structures
     * @param <T> the data structure type
     */
    @FunctionalInterface
    public interface KeyComputer<T> extends Function<T, Object> {
    }

    /**
     * Merge two lists
     */
    public static <T> List<T> merge(List<T> tgt, List<T> src, boolean sourceDominant, KeyComputer<T> computer) {
        return merge(tgt, src, computer, (t, s) -> sourceDominant ? s : t);
    }

    public static <T> List<T> merge(List<T> tgt, List<T> src, KeyComputer<T> computer, BinaryOperator<T> remapping) {
        if (src.isEmpty()) {
            return tgt;
        }

        MergingList<T> list;
        if (tgt instanceof MergingList) {
            list = (MergingList<T>) tgt;
        } else {
            list = new MergingList<>(computer, src.size() + tgt.size());
            list.mergeAll(tgt, (t, s) -> s);
        }

        list.mergeAll(src, remapping);
        return list;
    }

    /**
     * Merging list
     * @param <V>
     */
    private static class MergingList<V> extends AbstractList<V> implements java.io.Serializable {

        private final KeyComputer<V> keyComputer;
        private Map<Object, V> map;
        private List<V> list;

        MergingList(KeyComputer<V> keyComputer, int initialCapacity) {
            this.map = new LinkedHashMap<>(initialCapacity);
            this.keyComputer = keyComputer;
        }

        Object writeReplace() throws ObjectStreamException {
            return new ArrayList<>(this);
        }

        @Override
        public Iterator<V> iterator() {
            if (map != null) {
                return map.values().iterator();
            } else {
                return list.iterator();
            }
        }

        void mergeAll(Collection<V> vs, BinaryOperator<V> remapping) {
            if (map == null) {
                map = list.stream().collect(Collectors.toMap(keyComputer,
                    Function.identity(),
                    null,
                    LinkedHashMap::new));
                list = null;
            }

            if (vs instanceof MergingList && ((MergingList<V>) vs).map != null) {
                for (Map.Entry<Object, V> e : ((MergingList<V>) vs).map.entrySet()) {
                    Object key = e.getKey();
                    V v = e.getValue();
                    map.merge(key, v, remapping);
                }
            } else {
                for (V v : vs) {
                    Object key = keyComputer.apply(v);
                    map.merge(key, v, remapping);
                }
            }
        }

        @Override
        public boolean contains(Object o) {
            if (map != null) {
                return map.containsValue(o);
            } else {
                return list.contains(o);
            }
        }

        private List<V> asList() {
            if (list == null) {
                list = new ArrayList<>(map.values());
                map = null;
            }
            return list;
        }

        @Override
        public void add(int index, V element) {
            asList().add(index, element);
        }

        @Override
        public V remove(int index) {
            return asList().remove(index);
        }

        @Override
        public V get(int index) {
            return asList().get(index);
        }

        @Override
        public int size() {
            if (map != null) {
                return map.size();
            } else {
                return list.size();
            }
        }
    }
}
