// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from writer-stax.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.settings.v4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeBuilder;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.InputSource;
import org.codehaus.stax2.util.StreamWriterDelegate;

import static javax.xml.XMLConstants.W3C_XML_SCHEMA_INSTANCE_NS_URI;

@Generated
public class SettingsStaxWriter {

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Default namespace.
     */
    private static final String NAMESPACE = "http://maven.apache.org/SETTINGS/1.2.0";

    /**
     * Default schemaLocation.
     */
    private static final String SCHEMA_LOCATION = "http://maven.apache.org/xsd/settings-1.2.0.xsd";

    /**
     * Field namespace.
     */
    private String namespace = NAMESPACE;

    /**
     * Field schemaLocation.
     */
    private String schemaLocation = SCHEMA_LOCATION;

    /**
     * Field fileComment.
     */
    private String fileComment = null;

    private boolean addLocationInformation = true;

    /**
     * Field stringFormatter.
     */
    protected InputLocation.StringFormatter stringFormatter;

      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method setNamespace.
     *
     * @param namespace the namespace to use.
     */
    public void setNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    } //-- void setNamespace(String)

    /**
     * Method setSchemaLocation.
     *
     * @param schemaLocation the schema location to use.
     */
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        } //-- void setSchemaLocation(String)

    /**
     * Method setFileComment.
     *
     * @param fileComment a fileComment object.
     */
    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    } //-- void setFileComment(String)

    /**
     * Method setAddLocationInformation.
     */
    public void setAddLocationInformation(boolean addLocationInformation) {
        this.addLocationInformation = addLocationInformation;
    } //-- void setAddLocationInformation(String)

    /**
     * Method setStringFormatter.
     *
     * @param stringFormatter
     */
    public void setStringFormatter(InputLocation.StringFormatter stringFormatter) {
        this.stringFormatter = stringFormatter;
    } //-- void setStringFormatter(InputLocation.StringFormatter)

    /**
     * Method write.
     *
     * @param writer a writer object
     * @param settings a Settings object
     * @throws IOException IOException if any
     */
    public void write(Writer writer, Settings settings) throws IOException, XMLStreamException {
        XMLOutputFactory factory = new com.ctc.wstx.stax.WstxOutputFactory();
        factory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, false);
        factory.setProperty(com.ctc.wstx.api.WstxOutputProperties.P_USE_DOUBLE_QUOTES_IN_XML_DECL, true);
        factory.setProperty(com.ctc.wstx.api.WstxOutputProperties.P_ADD_SPACE_AFTER_EMPTY_ELEM, true);
        XMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        serializer.writeStartDocument(settings.getModelEncoding(), null);
        writeSettings("settings", settings, serializer);
        serializer.writeEndDocument();
    } //-- void write(Writer, Settings)

    /**
     * Method write.
     *
     * @param stream a stream object
     * @param settings a Settings object
     * @throws IOException IOException if any
     */
    public void write(OutputStream stream, Settings settings) throws IOException, XMLStreamException {
        XMLOutputFactory factory = new com.ctc.wstx.stax.WstxOutputFactory();
        factory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, false);
        factory.setProperty(com.ctc.wstx.api.WstxOutputProperties.P_USE_DOUBLE_QUOTES_IN_XML_DECL, true);
        factory.setProperty(com.ctc.wstx.api.WstxOutputProperties.P_ADD_SPACE_AFTER_EMPTY_ELEM, true);
        XMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, settings.getModelEncoding()));
        serializer.writeStartDocument(settings.getModelEncoding(), null);
        writeSettings("settings", settings, serializer);
        serializer.writeEndDocument();
    } //-- void write(OutputStream, Settings)

    private void writeTrackableBase(String tagName, TrackableBase trackableBase, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (trackableBase != null) {
            serializer.writeStartElement(namespace, tagName);
            serializer.writeEndElement();
        }
    }

    private void writeIdentifiableBase(String tagName, IdentifiableBase identifiableBase, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (identifiableBase != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("id", "default", identifiableBase.getId(), serializer, identifiableBase);
            serializer.writeEndElement();
        }
    }

    private void writeSettings(String tagName, Settings settings, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (settings != null) {
            if (this.fileComment != null) {
                serializer.writeCharacters("\n");
                serializer.writeComment(this.fileComment);
                serializer.writeCharacters("\n");
            }
            serializer.writeStartElement("", tagName, namespace);
            serializer.writeNamespace("", namespace);
            serializer.writeNamespace("xsi", W3C_XML_SCHEMA_INSTANCE_NS_URI);
            serializer.writeAttribute(W3C_XML_SCHEMA_INSTANCE_NS_URI, "schemaLocation", namespace + " " + schemaLocation);
            writeTag("localRepository", null, settings.getLocalRepository(), serializer, settings);
            writeTag("interactiveMode", "true", settings.isInteractiveMode() ? null : "false", serializer, settings);
            writeTag("usePluginRegistry", "false", settings.isUsePluginRegistry() ? "true" : null, serializer, settings);
            writeTag("offline", "false", settings.isOffline() ? "true" : null, serializer, settings);
            writeList("proxies", false, settings.getProxies(), serializer, settings,
                    t -> writeProxy("proxy", t, serializer));
            writeList("servers", false, settings.getServers(), serializer, settings,
                    t -> writeServer("server", t, serializer));
            writeList("mirrors", false, settings.getMirrors(), serializer, settings,
                    t -> writeMirror("mirror", t, serializer));
            writeList("repositories", false, settings.getRepositories(), serializer, settings,
                    t -> writeRepository("repository", t, serializer));
            writeList("pluginRepositories", false, settings.getPluginRepositories(), serializer, settings,
                    t -> writeRepository("pluginRepository", t, serializer));
            writeList("profiles", false, settings.getProfiles(), serializer, settings,
                    t -> writeProfile("profile", t, serializer));
            writeList("activeProfiles", settings.getActiveProfiles(), serializer, settings,
                    t -> writeTag("activeProfile", null, t, serializer, null));
            writeList("pluginGroups", settings.getPluginGroups(), serializer, settings,
                    t -> writeTag("pluginGroup", null, t, serializer, null));
            serializer.writeEndElement();
        }
    }

    private void writeProxy(String tagName, Proxy proxy, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (proxy != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("active", "true", proxy.getActiveString(), serializer, proxy);
            writeTag("protocol", "http", proxy.getProtocol(), serializer, proxy);
            writeTag("username", null, proxy.getUsername(), serializer, proxy);
            writeTag("password", null, proxy.getPassword(), serializer, proxy);
            writeTag("port", "8080", proxy.getPortString(), serializer, proxy);
            writeTag("host", null, proxy.getHost(), serializer, proxy);
            writeTag("nonProxyHosts", null, proxy.getNonProxyHosts(), serializer, proxy);
            writeTag("id", "default", proxy.getId(), serializer, proxy);
            serializer.writeEndElement();
        }
    }

    private void writeServer(String tagName, Server server, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (server != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("username", null, server.getUsername(), serializer, server);
            writeTag("password", null, server.getPassword(), serializer, server);
            writeTag("privateKey", null, server.getPrivateKey(), serializer, server);
            writeTag("passphrase", null, server.getPassphrase(), serializer, server);
            writeTag("filePermissions", null, server.getFilePermissions(), serializer, server);
            writeTag("directoryPermissions", null, server.getDirectoryPermissions(), serializer, server);
            writeDom(server.getConfiguration(), serializer);
            writeTag("id", "default", server.getId(), serializer, server);
            serializer.writeEndElement();
        }
    }

    private void writeMirror(String tagName, Mirror mirror, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (mirror != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("mirrorOf", null, mirror.getMirrorOf(), serializer, mirror);
            writeTag("name", null, mirror.getName(), serializer, mirror);
            writeTag("url", null, mirror.getUrl(), serializer, mirror);
            writeTag("layout", "default", mirror.getLayout(), serializer, mirror);
            writeTag("mirrorOfLayouts", "default,legacy", mirror.getMirrorOfLayouts(), serializer, mirror);
            writeTag("blocked", "false", mirror.isBlocked() ? "true" : null, serializer, mirror);
            writeTag("id", "default", mirror.getId(), serializer, mirror);
            serializer.writeEndElement();
        }
    }

    private void writeProfile(String tagName, Profile profile, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (profile != null) {
            serializer.writeStartElement(namespace, tagName);
            writeActivation("activation", profile.getActivation(), serializer);
            writeProperties("properties", profile.getProperties(), serializer, profile);
            writeList("repositories", false, profile.getRepositories(), serializer, profile,
                    t -> writeRepository("repository", t, serializer));
            writeList("pluginRepositories", false, profile.getPluginRepositories(), serializer, profile,
                    t -> writeRepository("pluginRepository", t, serializer));
            writeTag("id", "default", profile.getId(), serializer, profile);
            serializer.writeEndElement();
        }
    }

    private void writeActivation(String tagName, Activation activation, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (activation != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("activeByDefault", "false", activation.isActiveByDefault() ? "true" : null, serializer, activation);
            writeTag("jdk", null, activation.getJdk(), serializer, activation);
            writeActivationOS("os", activation.getOs(), serializer);
            writeActivationProperty("property", activation.getProperty(), serializer);
            writeActivationFile("file", activation.getFile(), serializer);
            writeTag("packaging", null, activation.getPackaging(), serializer, activation);
            serializer.writeEndElement();
        }
    }

    private void writeRepositoryBase(String tagName, RepositoryBase repositoryBase, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (repositoryBase != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("name", null, repositoryBase.getName(), serializer, repositoryBase);
            writeTag("url", null, repositoryBase.getUrl(), serializer, repositoryBase);
            writeTag("layout", "default", repositoryBase.getLayout(), serializer, repositoryBase);
            writeTag("id", "default", repositoryBase.getId(), serializer, repositoryBase);
            serializer.writeEndElement();
        }
    }

    private void writeRepository(String tagName, Repository repository, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (repository != null) {
            serializer.writeStartElement(namespace, tagName);
            writeRepositoryPolicy("releases", repository.getReleases(), serializer);
            writeRepositoryPolicy("snapshots", repository.getSnapshots(), serializer);
            writeTag("name", null, repository.getName(), serializer, repository);
            writeTag("url", null, repository.getUrl(), serializer, repository);
            writeTag("layout", "default", repository.getLayout(), serializer, repository);
            writeTag("id", "default", repository.getId(), serializer, repository);
            serializer.writeEndElement();
        }
    }

    private void writeRepositoryPolicy(String tagName, RepositoryPolicy repositoryPolicy, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (repositoryPolicy != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("enabled", "true", repositoryPolicy.isEnabled() ? null : "false", serializer, repositoryPolicy);
            writeTag("updatePolicy", null, repositoryPolicy.getUpdatePolicy(), serializer, repositoryPolicy);
            writeTag("checksumPolicy", null, repositoryPolicy.getChecksumPolicy(), serializer, repositoryPolicy);
            serializer.writeEndElement();
        }
    }

    private void writeActivationProperty(String tagName, ActivationProperty activationProperty, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (activationProperty != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("name", null, activationProperty.getName(), serializer, activationProperty);
            writeTag("value", null, activationProperty.getValue(), serializer, activationProperty);
            serializer.writeEndElement();
        }
    }

    private void writeActivationOS(String tagName, ActivationOS activationOS, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (activationOS != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("name", null, activationOS.getName(), serializer, activationOS);
            writeTag("family", null, activationOS.getFamily(), serializer, activationOS);
            writeTag("arch", null, activationOS.getArch(), serializer, activationOS);
            writeTag("version", null, activationOS.getVersion(), serializer, activationOS);
            serializer.writeEndElement();
        }
    }

    private void writeActivationFile(String tagName, ActivationFile activationFile, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (activationFile != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("missing", null, activationFile.getMissing(), serializer, activationFile);
            writeTag("exists", null, activationFile.getExists(), serializer, activationFile);
            serializer.writeEndElement();
        }
    }

    @FunctionalInterface
    private interface ElementWriter<T> {
        public void write(T t) throws IOException, XMLStreamException;
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        writeList(tagName, false, list, serializer, locationTracker, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(namespace, tagName);
            }
            int index = 0;
            InputLocation location = locationTracker != null ? locationTracker.getLocation(tagName) : null;
            for (T t : list) {
                writer.write(t);
                writeLocationTracking(location, Integer.valueOf(index++), serializer);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(namespace, tagName);
            InputLocation location = locationTracker != null ? locationTracker.getLocation(tagName) : null;
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                writeTag(key, null, entry.getValue(), serializer, null);
                writeLocationTracking(location, key, serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(namespace, dom.getName());
            for (Map.Entry<String, String> attr : dom.getAttributes().entrySet()) {
                if (attr.getKey().startsWith("xml:")) {
                    serializer.writeAttribute("http://www.w3.org/XML/1998/namespace",
                    attr.getKey().substring(4), attr.getValue());
                } else {
                    serializer.writeAttribute(attr.getKey(), attr.getValue());
                }
            }
            for (XmlNode child : dom.getChildren()) {
                writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
            if (addLocationInformation && dom.getInputLocation() instanceof InputLocation && dom.getChildren().isEmpty()) {
                serializer.writeComment(toString((InputLocation) dom.getInputLocation()));
            }
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(namespace, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
            writeLocationTracking(locationTracker, tagName, serializer);
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    /**
     * Method writeLocationTracking.
     *
     * @param locationTracker
     * @param serializer
     * @param key
     * @throws IOException
     */
    protected void writeLocationTracking(InputLocationTracker locationTracker, Object key, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (addLocationInformation) {
            InputLocation location = (locationTracker == null) ? null : locationTracker.getLocation(key);
            if (location != null) {
                serializer.writeComment(toString(location));
            }
        }
    } //-- void writeLocationTracking(InputLocationTracker, Object, XMLStreamWriter)

    /**
     * Method toString.
     *
     * @param location
     * @return String
     */
    protected String toString(InputLocation location) {
        if (stringFormatter != null) {
            return stringFormatter.toString(location);
        }
        if (location.getSource() != null) {
            return ' ' + location.getSource().toString() + ':' + location.getLineNumber() + ' ';
        } else {
            return " " + location.getLineNumber() + " ";
        }
    } //-- String toString(InputLocation)

    static class IndentingXMLStreamWriter extends StreamWriterDelegate {

        int depth = 0;
        boolean hasChildren = false;

        public IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            indent();
            super.writeEmptyElement(localName);
            hasChildren = true;
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            indent();
            super.writeEmptyElement(namespaceURI, localName);
            hasChildren = true;
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            hasChildren = true;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            indent();
            super.writeStartElement(localName);
            depth++;
            hasChildren = false;
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            indent();
            super.writeStartElement(namespaceURI, localName);
            depth++;
            hasChildren = false;
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            depth++;
            hasChildren = false;
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            depth--;
            if (hasChildren) {
                indent();
            }
            super.writeEndElement();
            hasChildren = true;
        }

        private void indent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < depth; i++) {
                super.writeCharacters("  ");
            }
        }
    }
}
