// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.settings.v4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.internal.xml.DomBuilder;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationFile;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Generated
public class SettingsXpp3Reader
{
    private boolean addDefaultEntities = true;

    private final ContentTransformer contentTransformer;

    public SettingsXpp3Reader()
    {
        this( ( s, f ) -> s );
    }

    public SettingsXpp3Reader( ContentTransformer contentTransformer )
    {
        this.contentTransformer = contentTransformer;
    }

    /**
     * Method checkFieldWithDuplicate.
     *
     * @param parser a parser object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, Set<String> parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, Set<String> )

    /**
     * Method checkUnknownAttribute.
     *
     * @param parser a parser object.
     * @param strict a strict object.
     * @param tagName a tagName object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     *
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     *
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     *
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     *
     * @param s a s object.
     * @param defaultValue a defaultValue object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     *
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     *
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     *
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     *
     * @param s a s object.
     * @param parser a parser object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     *
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     *
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     *
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        return getIntegerValue( s, attribute, parser, strict, 0 );
    } //-- int getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getIntegerValue.
     *
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict, int defaultValue )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return defaultValue;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean, int )

    /**
     * Method getLongValue.
     *
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     *
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     *
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     *
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method interpolatedTrimmed.
     *
     * @param value a value object.
     * @param context a context object.
     * @return String
     */
    private String interpolatedTrimmed( String value, String context )
    {
        return getTrimmedValue( contentTransformer.transform( value, context ) );
    } //-- String interpolatedTrimmed( String, String )

    /**
     * Method nextTag.
     *
     * @param parser a parser object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * @see ReaderFactory#newXmlReader
     *
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Settings
     */
    public Settings read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- Settings read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     *
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Settings
     */
    public Settings read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- Settings read( Reader )

    /**
     * Method read.
     *
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Settings
     */
    public Settings read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- Settings read( InputStream, boolean )

    /**
     * Method read.
     *
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Settings
     */
    public Settings read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- Settings read( InputStream )

    /**
     * Method read.
     *
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Settings
     */
    public Settings read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        Settings settings = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "settings".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'settings' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'settings'", parser, null );
                }
                settings = parseSettings( parser, strict );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return settings;
        }
        throw new XmlPullParserException( "Expected root element 'settings' but found no element at all: invalid XML document", parser, null );
    } //-- Settings read( XmlPullParser, boolean )

    private TrackableBase parseTrackableBase( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        TrackableBase.Builder trackableBase = TrackableBase.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return trackableBase.build();
    }

    private IdentifiableBase parseIdentifiableBase( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        IdentifiableBase.Builder identifiableBase = IdentifiableBase.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "id":
                {
                    identifiableBase.id( interpolatedTrimmed( parser.nextText(), "id" ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return identifiableBase.build();
    }

    private Settings parseSettings( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Settings.Builder settings = Settings.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "localRepository":
                {
                    settings.localRepository( interpolatedTrimmed( parser.nextText(), "localRepository" ) );
                    break;
                }
                case "interactiveMode":
                {
                    settings.interactiveMode( getBooleanValue( interpolatedTrimmed( parser.nextText(), "interactiveMode" ), "interactiveMode", parser, "true" ) );
                    break;
                }
                case "usePluginRegistry":
                {
                    settings.usePluginRegistry( getBooleanValue( interpolatedTrimmed( parser.nextText(), "usePluginRegistry" ), "usePluginRegistry", parser, "false" ) );
                    break;
                }
                case "offline":
                {
                    settings.offline( getBooleanValue( interpolatedTrimmed( parser.nextText(), "offline" ), "offline", parser, "false" ) );
                    break;
                }
                case "proxies":
                {
                    List<Proxy> proxies = new ArrayList<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        if ( "proxy".equals( parser.getName() ) )
                        {
                            proxies.add( parseProxy( parser, strict ) );
                        }
                        else
                        {
                            checkUnknownElement( parser, strict );
                        }
                    }
                    settings.proxies( proxies );
                    break;
                }
                case "servers":
                {
                    List<Server> servers = new ArrayList<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        if ( "server".equals( parser.getName() ) )
                        {
                            servers.add( parseServer( parser, strict ) );
                        }
                        else
                        {
                            checkUnknownElement( parser, strict );
                        }
                    }
                    settings.servers( servers );
                    break;
                }
                case "mirrors":
                {
                    List<Mirror> mirrors = new ArrayList<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        if ( "mirror".equals( parser.getName() ) )
                        {
                            mirrors.add( parseMirror( parser, strict ) );
                        }
                        else
                        {
                            checkUnknownElement( parser, strict );
                        }
                    }
                    settings.mirrors( mirrors );
                    break;
                }
                case "profiles":
                {
                    List<Profile> profiles = new ArrayList<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        if ( "profile".equals( parser.getName() ) )
                        {
                            profiles.add( parseProfile( parser, strict ) );
                        }
                        else
                        {
                            checkUnknownElement( parser, strict );
                        }
                    }
                    settings.profiles( profiles );
                    break;
                }
                case "activeProfiles":
                {
                    List<String> activeProfiles = new ArrayList<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        if ( "activeProfile".equals( parser.getName() ) )
                        {
                            activeProfiles.add( interpolatedTrimmed( parser.nextText(), "activeProfiles" ) );
                        }
                        else
                        {
                            checkUnknownElement( parser, strict );
                        }
                    }
                    settings.activeProfiles( activeProfiles );
                    break;
                }
                case "pluginGroups":
                {
                    List<String> pluginGroups = new ArrayList<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        if ( "pluginGroup".equals( parser.getName() ) )
                        {
                            pluginGroups.add( interpolatedTrimmed( parser.nextText(), "pluginGroups" ) );
                        }
                        else
                        {
                            checkUnknownElement( parser, strict );
                        }
                    }
                    settings.pluginGroups( pluginGroups );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        settings.modelEncoding( parser.getInputEncoding() );
        return settings.build();
    }

    private Proxy parseProxy( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Proxy.Builder proxy = Proxy.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "id":
                {
                    proxy.id( interpolatedTrimmed( parser.nextText(), "id" ) );
                    break;
                }
                case "active":
                {
                    proxy.active( getBooleanValue( interpolatedTrimmed( parser.nextText(), "active" ), "active", parser, "true" ) );
                    break;
                }
                case "protocol":
                {
                    proxy.protocol( interpolatedTrimmed( parser.nextText(), "protocol" ) );
                    break;
                }
                case "username":
                {
                    proxy.username( interpolatedTrimmed( parser.nextText(), "username" ) );
                    break;
                }
                case "password":
                {
                    proxy.password( interpolatedTrimmed( parser.nextText(), "password" ) );
                    break;
                }
                case "port":
                {
                    proxy.port( getIntegerValue( interpolatedTrimmed( parser.nextText(), "port" ), "port", parser, strict, 8080 ) );
                    break;
                }
                case "host":
                {
                    proxy.host( interpolatedTrimmed( parser.nextText(), "host" ) );
                    break;
                }
                case "nonProxyHosts":
                {
                    proxy.nonProxyHosts( interpolatedTrimmed( parser.nextText(), "nonProxyHosts" ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return proxy.build();
    }

    private Server parseServer( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Server.Builder server = Server.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "id":
                {
                    server.id( interpolatedTrimmed( parser.nextText(), "id" ) );
                    break;
                }
                case "username":
                {
                    server.username( interpolatedTrimmed( parser.nextText(), "username" ) );
                    break;
                }
                case "password":
                {
                    server.password( interpolatedTrimmed( parser.nextText(), "password" ) );
                    break;
                }
                case "privateKey":
                {
                    server.privateKey( interpolatedTrimmed( parser.nextText(), "privateKey" ) );
                    break;
                }
                case "passphrase":
                {
                    server.passphrase( interpolatedTrimmed( parser.nextText(), "passphrase" ) );
                    break;
                }
                case "filePermissions":
                {
                    server.filePermissions( interpolatedTrimmed( parser.nextText(), "filePermissions" ) );
                    break;
                }
                case "directoryPermissions":
                {
                    server.directoryPermissions( interpolatedTrimmed( parser.nextText(), "directoryPermissions" ) );
                    break;
                }
                case "configuration":
                {
                    server.configuration( DomBuilder.build( parser, true ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return server.build();
    }

    private Mirror parseMirror( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Mirror.Builder mirror = Mirror.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "id":
                {
                    mirror.id( interpolatedTrimmed( parser.nextText(), "id" ) );
                    break;
                }
                case "mirrorOf":
                {
                    mirror.mirrorOf( interpolatedTrimmed( parser.nextText(), "mirrorOf" ) );
                    break;
                }
                case "name":
                {
                    mirror.name( interpolatedTrimmed( parser.nextText(), "name" ) );
                    break;
                }
                case "url":
                {
                    mirror.url( interpolatedTrimmed( parser.nextText(), "url" ) );
                    break;
                }
                case "layout":
                {
                    mirror.layout( interpolatedTrimmed( parser.nextText(), "layout" ) );
                    break;
                }
                case "mirrorOfLayouts":
                {
                    mirror.mirrorOfLayouts( interpolatedTrimmed( parser.nextText(), "mirrorOfLayouts" ) );
                    break;
                }
                case "blocked":
                {
                    mirror.blocked( getBooleanValue( interpolatedTrimmed( parser.nextText(), "blocked" ), "blocked", parser, "false" ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return mirror.build();
    }

    private Profile parseProfile( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Profile.Builder profile = Profile.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "id":
                {
                    profile.id( interpolatedTrimmed( parser.nextText(), "id" ) );
                    break;
                }
                case "activation":
                {
                    profile.activation( parseActivation( parser, strict ) );
                    break;
                }
                case "properties":
                {
                    Map<String, String> properties = new LinkedHashMap<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        String key = parser.getName();
                        String value = parser.nextText().trim();
                        properties.put( key, value );
                    }
                    profile.properties( properties );
                    break;
                }
                case "repositories":
                {
                    List<Repository> repositories = new ArrayList<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        if ( "repository".equals( parser.getName() ) )
                        {
                            repositories.add( parseRepository( parser, strict ) );
                        }
                        else
                        {
                            checkUnknownElement( parser, strict );
                        }
                    }
                    profile.repositories( repositories );
                    break;
                }
                case "pluginRepositories":
                {
                    List<Repository> pluginRepositories = new ArrayList<>();
                    while ( parser.nextTag() == XmlPullParser.START_TAG )
                    {
                        if ( "pluginRepository".equals( parser.getName() ) )
                        {
                            pluginRepositories.add( parseRepository( parser, strict ) );
                        }
                        else
                        {
                            checkUnknownElement( parser, strict );
                        }
                    }
                    profile.pluginRepositories( pluginRepositories );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return profile.build();
    }

    private Activation parseActivation( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Activation.Builder activation = Activation.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "activeByDefault":
                {
                    activation.activeByDefault( getBooleanValue( interpolatedTrimmed( parser.nextText(), "activeByDefault" ), "activeByDefault", parser, "false" ) );
                    break;
                }
                case "jdk":
                {
                    activation.jdk( interpolatedTrimmed( parser.nextText(), "jdk" ) );
                    break;
                }
                case "os":
                {
                    activation.os( parseActivationOS( parser, strict ) );
                    break;
                }
                case "property":
                {
                    activation.property( parseActivationProperty( parser, strict ) );
                    break;
                }
                case "file":
                {
                    activation.file( parseActivationFile( parser, strict ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return activation.build();
    }

    private RepositoryBase parseRepositoryBase( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        RepositoryBase.Builder repositoryBase = RepositoryBase.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "id":
                {
                    repositoryBase.id( interpolatedTrimmed( parser.nextText(), "id" ) );
                    break;
                }
                case "name":
                {
                    repositoryBase.name( interpolatedTrimmed( parser.nextText(), "name" ) );
                    break;
                }
                case "url":
                {
                    repositoryBase.url( interpolatedTrimmed( parser.nextText(), "url" ) );
                    break;
                }
                case "layout":
                {
                    repositoryBase.layout( interpolatedTrimmed( parser.nextText(), "layout" ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return repositoryBase.build();
    }

    private Repository parseRepository( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Repository.Builder repository = Repository.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "id":
                {
                    repository.id( interpolatedTrimmed( parser.nextText(), "id" ) );
                    break;
                }
                case "name":
                {
                    repository.name( interpolatedTrimmed( parser.nextText(), "name" ) );
                    break;
                }
                case "url":
                {
                    repository.url( interpolatedTrimmed( parser.nextText(), "url" ) );
                    break;
                }
                case "layout":
                {
                    repository.layout( interpolatedTrimmed( parser.nextText(), "layout" ) );
                    break;
                }
                case "releases":
                {
                    repository.releases( parseRepositoryPolicy( parser, strict ) );
                    break;
                }
                case "snapshots":
                {
                    repository.snapshots( parseRepositoryPolicy( parser, strict ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return repository.build();
    }

    private RepositoryPolicy parseRepositoryPolicy( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        RepositoryPolicy.Builder repositoryPolicy = RepositoryPolicy.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "enabled":
                {
                    repositoryPolicy.enabled( getBooleanValue( interpolatedTrimmed( parser.nextText(), "enabled" ), "enabled", parser, "true" ) );
                    break;
                }
                case "updatePolicy":
                {
                    repositoryPolicy.updatePolicy( interpolatedTrimmed( parser.nextText(), "updatePolicy" ) );
                    break;
                }
                case "checksumPolicy":
                {
                    repositoryPolicy.checksumPolicy( interpolatedTrimmed( parser.nextText(), "checksumPolicy" ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return repositoryPolicy.build();
    }

    private ActivationProperty parseActivationProperty( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ActivationProperty.Builder activationProperty = ActivationProperty.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "name":
                {
                    activationProperty.name( interpolatedTrimmed( parser.nextText(), "name" ) );
                    break;
                }
                case "value":
                {
                    activationProperty.value( interpolatedTrimmed( parser.nextText(), "value" ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return activationProperty.build();
    }

    private ActivationOS parseActivationOS( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ActivationOS.Builder activationOS = ActivationOS.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "name":
                {
                    activationOS.name( interpolatedTrimmed( parser.nextText(), "name" ) );
                    break;
                }
                case "family":
                {
                    activationOS.family( interpolatedTrimmed( parser.nextText(), "family" ) );
                    break;
                }
                case "arch":
                {
                    activationOS.arch( interpolatedTrimmed( parser.nextText(), "arch" ) );
                    break;
                }
                case "version":
                {
                    activationOS.version( interpolatedTrimmed( parser.nextText(), "version" ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return activationOS.build();
    }

    private ActivationFile parseActivationFile( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ActivationFile.Builder activationFile = ActivationFile.newBuilder( true );
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );
            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        Set<String> parsed = new HashSet<>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            String childName = checkDuplicate( parser.getName(), parser, parsed );
            switch ( childName )
            {
                case "missing":
                {
                    activationFile.missing( interpolatedTrimmed( parser.nextText(), "missing" ) );
                    break;
                }
                case "exists":
                {
                    activationFile.exists( interpolatedTrimmed( parser.nextText(), "exists" ) );
                    break;
                }
                default:
                {
                    checkUnknownElement( parser, strict );
                    break;
                }
            }
        }
        return activationFile.build();
    }


    private String checkDuplicate( String tagName, XmlPullParser parser, Set<String> parsed )
        throws XmlPullParserException
    {
        return tagName;
    }

    /**
     * Sets the state of the "add default entities" flag.
     *
     * @param addDefaultEntities a addDefaultEntities object.
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

    public static interface ContentTransformer
    {
        /**
         * Interpolate the value read from the xpp3 document
         * @param source The source value
         * @param fieldName A description of the field being interpolated. The implementation may use this to
         *                           log stuff.
         * @return The interpolated value.
         */
        String transform( String source, String fieldName );
    }

}
