// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from transformer.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.settings.v4;

import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputSource;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Generated
public class SettingsTransformer {

    private final Function<String, String> transformer;

    public SettingsTransformer(Function<String, String> transformer) {
        this.transformer = transformer;
    }

    /**
     * Transforms the given model
     */
    public Settings visit(Settings target) {
        Objects.requireNonNull(target, "target cannot be null");
        return transformSettings(target);
    }

    /**
     * The transformation function.
     */
    protected String transform(String value) {
        return transformer.apply(value);
    }

    protected TrackableBase transformTrackableBase(TrackableBase target) {
        if (target == null) {
            return null;
        }
        TrackableBase.Builder builder = TrackableBase.newBuilder(target);
        return builder.build();
    }


    protected IdentifiableBase transformIdentifiableBase(IdentifiableBase target) {
        if (target == null) {
            return null;
        }
        IdentifiableBase.Builder builder = IdentifiableBase.newBuilder(target);
        transformIdentifiableBase_Id(builder, target);
        return builder.build();
    }

    protected void transformIdentifiableBase_Id(IdentifiableBase.Builder builder, IdentifiableBase target) {
        String newVal = transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Settings transformSettings(Settings target) {
        if (target == null) {
            return null;
        }
        Settings.Builder builder = Settings.newBuilder(target);
        transformSettings_LocalRepository(builder, target);
        transformSettings_InteractiveMode(builder, target);
        transformSettings_UsePluginRegistry(builder, target);
        transformSettings_Offline(builder, target);
        transformSettings_Proxies(builder, target);
        transformSettings_Servers(builder, target);
        transformSettings_Mirrors(builder, target);
        transformSettings_Repositories(builder, target);
        transformSettings_PluginRepositories(builder, target);
        transformSettings_Profiles(builder, target);
        transformSettings_ActiveProfiles(builder, target);
        transformSettings_PluginGroups(builder, target);
        return builder.build();
    }

    protected void transformSettings_LocalRepository(Settings.Builder builder, Settings target) {
        String newVal = transform(target.getLocalRepository());
        builder.localRepository(newVal != target.getLocalRepository() ? newVal : null);
    }
    protected void transformSettings_InteractiveMode(Settings.Builder builder, Settings target) {
        // nothing to do, the transformer only handles strings
    }
    protected void transformSettings_UsePluginRegistry(Settings.Builder builder, Settings target) {
        // nothing to do, the transformer only handles strings
    }
    protected void transformSettings_Offline(Settings.Builder builder, Settings target) {
        // nothing to do, the transformer only handles strings
    }
    protected void transformSettings_Proxies(Settings.Builder builder, Settings target) {
        builder.proxies(transform(target.getProxies(), this::transformProxy));
    }
    protected void transformSettings_Servers(Settings.Builder builder, Settings target) {
        builder.servers(transform(target.getServers(), this::transformServer));
    }
    protected void transformSettings_Mirrors(Settings.Builder builder, Settings target) {
        builder.mirrors(transform(target.getMirrors(), this::transformMirror));
    }
    protected void transformSettings_Repositories(Settings.Builder builder, Settings target) {
        builder.repositories(transform(target.getRepositories(), this::transformRepository));
    }
    protected void transformSettings_PluginRepositories(Settings.Builder builder, Settings target) {
        builder.pluginRepositories(transform(target.getPluginRepositories(), this::transformRepository));
    }
    protected void transformSettings_Profiles(Settings.Builder builder, Settings target) {
        builder.profiles(transform(target.getProfiles(), this::transformProfile));
    }
    protected void transformSettings_ActiveProfiles(Settings.Builder builder, Settings target) {
        builder.activeProfiles(transform(target.getActiveProfiles(), this::transform));
    }
    protected void transformSettings_PluginGroups(Settings.Builder builder, Settings target) {
        builder.pluginGroups(transform(target.getPluginGroups(), this::transform));
    }

    protected Proxy transformProxy(Proxy target) {
        if (target == null) {
            return null;
        }
        Proxy.Builder builder = Proxy.newBuilder(target);
        transformProxy_ActiveString(builder, target);
        transformProxy_Protocol(builder, target);
        transformProxy_Username(builder, target);
        transformProxy_Password(builder, target);
        transformProxy_PortString(builder, target);
        transformProxy_Host(builder, target);
        transformProxy_NonProxyHosts(builder, target);
        transformIdentifiableBase_Id(builder, target);
        return builder.build();
    }

    protected void transformProxy_ActiveString(Proxy.Builder builder, Proxy target) {
        String newVal = transform(target.getActiveString());
        builder.activeString(newVal != target.getActiveString() ? newVal : null);
    }
    protected void transformProxy_Protocol(Proxy.Builder builder, Proxy target) {
        String newVal = transform(target.getProtocol());
        builder.protocol(newVal != target.getProtocol() ? newVal : null);
    }
    protected void transformProxy_Username(Proxy.Builder builder, Proxy target) {
        String newVal = transform(target.getUsername());
        builder.username(newVal != target.getUsername() ? newVal : null);
    }
    protected void transformProxy_Password(Proxy.Builder builder, Proxy target) {
        String newVal = transform(target.getPassword());
        builder.password(newVal != target.getPassword() ? newVal : null);
    }
    protected void transformProxy_PortString(Proxy.Builder builder, Proxy target) {
        String newVal = transform(target.getPortString());
        builder.portString(newVal != target.getPortString() ? newVal : null);
    }
    protected void transformProxy_Host(Proxy.Builder builder, Proxy target) {
        String newVal = transform(target.getHost());
        builder.host(newVal != target.getHost() ? newVal : null);
    }
    protected void transformProxy_NonProxyHosts(Proxy.Builder builder, Proxy target) {
        String newVal = transform(target.getNonProxyHosts());
        builder.nonProxyHosts(newVal != target.getNonProxyHosts() ? newVal : null);
    }
    protected void transformProxy_Id(Proxy.Builder builder, Proxy target) {
        String newVal = transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Server transformServer(Server target) {
        if (target == null) {
            return null;
        }
        Server.Builder builder = Server.newBuilder(target);
        transformServer_Username(builder, target);
        transformServer_Password(builder, target);
        transformServer_PrivateKey(builder, target);
        transformServer_Passphrase(builder, target);
        transformServer_FilePermissions(builder, target);
        transformServer_DirectoryPermissions(builder, target);
        transformServer_Configuration(builder, target);
        transformIdentifiableBase_Id(builder, target);
        return builder.build();
    }

    protected void transformServer_Username(Server.Builder builder, Server target) {
        String newVal = transform(target.getUsername());
        builder.username(newVal != target.getUsername() ? newVal : null);
    }
    protected void transformServer_Password(Server.Builder builder, Server target) {
        String newVal = transform(target.getPassword());
        builder.password(newVal != target.getPassword() ? newVal : null);
    }
    protected void transformServer_PrivateKey(Server.Builder builder, Server target) {
        String newVal = transform(target.getPrivateKey());
        builder.privateKey(newVal != target.getPrivateKey() ? newVal : null);
    }
    protected void transformServer_Passphrase(Server.Builder builder, Server target) {
        String newVal = transform(target.getPassphrase());
        builder.passphrase(newVal != target.getPassphrase() ? newVal : null);
    }
    protected void transformServer_FilePermissions(Server.Builder builder, Server target) {
        String newVal = transform(target.getFilePermissions());
        builder.filePermissions(newVal != target.getFilePermissions() ? newVal : null);
    }
    protected void transformServer_DirectoryPermissions(Server.Builder builder, Server target) {
        String newVal = transform(target.getDirectoryPermissions());
        builder.directoryPermissions(newVal != target.getDirectoryPermissions() ? newVal : null);
    }
    protected void transformServer_Configuration(Server.Builder builder, Server target) {
        XmlNode newVal = transform(target.getConfiguration());
        builder.configuration(newVal != target.getConfiguration() ? newVal : null);
    }
    protected void transformServer_Id(Server.Builder builder, Server target) {
        String newVal = transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Mirror transformMirror(Mirror target) {
        if (target == null) {
            return null;
        }
        Mirror.Builder builder = Mirror.newBuilder(target);
        transformMirror_MirrorOf(builder, target);
        transformMirror_Name(builder, target);
        transformMirror_Url(builder, target);
        transformMirror_Layout(builder, target);
        transformMirror_MirrorOfLayouts(builder, target);
        transformMirror_Blocked(builder, target);
        transformIdentifiableBase_Id(builder, target);
        return builder.build();
    }

    protected void transformMirror_MirrorOf(Mirror.Builder builder, Mirror target) {
        String newVal = transform(target.getMirrorOf());
        builder.mirrorOf(newVal != target.getMirrorOf() ? newVal : null);
    }
    protected void transformMirror_Name(Mirror.Builder builder, Mirror target) {
        String newVal = transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }
    protected void transformMirror_Url(Mirror.Builder builder, Mirror target) {
        String newVal = transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }
    protected void transformMirror_Layout(Mirror.Builder builder, Mirror target) {
        String newVal = transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }
    protected void transformMirror_MirrorOfLayouts(Mirror.Builder builder, Mirror target) {
        String newVal = transform(target.getMirrorOfLayouts());
        builder.mirrorOfLayouts(newVal != target.getMirrorOfLayouts() ? newVal : null);
    }
    protected void transformMirror_Blocked(Mirror.Builder builder, Mirror target) {
        // nothing to do, the transformer only handles strings
    }
    protected void transformMirror_Id(Mirror.Builder builder, Mirror target) {
        String newVal = transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Profile transformProfile(Profile target) {
        if (target == null) {
            return null;
        }
        Profile.Builder builder = Profile.newBuilder(target);
        transformProfile_Activation(builder, target);
        transformProfile_Properties(builder, target);
        transformProfile_Repositories(builder, target);
        transformProfile_PluginRepositories(builder, target);
        transformIdentifiableBase_Id(builder, target);
        return builder.build();
    }

    protected void transformProfile_Activation(Profile.Builder builder, Profile target) {
        Activation newVal = transformActivation(target.getActivation());
        builder.activation(newVal != target.getActivation() ? newVal : null);
    }
    protected void transformProfile_Properties(Profile.Builder builder, Profile target) {
        Map<String, String> props = target.getProperties();
        Map<String, String> newProps = null;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String newVal = transform(entry.getValue());
            if (newVal != null && newVal != entry.getValue()) {
                if (newProps == null) {
                    newProps = new HashMap<>();
                    newProps.putAll(props);
                    builder.properties(newProps);
                }
                newProps.put(entry.getKey(), newVal);
            }
        }
    }
    protected void transformProfile_Repositories(Profile.Builder builder, Profile target) {
        builder.repositories(transform(target.getRepositories(), this::transformRepository));
    }
    protected void transformProfile_PluginRepositories(Profile.Builder builder, Profile target) {
        builder.pluginRepositories(transform(target.getPluginRepositories(), this::transformRepository));
    }
    protected void transformProfile_Id(Profile.Builder builder, Profile target) {
        String newVal = transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Activation transformActivation(Activation target) {
        if (target == null) {
            return null;
        }
        Activation.Builder builder = Activation.newBuilder(target);
        transformActivation_ActiveByDefault(builder, target);
        transformActivation_Jdk(builder, target);
        transformActivation_Os(builder, target);
        transformActivation_Property(builder, target);
        transformActivation_File(builder, target);
        return builder.build();
    }

    protected void transformActivation_ActiveByDefault(Activation.Builder builder, Activation target) {
        // nothing to do, the transformer only handles strings
    }
    protected void transformActivation_Jdk(Activation.Builder builder, Activation target) {
        String newVal = transform(target.getJdk());
        builder.jdk(newVal != target.getJdk() ? newVal : null);
    }
    protected void transformActivation_Os(Activation.Builder builder, Activation target) {
        ActivationOS newVal = transformActivationOS(target.getOs());
        builder.os(newVal != target.getOs() ? newVal : null);
    }
    protected void transformActivation_Property(Activation.Builder builder, Activation target) {
        ActivationProperty newVal = transformActivationProperty(target.getProperty());
        builder.property(newVal != target.getProperty() ? newVal : null);
    }
    protected void transformActivation_File(Activation.Builder builder, Activation target) {
        ActivationFile newVal = transformActivationFile(target.getFile());
        builder.file(newVal != target.getFile() ? newVal : null);
    }

    protected RepositoryBase transformRepositoryBase(RepositoryBase target) {
        if (target == null) {
            return null;
        }
        RepositoryBase.Builder builder = RepositoryBase.newBuilder(target);
        transformRepositoryBase_Name(builder, target);
        transformRepositoryBase_Url(builder, target);
        transformRepositoryBase_Layout(builder, target);
        transformIdentifiableBase_Id(builder, target);
        return builder.build();
    }

    protected void transformRepositoryBase_Name(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }
    protected void transformRepositoryBase_Url(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }
    protected void transformRepositoryBase_Layout(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }
    protected void transformRepositoryBase_Id(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected Repository transformRepository(Repository target) {
        if (target == null) {
            return null;
        }
        Repository.Builder builder = Repository.newBuilder(target);
        transformRepository_Releases(builder, target);
        transformRepository_Snapshots(builder, target);
        transformRepositoryBase_Name(builder, target);
        transformRepositoryBase_Url(builder, target);
        transformRepositoryBase_Layout(builder, target);
        transformIdentifiableBase_Id(builder, target);
        return builder.build();
    }

    protected void transformRepository_Releases(Repository.Builder builder, Repository target) {
        RepositoryPolicy newVal = transformRepositoryPolicy(target.getReleases());
        builder.releases(newVal != target.getReleases() ? newVal : null);
    }
    protected void transformRepository_Snapshots(Repository.Builder builder, Repository target) {
        RepositoryPolicy newVal = transformRepositoryPolicy(target.getSnapshots());
        builder.snapshots(newVal != target.getSnapshots() ? newVal : null);
    }
    protected void transformRepository_Name(Repository.Builder builder, Repository target) {
        String newVal = transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }
    protected void transformRepository_Url(Repository.Builder builder, Repository target) {
        String newVal = transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }
    protected void transformRepository_Layout(Repository.Builder builder, Repository target) {
        String newVal = transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }
    protected void transformRepository_Id(Repository.Builder builder, Repository target) {
        String newVal = transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected RepositoryPolicy transformRepositoryPolicy(RepositoryPolicy target) {
        if (target == null) {
            return null;
        }
        RepositoryPolicy.Builder builder = RepositoryPolicy.newBuilder(target);
        transformRepositoryPolicy_Enabled(builder, target);
        transformRepositoryPolicy_UpdatePolicy(builder, target);
        transformRepositoryPolicy_ChecksumPolicy(builder, target);
        return builder.build();
    }

    protected void transformRepositoryPolicy_Enabled(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        // nothing to do, the transformer only handles strings
    }
    protected void transformRepositoryPolicy_UpdatePolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String newVal = transform(target.getUpdatePolicy());
        builder.updatePolicy(newVal != target.getUpdatePolicy() ? newVal : null);
    }
    protected void transformRepositoryPolicy_ChecksumPolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String newVal = transform(target.getChecksumPolicy());
        builder.checksumPolicy(newVal != target.getChecksumPolicy() ? newVal : null);
    }

    protected ActivationProperty transformActivationProperty(ActivationProperty target) {
        if (target == null) {
            return null;
        }
        ActivationProperty.Builder builder = ActivationProperty.newBuilder(target);
        transformActivationProperty_Name(builder, target);
        transformActivationProperty_Value(builder, target);
        return builder.build();
    }

    protected void transformActivationProperty_Name(ActivationProperty.Builder builder, ActivationProperty target) {
        String newVal = transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }
    protected void transformActivationProperty_Value(ActivationProperty.Builder builder, ActivationProperty target) {
        String newVal = transform(target.getValue());
        builder.value(newVal != target.getValue() ? newVal : null);
    }

    protected ActivationOS transformActivationOS(ActivationOS target) {
        if (target == null) {
            return null;
        }
        ActivationOS.Builder builder = ActivationOS.newBuilder(target);
        transformActivationOS_Name(builder, target);
        transformActivationOS_Family(builder, target);
        transformActivationOS_Arch(builder, target);
        transformActivationOS_Version(builder, target);
        return builder.build();
    }

    protected void transformActivationOS_Name(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }
    protected void transformActivationOS_Family(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = transform(target.getFamily());
        builder.family(newVal != target.getFamily() ? newVal : null);
    }
    protected void transformActivationOS_Arch(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = transform(target.getArch());
        builder.arch(newVal != target.getArch() ? newVal : null);
    }
    protected void transformActivationOS_Version(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected ActivationFile transformActivationFile(ActivationFile target) {
        if (target == null) {
            return null;
        }
        ActivationFile.Builder builder = ActivationFile.newBuilder(target);
        transformActivationFile_Missing(builder, target);
        transformActivationFile_Exists(builder, target);
        return builder.build();
    }

    protected void transformActivationFile_Missing(ActivationFile.Builder builder, ActivationFile target) {
        String newVal = transform(target.getMissing());
        builder.missing(newVal != target.getMissing() ? newVal : null);
    }
    protected void transformActivationFile_Exists(ActivationFile.Builder builder, ActivationFile target) {
        String newVal = transform(target.getExists());
        builder.exists(newVal != target.getExists() ? newVal : null);
    }

    protected <T> List<T> transform(List<T> list, Function<T, T> transformer) {
        List<T> newList = null;
        for (int i = 0; i < list.size(); i++) {
            T newVal = transformer.apply(list.get(i));
            if (newVal != list.get(i)) {
                if (newList == null) {
                    newList = new ArrayList<>(list);
                }
                newList.set(i, newVal);
            }
        }
        return newList;
    }

    protected XmlNode transform(XmlNode node) {
        if (node != null) {
            Xpp3Dom xpp = new Xpp3Dom(node);
            transform(xpp);
            return xpp.getDom();
        }
        return node;
    }

    protected void transform(Xpp3Dom dom) {
        if (dom != null) {
            String org, val;
            // Content
            org = dom.getValue();
            val = transform(org);
            if (org != val) {
                dom.setValue(val);
            }
            // Attributes
            for (String attr : dom.getAttributeNames()) {
                org = dom.getAttribute(attr);
                val = transform(org);
                if (org != val) {
                    dom.setAttribute(attr, val);
                }
            }
            // Children
            for (int i = 0, l = dom.getChildCount(); i < l; i++) {
                transform(dom.getChild(i));
            }
        }
    }
}
