/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputSource;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeStaxBuilder;

@Generated
public class SettingsStaxReader {
    private static final Map<String, String> DEFAULT_ENTITIES;
    private boolean addDefaultEntities = true;
    private boolean addLocationInformation = true;
    private final ContentTransformer contentTransformer;

    public SettingsStaxReader() {
        this((s, f) -> s);
    }

    public SettingsStaxReader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    public XMLInputFactory getXMLInputFactory() {
        return InputFactoryHolder.XML_INPUT_FACTORY;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public boolean getAddLocationInformation() {
        return this.addLocationInformation;
    }

    public void setAddLocationInformation(boolean addLocationInformation) {
        this.addLocationInformation = addLocationInformation;
    }

    public Settings read(Reader reader) throws XMLStreamException {
        return this.read(reader, true, null);
    }

    public Settings read(Reader reader, boolean strict, InputSource source) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(reader, source != null ? source.getLocation() : null);
        XMLInputFactory factory = this.getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict, source);
    }

    public Settings read(InputStream in) throws XMLStreamException {
        return this.read(in, true, null);
    }

    public Settings read(InputStream in, boolean strict, InputSource source) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(in, source != null ? source.getLocation() : null);
        XMLInputFactory factory = this.getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict, source);
    }

    public Settings read(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        Settings settings = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 8) {
            if (eventType == 1) {
                if (strict && !"settings".equals(parser.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'settings' but found '" + String.valueOf(parser.getName()) + "'", parser.getLocation(), null);
                }
                if (parsed) {
                    throw new XMLStreamException("Duplicated tag: 'settings'", parser.getLocation(), null);
                }
                settings = this.parseSettings(parser, strict, source);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return settings;
        }
        throw new XMLStreamException("Expected root element 'settings' but found no element at all: invalid XML document", parser.getLocation(), null);
    }

    private TrackableBase parseTrackableBase(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        TrackableBase.Builder trackableBase = TrackableBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            trackableBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                default: 
            }
            this.checkUnknownElement(parser, strict);
            if (!this.addLocationInformation) continue;
            trackableBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return trackableBase.build();
    }

    private IdentifiableBase parseIdentifiableBase(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        IdentifiableBase.Builder identifiableBase = IdentifiableBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            identifiableBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "id": {
                    identifiableBase.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            identifiableBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return identifiableBase.build();
    }

    private Settings parseSettings(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Settings.Builder settings = Settings.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            settings.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns) || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "localRepository": {
                    settings.localRepository(this.interpolatedTrimmed(this.nextText(parser, strict), "localRepository"));
                    break;
                }
                case "interactiveMode": {
                    settings.interactiveMode(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "interactiveMode"), "interactiveMode", parser, true));
                    break;
                }
                case "usePluginRegistry": {
                    settings.usePluginRegistry(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "usePluginRegistry"), "usePluginRegistry", parser, false));
                    break;
                }
                case "offline": {
                    settings.offline(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "offline"), "offline", parser, false));
                    break;
                }
                case "proxies": {
                    ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                    while (parser.nextTag() == 1) {
                        if ("proxy".equals(parser.getLocalName())) {
                            proxies.add(this.parseProxy(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.proxies(proxies);
                    break;
                }
                case "servers": {
                    ArrayList<Server> servers = new ArrayList<Server>();
                    while (parser.nextTag() == 1) {
                        if ("server".equals(parser.getLocalName())) {
                            servers.add(this.parseServer(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.servers(servers);
                    break;
                }
                case "mirrors": {
                    ArrayList<Mirror> mirrors = new ArrayList<Mirror>();
                    while (parser.nextTag() == 1) {
                        if ("mirror".equals(parser.getLocalName())) {
                            mirrors.add(this.parseMirror(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.mirrors(mirrors);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("repository".equals(parser.getLocalName())) {
                            repositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("pluginRepository".equals(parser.getLocalName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.pluginRepositories(pluginRepositories);
                    break;
                }
                case "profiles": {
                    ArrayList<Profile> profiles = new ArrayList<Profile>();
                    while (parser.nextTag() == 1) {
                        if ("profile".equals(parser.getLocalName())) {
                            profiles.add(this.parseProfile(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.profiles(profiles);
                    break;
                }
                case "activeProfiles": {
                    ArrayList<String> activeProfiles = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("activeProfile".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            activeProfiles.add(this.interpolatedTrimmed(this.nextText(parser, strict), "activeProfiles"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.activeProfiles(activeProfiles);
                    break;
                }
                case "pluginGroups": {
                    ArrayList<String> pluginGroups = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("pluginGroup".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            pluginGroups.add(this.interpolatedTrimmed(this.nextText(parser, strict), "pluginGroups"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    settings.pluginGroups(pluginGroups);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            settings.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        settings.namespaceUri(parser.getNamespaceURI());
        settings.modelEncoding(parser.getEncoding());
        return settings.build();
    }

    private Proxy parseProxy(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Proxy.Builder proxy = Proxy.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            proxy.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "active": {
                    proxy.activeString(this.interpolatedTrimmed(this.nextText(parser, strict), "active"));
                    break;
                }
                case "protocol": {
                    proxy.protocol(this.interpolatedTrimmed(this.nextText(parser, strict), "protocol"));
                    break;
                }
                case "username": {
                    proxy.username(this.interpolatedTrimmed(this.nextText(parser, strict), "username"));
                    break;
                }
                case "password": {
                    proxy.password(this.interpolatedTrimmed(this.nextText(parser, strict), "password"));
                    break;
                }
                case "port": {
                    proxy.portString(this.interpolatedTrimmed(this.nextText(parser, strict), "port"));
                    break;
                }
                case "host": {
                    proxy.host(this.interpolatedTrimmed(this.nextText(parser, strict), "host"));
                    break;
                }
                case "nonProxyHosts": {
                    proxy.nonProxyHosts(this.interpolatedTrimmed(this.nextText(parser, strict), "nonProxyHosts"));
                    break;
                }
                case "id": {
                    proxy.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            proxy.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return proxy.build();
    }

    private Server parseServer(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Server.Builder server = Server.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            server.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "username": {
                    server.username(this.interpolatedTrimmed(this.nextText(parser, strict), "username"));
                    break;
                }
                case "password": {
                    server.password(this.interpolatedTrimmed(this.nextText(parser, strict), "password"));
                    break;
                }
                case "privateKey": {
                    server.privateKey(this.interpolatedTrimmed(this.nextText(parser, strict), "privateKey"));
                    break;
                }
                case "passphrase": {
                    server.passphrase(this.interpolatedTrimmed(this.nextText(parser, strict), "passphrase"));
                    break;
                }
                case "filePermissions": {
                    server.filePermissions(this.interpolatedTrimmed(this.nextText(parser, strict), "filePermissions"));
                    break;
                }
                case "directoryPermissions": {
                    server.directoryPermissions(this.interpolatedTrimmed(this.nextText(parser, strict), "directoryPermissions"));
                    break;
                }
                case "configuration": {
                    server.configuration(this.buildXmlNode(parser, source));
                    break;
                }
                case "id": {
                    server.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            server.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return server.build();
    }

    private Mirror parseMirror(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Mirror.Builder mirror = Mirror.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            mirror.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "mirrorOf": {
                    mirror.mirrorOf(this.interpolatedTrimmed(this.nextText(parser, strict), "mirrorOf"));
                    break;
                }
                case "name": {
                    mirror.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    mirror.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    mirror.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                case "mirrorOfLayouts": {
                    mirror.mirrorOfLayouts(this.interpolatedTrimmed(this.nextText(parser, strict), "mirrorOfLayouts"));
                    break;
                }
                case "blocked": {
                    mirror.blocked(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "blocked"), "blocked", parser, false));
                    break;
                }
                case "id": {
                    mirror.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            mirror.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return mirror.build();
    }

    private Profile parseProfile(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Profile.Builder profile = Profile.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            profile.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<String, InputLocation> locations = null;
            switch (childName) {
                case "activation": {
                    profile.activation(this.parseActivation(parser, strict, source));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap<String, InputLocation>();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                        }
                        properties.put(key, value);
                    }
                    profile.properties(properties);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("repository".equals(parser.getLocalName())) {
                            repositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("pluginRepository".equals(parser.getLocalName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.pluginRepositories(pluginRepositories);
                    break;
                }
                case "id": {
                    profile.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            profile.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return profile.build();
    }

    private Activation parseActivation(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Activation.Builder activation = Activation.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activation.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "activeByDefault": {
                    activation.activeByDefault(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "activeByDefault"), "activeByDefault", parser, false));
                    break;
                }
                case "jdk": {
                    activation.jdk(this.interpolatedTrimmed(this.nextText(parser, strict), "jdk"));
                    break;
                }
                case "os": {
                    activation.os(this.parseActivationOS(parser, strict, source));
                    break;
                }
                case "property": {
                    activation.property(this.parseActivationProperty(parser, strict, source));
                    break;
                }
                case "file": {
                    activation.file(this.parseActivationFile(parser, strict, source));
                    break;
                }
                case "packaging": {
                    activation.packaging(this.interpolatedTrimmed(this.nextText(parser, strict), "packaging"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activation.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activation.build();
    }

    private RepositoryBase parseRepositoryBase(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        RepositoryBase.Builder repositoryBase = RepositoryBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repositoryBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    repositoryBase.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    repositoryBase.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    repositoryBase.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                case "id": {
                    repositoryBase.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repositoryBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repositoryBase.build();
    }

    private Repository parseRepository(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Repository.Builder repository = Repository.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repository.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "releases": {
                    repository.releases(this.parseRepositoryPolicy(parser, strict, source));
                    break;
                }
                case "snapshots": {
                    repository.snapshots(this.parseRepositoryPolicy(parser, strict, source));
                    break;
                }
                case "name": {
                    repository.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    repository.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    repository.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                case "id": {
                    repository.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repository.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repository.build();
    }

    private RepositoryPolicy parseRepositoryPolicy(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        RepositoryPolicy.Builder repositoryPolicy = RepositoryPolicy.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repositoryPolicy.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "enabled": {
                    repositoryPolicy.enabled(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "enabled"), "enabled", parser, true));
                    break;
                }
                case "updatePolicy": {
                    repositoryPolicy.updatePolicy(this.interpolatedTrimmed(this.nextText(parser, strict), "updatePolicy"));
                    break;
                }
                case "checksumPolicy": {
                    repositoryPolicy.checksumPolicy(this.interpolatedTrimmed(this.nextText(parser, strict), "checksumPolicy"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repositoryPolicy.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repositoryPolicy.build();
    }

    private ActivationProperty parseActivationProperty(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationProperty.Builder activationProperty = ActivationProperty.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationProperty.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    activationProperty.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "value": {
                    activationProperty.value(this.interpolatedTrimmed(this.nextText(parser, strict), "value"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationProperty.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationProperty.build();
    }

    private ActivationOS parseActivationOS(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationOS.Builder activationOS = ActivationOS.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationOS.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    activationOS.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "family": {
                    activationOS.family(this.interpolatedTrimmed(this.nextText(parser, strict), "family"));
                    break;
                }
                case "arch": {
                    activationOS.arch(this.interpolatedTrimmed(this.nextText(parser, strict), "arch"));
                    break;
                }
                case "version": {
                    activationOS.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationOS.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationOS.build();
    }

    private ActivationFile parseActivationFile(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationFile.Builder activationFile = ActivationFile.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationFile.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "missing": {
                    activationFile.missing(this.interpolatedTrimmed(this.nextText(parser, strict), "missing"));
                    break;
                }
                case "exists": {
                    activationFile.exists(this.interpolatedTrimmed(this.nextText(parser, strict), "exists"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationFile.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationFile.build();
    }

    private String checkDuplicate(String tagName, XMLStreamReader parser, Set<String> parsed) throws XMLStreamException {
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", parser.getLocation(), null);
        }
        return tagName;
    }

    private void checkUnknownAttribute(XMLStreamReader parser, String attribute, String tagName, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser.getLocation(), null);
        }
    }

    private void checkUnknownElement(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + String.valueOf(parser.getName()) + "'", parser.getLocation(), null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = this.nextTag(parser);
            if (eventType == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XMLStreamReader parser) throws XMLStreamException {
        block4: while (true) {
            int next = parser.next();
            switch (next) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
        }
    }

    private String nextText(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        int eventType = parser.getEventType();
        if (eventType != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", parser.getLocation(), null);
        }
        eventType = parser.next();
        StringBuilder result = new StringBuilder();
        while (true) {
            if (eventType == 4 || eventType == 12) {
                result.append(parser.getText());
            } else if (eventType == 9) {
                String val = null;
                if (strict) {
                    throw new XMLStreamException("Entities are not supported in strict mode", parser.getLocation(), null);
                }
                if (this.addDefaultEntities) {
                    val = DEFAULT_ENTITIES.get(parser.getLocalName());
                }
                if (val != null) {
                    result.append(val);
                } else {
                    result.append("&").append(parser.getLocalName()).append(";");
                }
            } else if (eventType != 5) break;
            eventType = parser.next();
        }
        if (eventType != 2) {
            throw new XMLStreamException("TEXT must be immediately followed by END_ELEMENT and not " + eventType, parser.getLocation(), null);
        }
        return result.toString();
    }

    private XmlNode buildXmlNode(XMLStreamReader parser, InputSource source) throws XMLStreamException {
        return XmlNodeStaxBuilder.build((XMLStreamReader)parser, this.addLocationInformation ? p -> new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source) : null);
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader parser, boolean defaultValue) throws XMLStreamException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    static {
        HashMap<String, String> entities = new HashMap<String, String>();
        entities.put("nbsp", "\u00a0");
        entities.put("iexcl", "\u00a1");
        entities.put("cent", "\u00a2");
        entities.put("pound", "\u00a3");
        entities.put("curren", "\u00a4");
        entities.put("yen", "\u00a5");
        entities.put("brvbar", "\u00a6");
        entities.put("sect", "\u00a7");
        entities.put("uml", "\u00a8");
        entities.put("copy", "\u00a9");
        entities.put("ordf", "\u00aa");
        entities.put("laquo", "\u00ab");
        entities.put("not", "\u00ac");
        entities.put("shy", "\u00ad");
        entities.put("reg", "\u00ae");
        entities.put("macr", "\u00af");
        entities.put("deg", "\u00b0");
        entities.put("plusmn", "\u00b1");
        entities.put("sup2", "\u00b2");
        entities.put("sup3", "\u00b3");
        entities.put("acute", "\u00b4");
        entities.put("micro", "\u00b5");
        entities.put("para", "\u00b6");
        entities.put("middot", "\u00b7");
        entities.put("cedil", "\u00b8");
        entities.put("sup1", "\u00b9");
        entities.put("ordm", "\u00ba");
        entities.put("raquo", "\u00bb");
        entities.put("frac14", "\u00bc");
        entities.put("frac12", "\u00bd");
        entities.put("frac34", "\u00be");
        entities.put("iquest", "\u00bf");
        entities.put("Agrave", "\u00c0");
        entities.put("Aacute", "\u00c1");
        entities.put("Acirc", "\u00c2");
        entities.put("Atilde", "\u00c3");
        entities.put("Auml", "\u00c4");
        entities.put("Aring", "\u00c5");
        entities.put("AElig", "\u00c6");
        entities.put("Ccedil", "\u00c7");
        entities.put("Egrave", "\u00c8");
        entities.put("Eacute", "\u00c9");
        entities.put("Ecirc", "\u00ca");
        entities.put("Euml", "\u00cb");
        entities.put("Igrave", "\u00cc");
        entities.put("Iacute", "\u00cd");
        entities.put("Icirc", "\u00ce");
        entities.put("Iuml", "\u00cf");
        entities.put("ETH", "\u00d0");
        entities.put("Ntilde", "\u00d1");
        entities.put("Ograve", "\u00d2");
        entities.put("Oacute", "\u00d3");
        entities.put("Ocirc", "\u00d4");
        entities.put("Otilde", "\u00d5");
        entities.put("Ouml", "\u00d6");
        entities.put("times", "\u00d7");
        entities.put("Oslash", "\u00d8");
        entities.put("Ugrave", "\u00d9");
        entities.put("Uacute", "\u00da");
        entities.put("Ucirc", "\u00db");
        entities.put("Uuml", "\u00dc");
        entities.put("Yacute", "\u00dd");
        entities.put("THORN", "\u00de");
        entities.put("szlig", "\u00df");
        entities.put("agrave", "\u00e0");
        entities.put("aacute", "\u00e1");
        entities.put("acirc", "\u00e2");
        entities.put("atilde", "\u00e3");
        entities.put("auml", "\u00e4");
        entities.put("aring", "\u00e5");
        entities.put("aelig", "\u00e6");
        entities.put("ccedil", "\u00e7");
        entities.put("egrave", "\u00e8");
        entities.put("eacute", "\u00e9");
        entities.put("ecirc", "\u00ea");
        entities.put("euml", "\u00eb");
        entities.put("igrave", "\u00ec");
        entities.put("iacute", "\u00ed");
        entities.put("icirc", "\u00ee");
        entities.put("iuml", "\u00ef");
        entities.put("eth", "\u00f0");
        entities.put("ntilde", "\u00f1");
        entities.put("ograve", "\u00f2");
        entities.put("oacute", "\u00f3");
        entities.put("ocirc", "\u00f4");
        entities.put("otilde", "\u00f5");
        entities.put("ouml", "\u00f6");
        entities.put("divide", "\u00f7");
        entities.put("oslash", "\u00f8");
        entities.put("ugrave", "\u00f9");
        entities.put("uacute", "\u00fa");
        entities.put("ucirc", "\u00fb");
        entities.put("uuml", "\u00fc");
        entities.put("yacute", "\u00fd");
        entities.put("thorn", "\u00fe");
        entities.put("yuml", "\u00ff");
        entities.put("OElig", "\u0152");
        entities.put("oelig", "\u0153");
        entities.put("Scaron", "\u0160");
        entities.put("scaron", "\u0161");
        entities.put("Yuml", "\u0178");
        entities.put("circ", "\u02c6");
        entities.put("tilde", "\u02dc");
        entities.put("ensp", "\u2002");
        entities.put("emsp", "\u2003");
        entities.put("thinsp", "\u2009");
        entities.put("zwnj", "\u200c");
        entities.put("zwj", "\u200d");
        entities.put("lrm", "\u200e");
        entities.put("rlm", "\u200f");
        entities.put("ndash", "\u2013");
        entities.put("mdash", "\u2014");
        entities.put("lsquo", "\u2018");
        entities.put("rsquo", "\u2019");
        entities.put("sbquo", "\u201a");
        entities.put("ldquo", "\u201c");
        entities.put("rdquo", "\u201d");
        entities.put("bdquo", "\u201e");
        entities.put("dagger", "\u2020");
        entities.put("Dagger", "\u2021");
        entities.put("permil", "\u2030");
        entities.put("lsaquo", "\u2039");
        entities.put("rsaquo", "\u203a");
        entities.put("euro", "\u20ac");
        entities.put("fnof", "\u0192");
        entities.put("Alpha", "\u0391");
        entities.put("Beta", "\u0392");
        entities.put("Gamma", "\u0393");
        entities.put("Delta", "\u0394");
        entities.put("Epsilon", "\u0395");
        entities.put("Zeta", "\u0396");
        entities.put("Eta", "\u0397");
        entities.put("Theta", "\u0398");
        entities.put("Iota", "\u0399");
        entities.put("Kappa", "\u039a");
        entities.put("Lambda", "\u039b");
        entities.put("Mu", "\u039c");
        entities.put("Nu", "\u039d");
        entities.put("Xi", "\u039e");
        entities.put("Omicron", "\u039f");
        entities.put("Pi", "\u03a0");
        entities.put("Rho", "\u03a1");
        entities.put("Sigma", "\u03a3");
        entities.put("Tau", "\u03a4");
        entities.put("Upsilon", "\u03a5");
        entities.put("Phi", "\u03a6");
        entities.put("Chi", "\u03a7");
        entities.put("Psi", "\u03a8");
        entities.put("Omega", "\u03a9");
        entities.put("alpha", "\u03b1");
        entities.put("beta", "\u03b2");
        entities.put("gamma", "\u03b3");
        entities.put("delta", "\u03b4");
        entities.put("epsilon", "\u03b5");
        entities.put("zeta", "\u03b6");
        entities.put("eta", "\u03b7");
        entities.put("theta", "\u03b8");
        entities.put("iota", "\u03b9");
        entities.put("kappa", "\u03ba");
        entities.put("lambda", "\u03bb");
        entities.put("mu", "\u03bc");
        entities.put("nu", "\u03bd");
        entities.put("xi", "\u03be");
        entities.put("omicron", "\u03bf");
        entities.put("pi", "\u03c0");
        entities.put("rho", "\u03c1");
        entities.put("sigmaf", "\u03c2");
        entities.put("sigma", "\u03c3");
        entities.put("tau", "\u03c4");
        entities.put("upsilon", "\u03c5");
        entities.put("phi", "\u03c6");
        entities.put("chi", "\u03c7");
        entities.put("psi", "\u03c8");
        entities.put("omega", "\u03c9");
        entities.put("thetasym", "\u03d1");
        entities.put("upsih", "\u03d2");
        entities.put("piv", "\u03d6");
        entities.put("bull", "\u2022");
        entities.put("hellip", "\u2026");
        entities.put("prime", "\u2032");
        entities.put("Prime", "\u2033");
        entities.put("oline", "\u203e");
        entities.put("frasl", "\u2044");
        entities.put("weierp", "\u2118");
        entities.put("image", "\u2111");
        entities.put("real", "\u211c");
        entities.put("trade", "\u2122");
        entities.put("alefsym", "\u2135");
        entities.put("larr", "\u2190");
        entities.put("uarr", "\u2191");
        entities.put("rarr", "\u2192");
        entities.put("darr", "\u2193");
        entities.put("harr", "\u2194");
        entities.put("crarr", "\u21b5");
        entities.put("lArr", "\u21d0");
        entities.put("uArr", "\u21d1");
        entities.put("rArr", "\u21d2");
        entities.put("dArr", "\u21d3");
        entities.put("hArr", "\u21d4");
        entities.put("forall", "\u2200");
        entities.put("part", "\u2202");
        entities.put("exist", "\u2203");
        entities.put("empty", "\u2205");
        entities.put("nabla", "\u2207");
        entities.put("isin", "\u2208");
        entities.put("notin", "\u2209");
        entities.put("ni", "\u220b");
        entities.put("prod", "\u220f");
        entities.put("sum", "\u2211");
        entities.put("minus", "\u2212");
        entities.put("lowast", "\u2217");
        entities.put("radic", "\u221a");
        entities.put("prop", "\u221d");
        entities.put("infin", "\u221e");
        entities.put("ang", "\u2220");
        entities.put("and", "\u2227");
        entities.put("or", "\u2228");
        entities.put("cap", "\u2229");
        entities.put("cup", "\u222a");
        entities.put("int", "\u222b");
        entities.put("there4", "\u2234");
        entities.put("sim", "\u223c");
        entities.put("cong", "\u2245");
        entities.put("asymp", "\u2248");
        entities.put("ne", "\u2260");
        entities.put("equiv", "\u2261");
        entities.put("le", "\u2264");
        entities.put("ge", "\u2265");
        entities.put("sub", "\u2282");
        entities.put("sup", "\u2283");
        entities.put("nsub", "\u2284");
        entities.put("sube", "\u2286");
        entities.put("supe", "\u2287");
        entities.put("oplus", "\u2295");
        entities.put("otimes", "\u2297");
        entities.put("perp", "\u22a5");
        entities.put("sdot", "\u22c5");
        entities.put("lceil", "\u2308");
        entities.put("rceil", "\u2309");
        entities.put("lfloor", "\u230a");
        entities.put("rfloor", "\u230b");
        entities.put("lang", "\u2329");
        entities.put("rang", "\u232a");
        entities.put("loz", "\u25ca");
        entities.put("spades", "\u2660");
        entities.put("clubs", "\u2663");
        entities.put("hearts", "\u2665");
        entities.put("diams", "\u2666");
        DEFAULT_ENTITIES = Collections.unmodifiableMap(entities);
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }

    static class InputFactoryHolder {
        static XMLInputFactory XML_INPUT_FACTORY;

        InputFactoryHolder() {
        }

        static {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XML_INPUT_FACTORY = factory;
        }
    }
}

