// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from reader-stax.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.plugin.lifecycle.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.plugin.descriptor.lifecycle.LifecycleConfiguration;
import org.apache.maven.api.plugin.descriptor.lifecycle.Lifecycle;
import org.apache.maven.api.plugin.descriptor.lifecycle.Phase;
import org.apache.maven.api.plugin.descriptor.lifecycle.Execution;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.xml.XmlService;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;

import static javax.xml.XMLConstants.W3C_XML_SCHEMA_INSTANCE_NS_URI;
import static javax.xml.XMLConstants.XML_NS_URI;
import static javax.xml.XMLConstants.XMLNS_ATTRIBUTE;
import static java.util.Map.entry;

@Generated
public class LifecycleStaxReader {

    public static interface ContentTransformer {
        /**
         * Interpolate the value read from the xpp3 document
         * @param inputSrc The input source value
         * @param fieldName A description of the field being interpolated. The implementation may use this to
         *                           log stuff.
         * @return The interpolated value.
         */
        String transform(String inputSrc, String fieldName);
    }

    static class DefaultEntitiesHolder {
        static final Map<String, String> DEFAULT_ENTITIES;
        static {
            DEFAULT_ENTITIES = doGetDefaultEntities();
        }
    }

    static class InputFactoryHolder {
        static final XMLInputFactory XML_INPUT_FACTORY;
        static {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty(XMLInputFactory.IS_REPLACING_ENTITY_REFERENCES, false);
            XML_INPUT_FACTORY = factory;
        }
    }

    private boolean addDefaultEntities = true;

    private final ContentTransformer contentTransformer;

    public LifecycleStaxReader() {
        this((s, f) -> s);
    }

    public LifecycleStaxReader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    /**
     * Returns the {@link XMLInputFactory} used by this reader.
     *
     * @return the {@link XMLInputFactory} used by this reader.
     */
    public XMLInputFactory getXMLInputFactory() {
        return InputFactoryHolder.XML_INPUT_FACTORY;
    }

    /**
     * Returns the state of the "add default entities" flag.
     *
     * @return boolean
     */
    public boolean getAddDefaultEntities() {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Sets the state of the "add default entities" flag.
     *
     * @param addDefaultEntities a addDefaultEntities object.
     */
    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities(boolean)


    public LifecycleConfiguration read(Reader reader) throws XMLStreamException {
        return read(reader, true);
    }

    /**
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws XMLStreamException XMLStreamException if
     * any.
     * @return LifecycleConfiguration
     */
    public LifecycleConfiguration read(Reader reader, boolean strict) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(reader);
        XMLInputFactory factory = getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return read(parser, strict);
    } //-- LifecycleConfiguration read(Reader, boolean)

    public LifecycleConfiguration read(InputStream in) throws XMLStreamException {
        return read(in, true);
    }

    /**
     * Method read.
     *
     * @param in a in object.
     * @param strict a strict object.
     * @throws XMLStreamException XMLStreamException if
     * any.
     * @return LifecycleConfiguration
     */
    public LifecycleConfiguration read(InputStream in, boolean strict) throws XMLStreamException {
        StreamSource streamSource = new StreamSource(in);
        XMLInputFactory factory = getXMLInputFactory();
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return read(parser, strict);
    } //-- LifecycleConfiguration read(InputStream, boolean)

    /**
     * Method read.
     *
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XMLStreamException XMLStreamException if
     * any.
     * @return LifecycleConfiguration
     */
    public LifecycleConfiguration read(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        LifecycleConfiguration lifecycleConfiguration = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != XMLStreamReader.END_DOCUMENT) {
            if (eventType == XMLStreamReader.START_ELEMENT) {
                if (strict && ! "lifecycles".equals(parser.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'lifecycles' but found '" + parser.getName() + "'", parser.getLocation(), null);
                } else if (parsed) {
                    // fallback, already expected a XMLStreamException due to invalid XML
                    throw new XMLStreamException("Duplicated tag: 'lifecycles'", parser.getLocation(), null);
                }
                lifecycleConfiguration = parseLifecycleConfiguration(parser, strict, parser.getNamespaceURI());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return lifecycleConfiguration;
        }
            throw new XMLStreamException("Expected root element 'lifecycles' but found no element at all: invalid XML document", parser.getLocation(), null);
    } //-- LifecycleConfiguration read(XMLStreamReader, boolean)

    private LifecycleConfiguration parseLifecycleConfiguration(XMLStreamReader parser, boolean strict, String namespace) throws XMLStreamException {
        String tagName = parser.getLocalName();
        LifecycleConfiguration.Builder lifecycleConfiguration = LifecycleConfiguration.newBuilder(true);
        lifecycleConfiguration.namespaceUri(namespace);
        lifecycleConfiguration.modelEncoding(parser.getEncoding());
        for (int i = parser.getAttributeCount() - 1; i >= 0; i--) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if (W3C_XML_SCHEMA_INSTANCE_NS_URI.equals(ns) || XML_NS_URI.equals(ns)) {
                // just ignore attributes with non-default namespace (for example: xsi and xml)
            } else if (XMLNS_ATTRIBUTE.equals(name)) {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            } else {
                checkUnknownAttribute(parser, name, tagName, strict);
            }
        }
        Set<String> parsed = new HashSet<>();
        List<Lifecycle> lifecycles = new ArrayList<>();
        while ((strict ? parser.nextTag() : nextTag(parser)) == XMLStreamReader.START_ELEMENT) {
            checkNamespace(parser, strict, namespace);
            String childName = checkDuplicate(parser.getLocalName(), parser, parsed);
            switch (childName) {
                case "lifecycle": {
                    lifecycles.add(parseLifecycle(parser, strict, namespace));
                    break;
                }
                default: {
                    checkUnknownElement(parser, strict);
                    break;
                }
            }
        }
        lifecycleConfiguration.lifecycles(lifecycles);
        return lifecycleConfiguration.build();
    }

    private Lifecycle parseLifecycle(XMLStreamReader parser, boolean strict, String namespace) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Lifecycle.Builder lifecycle = Lifecycle.newBuilder(true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; i--) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if (W3C_XML_SCHEMA_INSTANCE_NS_URI.equals(ns) || XML_NS_URI.equals(ns)) {
                // just ignore attributes with non-default namespace (for example: xsi and xml)
            } else {
                checkUnknownAttribute(parser, name, tagName, strict);
            }
        }
        Set<String> parsed = new HashSet<>();
        while ((strict ? parser.nextTag() : nextTag(parser)) == XMLStreamReader.START_ELEMENT) {
            checkNamespace(parser, strict, namespace);
            String childName = checkDuplicate(parser.getLocalName(), parser, parsed);
            switch (childName) {
                case "id": {
                    lifecycle.id(interpolatedTrimmed(nextText(parser, strict), "id"));
                    break;
                }
                case "phases": {
                    List<Phase> phases = new ArrayList<>();
                    while (parser.nextTag() == XMLStreamReader.START_ELEMENT) {
                        if ("phase".equals(parser.getLocalName())) {
                            phases.add(parsePhase(parser, strict, namespace));
                        } else {
                            checkUnknownElement(parser, strict);
                        }
                    }
                    lifecycle.phases(phases);
                    break;
                }
                default: {
                    checkUnknownElement(parser, strict);
                    break;
                }
            }
        }
        return lifecycle.build();
    }

    private Phase parsePhase(XMLStreamReader parser, boolean strict, String namespace) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Phase.Builder phase = Phase.newBuilder(true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; i--) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if (W3C_XML_SCHEMA_INSTANCE_NS_URI.equals(ns) || XML_NS_URI.equals(ns)) {
                // just ignore attributes with non-default namespace (for example: xsi and xml)
            } else if ("executionPoint".equals(name)) {
                phase.executionPoint(interpolatedTrimmed(value, "executionPoint"));
            } else if ("priority".equals(name)) {
                phase.priority(getIntegerValue(interpolatedTrimmed(value, "priority"), "priority", parser, strict, 0));
            } else {
                checkUnknownAttribute(parser, name, tagName, strict);
            }
        }
        Set<String> parsed = new HashSet<>();
        while ((strict ? parser.nextTag() : nextTag(parser)) == XMLStreamReader.START_ELEMENT) {
            checkNamespace(parser, strict, namespace);
            String childName = checkDuplicate(parser.getLocalName(), parser, parsed);
            switch (childName) {
                case "id": {
                    phase.id(interpolatedTrimmed(nextText(parser, strict), "id"));
                    break;
                }
                case "executions": {
                    List<Execution> executions = new ArrayList<>();
                    while (parser.nextTag() == XMLStreamReader.START_ELEMENT) {
                        if ("execution".equals(parser.getLocalName())) {
                            executions.add(parseExecution(parser, strict, namespace));
                        } else {
                            checkUnknownElement(parser, strict);
                        }
                    }
                    phase.executions(executions);
                    break;
                }
                case "configuration": {
                    phase.configuration(buildXmlNode(parser));
                    break;
                }
                default: {
                    checkUnknownElement(parser, strict);
                    break;
                }
            }
        }
        return phase.build();
    }

    private Execution parseExecution(XMLStreamReader parser, boolean strict, String namespace) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Execution.Builder execution = Execution.newBuilder(true);
        for (int i = parser.getAttributeCount() - 1; i >= 0; i--) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if (W3C_XML_SCHEMA_INSTANCE_NS_URI.equals(ns) || XML_NS_URI.equals(ns)) {
                // just ignore attributes with non-default namespace (for example: xsi and xml)
            } else {
                checkUnknownAttribute(parser, name, tagName, strict);
            }
        }
        Set<String> parsed = new HashSet<>();
        while ((strict ? parser.nextTag() : nextTag(parser)) == XMLStreamReader.START_ELEMENT) {
            checkNamespace(parser, strict, namespace);
            String childName = checkDuplicate(parser.getLocalName(), parser, parsed);
            switch (childName) {
                case "configuration": {
                    execution.configuration(buildXmlNode(parser));
                    break;
                }
                case "goals": {
                    List<String> goals = new ArrayList<>();
                    while (parser.nextTag() == XMLStreamReader.START_ELEMENT) {
                        if ("goal".equals(parser.getLocalName())) {
                            goals.add(interpolatedTrimmed(nextText(parser, strict), "goals"));
                        } else {
                            checkUnknownElement(parser, strict);
                        }
                    }
                    execution.goals(goals);
                    break;
                }
                default: {
                    checkUnknownElement(parser, strict);
                    break;
                }
            }
        }
        return execution.build();
    }


    private void checkNamespace(XMLStreamReader parser, boolean strict, String namespace) throws XMLStreamException {
        if (strict) {
            String ns = parser.getNamespaceURI();
            if (!Objects.equals(namespace, ns)) {
                throw new XMLStreamException(
                    String.format("Unexpected namespace for element '%s': found '%s' but expected '%s'",
                        parser.getLocalName(),
                        ns != null ? ns : "no namespace",
                        namespace),
                    parser.getLocation(),
                    null
                );
            }
        }
    }

    private String checkDuplicate(String tagName, XMLStreamReader parser, Set<String> parsed) throws XMLStreamException {
        switch (tagName) {
        case "lifecycle":
            break;
        default:
            if (!parsed.add(tagName)) {
                throw new XMLStreamException("Duplicated tag: '" + tagName + "'", parser.getLocation(), null);
            }
        }
        return tagName;
    }

    /**
     * Method checkUnknownAttribute.
     *
     * @param parser a parser object.
     * @param strict a strict object.
     * @param tagName a tagName object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownAttribute(XMLStreamReader parser, String attribute, String tagName, boolean strict) throws XMLStreamException {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if (strict) {
            throw new XMLStreamException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser.getLocation(), null);
        }
    } //-- void checkUnknownAttribute(XMLStreamReader, String, String, boolean)

    /**
     * Method checkUnknownElement.
     *
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XMLStreamException XMLStreamException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownElement(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + parser.getName() + "'", parser.getLocation(), null);
        }

        for (int unrecognizedTagCount = 1; unrecognizedTagCount > 0;) {
            int eventType = nextTag(parser);
            if (eventType == XMLStreamReader.START_ELEMENT) {
                unrecognizedTagCount++;
            } else if (eventType == XMLStreamReader.END_ELEMENT) {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement(XMLStreamReader, boolean)

    /**
     * Method getTrimmedValue.
     *
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue(String)

    /**
     * Method interpolatedTrimmed.
     *
     * @param value a value object.
     * @param context a context object.
     * @return String
     */
    private String interpolatedTrimmed(String value, String context) {
        return getTrimmedValue(contentTransformer.transform(value, context));
    } //-- String interpolatedTrimmed(String, String)

    /**
     * Method nextTag.
     *
     * @param parser a parser object.
     * @throws IOException IOException if any.
     * @throws XMLStreamException XMLStreamException if
     * any.
     * @return int
     */
    private int nextTag(XMLStreamReader parser) throws XMLStreamException {
        while (true) {
            int next = parser.next();
            switch (next) {
                case XMLStreamReader.SPACE:
                case XMLStreamReader.COMMENT:
                case XMLStreamReader.PROCESSING_INSTRUCTION:
                case XMLStreamReader.CDATA:
                case XMLStreamReader.CHARACTERS:
                    continue;
                case XMLStreamReader.START_ELEMENT:
                case XMLStreamReader.END_ELEMENT:
                    return next;
            }
        }
    } //-- int nextTag(XMLStreamReader)

    private String nextText(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        int eventType = parser.getEventType();
        if (eventType != XMLStreamReader.START_ELEMENT) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", parser.getLocation(), null);
        }
        eventType = parser.next();
        StringBuilder result = new StringBuilder();
        while (true) {
            if (eventType == XMLStreamReader.CHARACTERS || eventType == XMLStreamReader.CDATA) {
                result.append(parser.getText());
            } else if (eventType == XMLStreamReader.ENTITY_REFERENCE) {
                String val = null;
                if (strict) {
                    throw new XMLStreamException("Entities are not supported in strict mode", parser.getLocation(), null);
                } else if (addDefaultEntities) {
                    val = DefaultEntitiesHolder.DEFAULT_ENTITIES.get(parser.getLocalName());
                }
                if (val != null) {
                    result.append(val);
                } else {
                    result.append("&").append(parser.getLocalName()).append(";");
                }
            } else if (eventType != XMLStreamReader.COMMENT) {
                break;
            }
            eventType = parser.next();
        }
        if (eventType != XMLStreamReader.END_ELEMENT) {
            throw new XMLStreamException(
                "TEXT must be immediately followed by END_ELEMENT and not " + eventType /*TODO: TYPES[eventType]*/, parser.getLocation(), null);
        }
        return result.toString();
    }

    private XmlNode buildXmlNode(XMLStreamReader parser) throws XMLStreamException {
        return XmlService.read(parser);
    }

    /**
     * Method getIntegerValue.
     *
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XMLStreamException XMLStreamException if
     * any.
     * @return int
     */
    private int getIntegerValue(String s, String attribute, XMLStreamReader parser, boolean strict, int defaultValue) throws XMLStreamException {
        if (s != null) {
            try {
                return Integer.valueOf(s).intValue();
            } catch (NumberFormatException nfe) {
                if (strict) {
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer", parser.getLocation(), nfe);
                }
            }
        }
        return defaultValue;
    } //-- int getIntegerValue(String, String, XMLStreamReader, boolean)

    private static Map<String, String> doGetDefaultEntities() {
        return Map.ofEntries(
            entry("nbsp",   "\u00a0"), entry("iexcl",  "\u00a1"), entry("cent",   "\u00a2"), entry("pound",  "\u00a3"),
            entry("curren", "\u00a4"), entry("yen",    "\u00a5"), entry("brvbar", "\u00a6"), entry("sect",   "\u00a7"),
            entry("uml",    "\u00a8"), entry("copy",   "\u00a9"), entry("ordf",   "\u00aa"), entry("laquo",  "\u00ab"),
            entry("not",    "\u00ac"), entry("shy",    "\u00ad"), entry("reg",    "\u00ae"), entry("macr",   "\u00af"),
            entry("deg",    "\u00b0"), entry("plusmn", "\u00b1"), entry("sup2",   "\u00b2"), entry("sup3",   "\u00b3"),
            entry("acute",  "\u00b4"), entry("micro",  "\u00b5"), entry("para",   "\u00b6"), entry("middot", "\u00b7"),
            entry("cedil",  "\u00b8"), entry("sup1",   "\u00b9"), entry("ordm",   "\u00ba"), entry("raquo",  "\u00bb"),
            entry("frac14", "\u00bc"), entry("frac12", "\u00bd"), entry("frac34", "\u00be"), entry("iquest", "\u00bf"),
            entry("Agrave", "\u00c0"), entry("Aacute", "\u00c1"), entry("Acirc",  "\u00c2"), entry("Atilde", "\u00c3"),
            entry("Auml",   "\u00c4"), entry("Aring",  "\u00c5"), entry("AElig",  "\u00c6"), entry("Ccedil", "\u00c7"),
            entry("Egrave", "\u00c8"), entry("Eacute", "\u00c9"), entry("Ecirc",  "\u00ca"), entry("Euml",   "\u00cb"),
            entry("Igrave", "\u00cc"), entry("Iacute", "\u00cd"), entry("Icirc",  "\u00ce"), entry("Iuml",   "\u00cf"),
            entry("ETH",    "\u00d0"), entry("Ntilde", "\u00d1"), entry("Ograve", "\u00d2"), entry("Oacute", "\u00d3"),
            entry("Ocirc",  "\u00d4"), entry("Otilde", "\u00d5"), entry("Ouml",   "\u00d6"), entry("times",  "\u00d7"),
            entry("Oslash", "\u00d8"), entry("Ugrave", "\u00d9"), entry("Uacute", "\u00da"), entry("Ucirc",  "\u00db"),
            entry("Uuml",   "\u00dc"), entry("Yacute", "\u00dd"), entry("THORN",  "\u00de"), entry("szlig",  "\u00df"),
            entry("agrave", "\u00e0"), entry("aacute", "\u00e1"), entry("acirc",  "\u00e2"), entry("atilde", "\u00e3"),
            entry("auml",   "\u00e4"), entry("aring",  "\u00e5"), entry("aelig",  "\u00e6"), entry("ccedil", "\u00e7"),
            entry("egrave", "\u00e8"), entry("eacute", "\u00e9"), entry("ecirc",  "\u00ea"), entry("euml",   "\u00eb"),
            entry("igrave", "\u00ec"), entry("iacute", "\u00ed"), entry("icirc",  "\u00ee"), entry("iuml",   "\u00ef"),
            entry("eth",    "\u00f0"), entry("ntilde", "\u00f1"), entry("ograve", "\u00f2"), entry("oacute", "\u00f3"),
            entry("ocirc",  "\u00f4"), entry("otilde", "\u00f5"), entry("ouml",   "\u00f6"), entry("divide", "\u00f7"),
            entry("oslash", "\u00f8"), entry("ugrave", "\u00f9"), entry("uacute", "\u00fa"), entry("ucirc",  "\u00fb"),
            entry("uuml",   "\u00fc"), entry("yacute", "\u00fd"), entry("thorn",  "\u00fe"), entry("yuml",   "\u00ff"),
            // Special entities
            entry("OElig",  "\u0152"), entry("oelig",  "\u0153"), entry("Scaron", "\u0160"), entry("scaron", "\u0161"),
            entry("Yuml",   "\u0178"), entry("circ",   "\u02c6"), entry("tilde",  "\u02dc"), entry("ensp",   "\u2002"),
            entry("emsp",   "\u2003"), entry("thinsp", "\u2009"), entry("zwnj",   "\u200c"), entry("zwj",    "\u200d"),
            entry("lrm",    "\u200e"), entry("rlm",    "\u200f"), entry("ndash",  "\u2013"), entry("mdash",  "\u2014"),
            entry("lsquo",  "\u2018"), entry("rsquo",  "\u2019"), entry("sbquo",  "\u201a"), entry("ldquo",  "\u201c"),
            entry("rdquo",  "\u201d"), entry("bdquo",  "\u201e"), entry("dagger", "\u2020"), entry("Dagger", "\u2021"),
            entry("permil", "\u2030"), entry("lsaquo", "\u2039"), entry("rsaquo", "\u203a"), entry("euro",   "\u20ac"),
            // Symbol entities
            entry("fnof",   "\u0192"), entry("Alpha",  "\u0391"), entry("Beta",   "\u0392"), entry("Gamma",  "\u0393"),
            entry("Delta",  "\u0394"), entry("Epsilon","\u0395"), entry("Zeta",   "\u0396"), entry("Eta",    "\u0397"),
            entry("Theta",  "\u0398"), entry("Iota",   "\u0399"), entry("Kappa",  "\u039a"), entry("Lambda", "\u039b"),
            entry("Mu",     "\u039c"), entry("Nu",     "\u039d"), entry("Xi",     "\u039e"), entry("Omicron","\u039f"),
            entry("Pi",     "\u03a0"), entry("Rho",    "\u03a1"), entry("Sigma",  "\u03a3"), entry("Tau",    "\u03a4"),
            entry("Upsilon","\u03a5"), entry("Phi",    "\u03a6"), entry("Chi",    "\u03a7"), entry("Psi",    "\u03a8"),
            entry("Omega",  "\u03a9"), entry("alpha",  "\u03b1"), entry("beta",   "\u03b2"), entry("gamma",  "\u03b3"),
            entry("delta",  "\u03b4"), entry("epsilon","\u03b5"), entry("zeta",   "\u03b6"), entry("eta",    "\u03b7"),
            entry("theta",  "\u03b8"), entry("iota",   "\u03b9"), entry("kappa",  "\u03ba"), entry("lambda", "\u03bb"),
            entry("mu",     "\u03bc"), entry("nu",     "\u03bd"), entry("xi",     "\u03be"), entry("omicron","\u03bf"),
            entry("pi",     "\u03c0"), entry("rho",    "\u03c1"), entry("sigmaf", "\u03c2"), entry("sigma",  "\u03c3"),
            entry("tau",    "\u03c4"), entry("upsilon","\u03c5"), entry("phi",    "\u03c6"), entry("chi",    "\u03c7"),
            entry("psi",    "\u03c8"), entry("omega",  "\u03c9"), entry("thetasym","\u03d1"),entry("upsih",  "\u03d2"),
            entry("piv",    "\u03d6"), entry("bull",   "\u2022"), entry("hellip", "\u2026"), entry("prime",  "\u2032"),
            entry("Prime",  "\u2033"), entry("oline",  "\u203e"), entry("frasl",  "\u2044"), entry("weierp", "\u2118"),
            entry("image",  "\u2111"), entry("real",   "\u211c"), entry("trade",  "\u2122"), entry("alefsym","\u2135"),
            entry("larr",   "\u2190"), entry("uarr",   "\u2191"), entry("rarr",   "\u2192"), entry("darr",   "\u2193"),
            entry("harr",   "\u2194"), entry("crarr",  "\u21b5"), entry("lArr",   "\u21d0"), entry("uArr",   "\u21d1"),
            entry("rArr",   "\u21d2"), entry("dArr",   "\u21d3"), entry("hArr",   "\u21d4"), entry("forall", "\u2200"),
            entry("part",   "\u2202"), entry("exist",  "\u2203"), entry("empty",  "\u2205"), entry("nabla",  "\u2207"),
            entry("isin",   "\u2208"), entry("notin",  "\u2209"), entry("ni",     "\u220b"), entry("prod",   "\u220f"),
            entry("sum",    "\u2211"), entry("minus",  "\u2212"), entry("lowast", "\u2217"), entry("radic",  "\u221a"),
            entry("prop",   "\u221d"), entry("infin",  "\u221e"), entry("ang",    "\u2220"), entry("and",    "\u2227"),
            entry("or",     "\u2228"), entry("cap",    "\u2229"), entry("cup",    "\u222a"), entry("int",    "\u222b"),
            entry("there4", "\u2234"), entry("sim",    "\u223c"), entry("cong",   "\u2245"), entry("asymp",  "\u2248"),
            entry("ne",     "\u2260"), entry("equiv",  "\u2261"), entry("le",     "\u2264"), entry("ge",     "\u2265"),
            entry("sub",    "\u2282"), entry("sup",    "\u2283"), entry("nsub",   "\u2284"), entry("sube",   "\u2286"),
            entry("supe",   "\u2287"), entry("oplus",  "\u2295"), entry("otimes", "\u2297"), entry("perp",   "\u22a5"),
            entry("sdot",   "\u22c5"), entry("lceil",  "\u2308"), entry("rceil",  "\u2309"), entry("lfloor", "\u230a"),
            entry("rfloor", "\u230b"), entry("lang",   "\u2329"), entry("rang",   "\u232a"), entry("loz",    "\u25ca"),
            entry("spades", "\u2660"), entry("clubs",  "\u2663"), entry("hearts", "\u2665"), entry("diams",  "\u2666")
        );
    }
}
