// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from writer-stax.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.toolchain.v4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.toolchain.InputLocation;
import org.apache.maven.api.toolchain.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.toolchain.TrackableBase;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.toolchain.InputSource;
import org.codehaus.stax2.util.StreamWriterDelegate;

import static javax.xml.XMLConstants.W3C_XML_SCHEMA_INSTANCE_NS_URI;

@Generated
public class MavenToolchainsStaxWriter {

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Default namespace.
     */
    private static final String NAMESPACE = "http://maven.apache.org/TOOLCHAINS/1.2.0";

    /**
     * Default schemaLocation.
     */
    private static final String SCHEMA_LOCATION = "https://maven.apache.org/xsd/toolchains-1.2.0.xsd";

    /**
     * Field namespace.
     */
    private String namespace = NAMESPACE;

    /**
     * Field schemaLocation.
     */
    private String schemaLocation = SCHEMA_LOCATION;

    /**
     * Field fileComment.
     */
    private String fileComment = null;

    private boolean addLocationInformation = true;

    /**
     * Field stringFormatter.
     */
    protected Function<InputLocation, String> stringFormatter;

      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method setNamespace.
     *
     * @param namespace the namespace to use.
     */
    public void setNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    } //-- void setNamespace(String)

    /**
     * Method setSchemaLocation.
     *
     * @param schemaLocation the schema location to use.
     */
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
        } //-- void setSchemaLocation(String)

    /**
     * Method setFileComment.
     *
     * @param fileComment a fileComment object.
     */
    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    } //-- void setFileComment(String)

    /**
     * Method setAddLocationInformation.
     */
    public void setAddLocationInformation(boolean addLocationInformation) {
        this.addLocationInformation = addLocationInformation;
    } //-- void setAddLocationInformation(String)

    /**
     * Method setStringFormatter.
     *
     * @param stringFormatter
     */
    public void setStringFormatter(Function<InputLocation, String> stringFormatter) {
        this.stringFormatter = stringFormatter;
    } //-- void setStringFormatter(Function<InputLocation, String>)

    /**
     * Method write.
     *
     * @param writer a writer object
     * @param persistedToolchains a PersistedToolchains object
     * @throws IOException IOException if any
     */
    public void write(Writer writer, PersistedToolchains persistedToolchains) throws IOException, XMLStreamException {
        XMLOutputFactory factory = new com.ctc.wstx.stax.WstxOutputFactory();
        factory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, false);
        factory.setProperty(com.ctc.wstx.api.WstxOutputProperties.P_USE_DOUBLE_QUOTES_IN_XML_DECL, true);
        factory.setProperty(com.ctc.wstx.api.WstxOutputProperties.P_ADD_SPACE_AFTER_EMPTY_ELEM, true);
        XMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        serializer.writeStartDocument(persistedToolchains.getModelEncoding(), null);
        writePersistedToolchains("toolchains", persistedToolchains, serializer);
        serializer.writeEndDocument();
    } //-- void write(Writer, PersistedToolchains)

    /**
     * Method write.
     *
     * @param stream a stream object
     * @param persistedToolchains a PersistedToolchains object
     * @throws IOException IOException if any
     */
    public void write(OutputStream stream, PersistedToolchains persistedToolchains) throws IOException, XMLStreamException {
        XMLOutputFactory factory = new com.ctc.wstx.stax.WstxOutputFactory();
        factory.setProperty(XMLOutputFactory.IS_REPAIRING_NAMESPACES, false);
        factory.setProperty(com.ctc.wstx.api.WstxOutputProperties.P_USE_DOUBLE_QUOTES_IN_XML_DECL, true);
        factory.setProperty(com.ctc.wstx.api.WstxOutputProperties.P_ADD_SPACE_AFTER_EMPTY_ELEM, true);
        XMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, persistedToolchains.getModelEncoding()));
        serializer.writeStartDocument(persistedToolchains.getModelEncoding(), null);
        writePersistedToolchains("toolchains", persistedToolchains, serializer);
        serializer.writeEndDocument();
    } //-- void write(OutputStream, PersistedToolchains)

    private void writeTrackableBase(String tagName, TrackableBase trackableBase, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (trackableBase != null) {
            serializer.writeStartElement(namespace, tagName);
            serializer.writeEndElement();
        }
    }

    private void writePersistedToolchains(String tagName, PersistedToolchains persistedToolchains, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (persistedToolchains != null) {
            if (this.fileComment != null) {
                serializer.writeCharacters("\n");
                serializer.writeComment(this.fileComment);
                serializer.writeCharacters("\n");
            }
            serializer.writeStartElement("", tagName, namespace);
            serializer.writeNamespace("", namespace);
            serializer.writeNamespace("xsi", W3C_XML_SCHEMA_INSTANCE_NS_URI);
            serializer.writeAttribute(W3C_XML_SCHEMA_INSTANCE_NS_URI, "schemaLocation", namespace + " " + schemaLocation);
            writeList("toolchains", true, persistedToolchains.getToolchains(), serializer, persistedToolchains,
                    t -> writeToolchainModel("toolchain", t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeToolchainModel(String tagName, ToolchainModel toolchainModel, XMLStreamWriter serializer)
        throws IOException, XMLStreamException {
        if (toolchainModel != null) {
            serializer.writeStartElement(namespace, tagName);
            writeTag("type", null, toolchainModel.getType(), serializer, toolchainModel);
            writeProperties("provides", toolchainModel.getProvides(), serializer, toolchainModel);
            writeDom(toolchainModel.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    @FunctionalInterface
    private interface ElementWriter<T> {
        public void write(T t) throws IOException, XMLStreamException;
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        writeList(tagName, false, list, serializer, locationTracker, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(namespace, tagName);
            }
            int index = 0;
            InputLocation location = locationTracker != null ? locationTracker.getLocation(tagName) : null;
            for (T t : list) {
                writer.write(t);
                writeLocationTracking(location, Integer.valueOf(index++), serializer);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(namespace, tagName);
            InputLocation location = locationTracker != null ? locationTracker.getLocation(tagName) : null;
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                writeTag(key, null, entry.getValue(), serializer, null);
                writeLocationTracking(location, key, serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(namespace, dom.name());
            for (Map.Entry<String, String> attr : dom.attributes().entrySet()) {
                if (attr.getKey().startsWith("xml:")) {
                    serializer.writeAttribute("http://www.w3.org/XML/1998/namespace",
                    attr.getKey().substring(4), attr.getValue());
                } else {
                    serializer.writeAttribute(attr.getKey(), attr.getValue());
                }
            }
            for (XmlNode child : dom.children()) {
                writeDom(child, serializer);
            }
            String value = dom.value();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
            if (addLocationInformation && dom.inputLocation() instanceof InputLocation inputLocation && dom.children().isEmpty()) {
                serializer.writeComment(toString(inputLocation));
            }
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(namespace, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
            writeLocationTracking(locationTracker, tagName, serializer);
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    /**
     * Method writeLocationTracking.
     *
     * @param locationTracker
     * @param serializer
     * @param key
     * @throws IOException
     */
    protected void writeLocationTracking(InputLocationTracker locationTracker, Object key, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (addLocationInformation) {
            InputLocation location = (locationTracker == null) ? null : locationTracker.getLocation(key);
            if (location != null) {
                serializer.writeComment(toString(location));
            }
        }
    } //-- void writeLocationTracking(InputLocationTracker, Object, XMLStreamWriter)

    /**
     * Method toString.
     *
     * @param location
     * @return String
     */
    protected String toString(InputLocation location) {
        if (stringFormatter != null) {
            return stringFormatter.apply(location);
        }
        if (location.getSource() != null) {
            return ' ' + location.getSource().toString() + ':' + location.getLineNumber() + ' ';
        } else {
            return " " + location.getLineNumber() + " ";
        }
    } //-- String toString(InputLocation)

    static class IndentingXMLStreamWriter extends StreamWriterDelegate {

        int depth = 0;
        boolean hasChildren = false;

        public IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            indent();
            super.writeEmptyElement(localName);
            hasChildren = true;
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            indent();
            super.writeEmptyElement(namespaceURI, localName);
            hasChildren = true;
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            hasChildren = true;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            indent();
            super.writeStartElement(localName);
            depth++;
            hasChildren = false;
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            indent();
            super.writeStartElement(namespaceURI, localName);
            depth++;
            hasChildren = false;
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            depth++;
            hasChildren = false;
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            depth--;
            if (hasChildren) {
                indent();
            }
            super.writeEndElement();
            hasChildren = true;
        }

        private void indent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < depth; i++) {
                super.writeCharacters("  ");
            }
        }
    }
}
