/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.building;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.ToolchainsBuilderException;
import org.apache.maven.api.services.ToolchainsBuilderRequest;
import org.apache.maven.api.services.ToolchainsBuilderResult;
import org.apache.maven.api.services.xml.ToolchainsXmlFactory;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Problem;
import org.apache.maven.building.ProblemCollector;
import org.apache.maven.building.ProblemCollectorFactory;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingResult;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingException;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.codehaus.plexus.interpolation.os.OperatingSystemUtils;

@Named
@Singleton
@Deprecated(since="4.0.0")
public class DefaultToolchainsBuilder
implements ToolchainsBuilder {
    private final org.apache.maven.api.services.ToolchainsBuilder builder;
    private final ToolchainsXmlFactory toolchainsXmlFactory;

    @Inject
    public DefaultToolchainsBuilder(org.apache.maven.api.services.ToolchainsBuilder builder, ToolchainsXmlFactory toolchainsXmlFactory) {
        this.builder = builder;
        this.toolchainsXmlFactory = toolchainsXmlFactory;
    }

    @Override
    public ToolchainsBuildingResult build(ToolchainsBuildingRequest request) throws ToolchainsBuildingException {
        try {
            ToolchainsBuilderResult result = this.builder.build(ToolchainsBuilderRequest.builder().session((ProtoSession)((Session)Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{Session.class}, (proxy, method, args) -> {
                if ("getSystemProperties".equals(method.getName())) {
                    HashMap properties = new HashMap();
                    Properties env = OperatingSystemUtils.getSystemEnvVars();
                    env.stringPropertyNames().forEach(k -> properties.put("env." + k, env.getProperty((String)k)));
                    return properties;
                }
                if ("getUserProperties".equals(method.getName())) {
                    return Map.of();
                }
                if ("getService".equals(method.getName()) && args[0] == ToolchainsXmlFactory.class) {
                    return this.toolchainsXmlFactory;
                }
                return null;
            }))).installationToolchainsSource(this.convert(request.getGlobalToolchainsSource())).userToolchainsSource(this.convert(request.getUserToolchainsSource())).build());
            return new DefaultToolchainsBuildingResult(new PersistedToolchains(result.getEffectiveToolchains()), this.convert(result.getProblems()));
        }
        catch (ToolchainsBuilderException e) {
            throw new ToolchainsBuildingException(this.convert(e.getProblems()));
        }
    }

    private Source convert(final org.apache.maven.building.Source source) {
        if (source instanceof FileSource) {
            FileSource fs = (FileSource)source;
            return Source.fromPath((Path)fs.getPath());
        }
        if (source != null) {
            return new Source(){

                public Path getPath() {
                    return null;
                }

                public InputStream openStream() throws IOException {
                    return source.getInputStream();
                }

                public String getLocation() {
                    return source.getLocation();
                }

                public Source resolve(String relative) {
                    return null;
                }
            };
        }
        return null;
    }

    private List<Problem> convert(List<BuilderProblem> problems) {
        ProblemCollector collector = ProblemCollectorFactory.newInstance(null);
        problems.forEach(p -> collector.add(Problem.Severity.valueOf((String)p.getSeverity().name()), p.getMessage(), p.getLineNumber(), p.getColumnNumber(), p.getException()));
        return collector.getProblems();
    }
}

