/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.cache.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.maven.mercury.artifact.ArtifactCoordinates;
import org.apache.maven.mercury.repository.api.MetadataCorruptionException;
import org.apache.maven.mercury.repository.api.RepositoryGAMetadata;
import org.apache.maven.mercury.repository.cache.fs.CachedMetadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CachedGAMetadata
extends RepositoryGAMetadata {
    public static final String ELEM_COORDINATES = "coordinates";
    public static final String ATTR_GROUP_ID = "groupId";
    public static final String ATTR_ARTIFACT_ID = "artifactId";
    public static final String ATTR_VERSION = "version";
    public static final String ELEM_VERSIONS = "versions";
    CachedMetadata cm;

    public CachedGAMetadata(File mdFile) throws FileNotFoundException, IOException, XmlPullParserException, MetadataCorruptionException {
        this.cm = new CachedMetadata(mdFile);
        this.fromXml();
    }

    public CachedGAMetadata(RepositoryGAMetadata md) throws MetadataException {
        super(md);
        this.cm = new CachedMetadata();
        this.toXml();
    }

    private void fromXml() throws MetadataCorruptionException {
        this.ga = new ArtifactCoordinates(this.cm.getAttribute(ELEM_COORDINATES, ATTR_GROUP_ID, true), this.cm.getAttribute(ELEM_COORDINATES, ATTR_ARTIFACT_ID, true), null);
        List<String> verList = this.cm.findAttributes(ELEM_VERSIONS, ATTR_VERSION);
        if (!Util.isEmpty(verList)) {
            this.versions.addAll(verList);
        }
        String lChk = this.cm.getLastUpdate();
        this.lastCheck = Long.parseLong(lChk);
    }

    private void toXml() {
        this.cm.clean();
        this.cm.setAttribute(ELEM_COORDINATES, ATTR_GROUP_ID, this.ga.getGroupId());
        this.cm.setAttribute(ELEM_COORDINATES, ATTR_ARTIFACT_ID, this.ga.getArtifactId());
        if (!Util.isEmpty((Collection)this.versions)) {
            this.cm.setAttribute(ELEM_VERSIONS, ATTR_VERSION, this.versions);
        }
        this.cm.setLastUpdate("" + this.lastCheck);
    }
}

