/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.cache.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.maven.mercury.artifact.ArtifactCoordinates;
import org.apache.maven.mercury.repository.api.MetadataCorruptionException;
import org.apache.maven.mercury.repository.api.RepositoryGAVMetadata;
import org.apache.maven.mercury.repository.cache.fs.CachedMetadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CachedGAVMetadata
extends RepositoryGAVMetadata {
    public static final String ELEM_SNAPSHOTS = "snapshots";
    public static final String ATTR_SNAPSHOT = "snapshot";
    public static final String ELEM_CLASSIFIERS = "classifiers";
    public static final String ATTR_CLASSIFIER = "classifier";
    CachedMetadata cm;

    public CachedGAVMetadata(File mdFile) throws FileNotFoundException, IOException, XmlPullParserException, MetadataCorruptionException {
        this.cm = new CachedMetadata(mdFile);
        this.fromXml();
    }

    public CachedGAVMetadata(RepositoryGAVMetadata gavm) throws MetadataException {
        super(gavm);
        this.cm = new CachedMetadata();
        this.toXml();
    }

    private void fromXml() throws MetadataCorruptionException {
        List<String> clList;
        this.gav = new ArtifactCoordinates(this.cm.getAttribute("coordinates", "groupId", true), this.cm.getAttribute("coordinates", "artifactId", true), this.cm.getAttribute("coordinates", "version", true));
        List<String> snList = this.cm.findAttributes(ELEM_SNAPSHOTS, ATTR_SNAPSHOT);
        if (!Util.isEmpty(snList)) {
            this.snapshots.addAll(snList);
        }
        if (!Util.isEmpty(clList = this.cm.findAttributes(ELEM_CLASSIFIERS, ATTR_CLASSIFIER))) {
            this.classifiers.addAll(clList);
        }
        String lChk = this.cm.getLastUpdate();
        this.lastCheck = Long.parseLong(lChk);
    }

    private void toXml() {
        this.cm.clean();
        this.cm.setAttribute("coordinates", "groupId", this.gav.getGroupId());
        this.cm.setAttribute("coordinates", "artifactId", this.gav.getArtifactId());
        this.cm.setAttribute("coordinates", "version", this.gav.getVersion());
        if (!Util.isEmpty((Collection)this.snapshots)) {
            this.cm.setAttribute(ELEM_SNAPSHOTS, ATTR_SNAPSHOT, this.snapshots);
        }
        this.cm.setLastUpdate("" + this.lastCheck);
    }
}

