/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.cache.fs;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.ArtifactCoordinates;
import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.event.EventManager;
import org.apache.maven.mercury.event.EventTypeEnum;
import org.apache.maven.mercury.event.GenericEvent;
import org.apache.maven.mercury.event.MercuryEvent;
import org.apache.maven.mercury.event.MercuryEventListener;
import org.apache.maven.mercury.repository.api.MetadataCacheException;
import org.apache.maven.mercury.repository.api.MetadataCorruptionException;
import org.apache.maven.mercury.repository.api.RepositoryGAMetadata;
import org.apache.maven.mercury.repository.api.RepositoryGAVMetadata;
import org.apache.maven.mercury.repository.api.RepositoryMetadataCache;
import org.apache.maven.mercury.repository.api.RepositoryUpdatePolicy;
import org.apache.maven.mercury.repository.cache.fs.CachedGAMetadata;
import org.apache.maven.mercury.repository.cache.fs.CachedGAVMetadata;
import org.apache.maven.mercury.util.FileLockBundle;
import org.apache.maven.mercury.util.FileUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class MetadataCacheFs
implements RepositoryMetadataCache {
    public static final String EVENT_FIND_GA = "find.ga";
    public static final String EVENT_FIND_GAV = "find.gav";
    public static final String EVENT_FIND_RAW = "find.raw";
    public static final String EVENT_UPDATE_GA = "update.ga";
    public static final String EVENT_UPDATE_GAV = "update.gav";
    public static final String EVENT_SAVE_RAW = "save.raw";
    private static final Language _lang = new DefaultLanguage(RepositoryGAVMetadata.class);
    static volatile Map<String, MetadataCacheFs> fsCaches = Collections.synchronizedMap(new HashMap(2));
    private volatile Map<String, RepositoryGAMetadata> gaCache = Collections.synchronizedMap(new HashMap(512));
    private volatile Map<String, RepositoryGAVMetadata> gavCache = Collections.synchronizedMap(new HashMap(1024));
    private volatile Map<String, byte[]> rawCache = Collections.synchronizedMap(new HashMap(1024));
    private File root;
    private EventManager _eventManager;

    public static MetadataCacheFs getCache(File root) throws IOException {
        if (root == null || root.exists() && root.isFile()) {
            throw new IllegalArgumentException(_lang.getMessage("bad.root.file", new String[]{root == null ? "null" : root.getAbsolutePath()}));
        }
        String key = root.getCanonicalPath();
        MetadataCacheFs fsc = fsCaches.get(key);
        if (fsc == null) {
            fsc = new MetadataCacheFs(root);
            fsCaches.put(key, fsc);
        }
        return fsc;
    }

    private MetadataCacheFs(File root) {
        this.root = root;
    }

    public RepositoryGAMetadata findGA(String repoGuid, RepositoryUpdatePolicy up, ArtifactCoordinates coord) throws MetadataCorruptionException {
        CachedGAMetadata cachedGAMetadata;
        block16: {
            String gaKey;
            GenericEvent event;
            block14: {
                RepositoryGAMetadata repositoryGAMetadata;
                block15: {
                    RepositoryGAMetadata inMem;
                    event = null;
                    gaKey = this.getGAKey(coord);
                    if (this._eventManager != null) {
                        event = new GenericEvent(EventTypeEnum.fsCache, EVENT_FIND_GA, gaKey);
                    }
                    if ((inMem = this.gaCache.get(gaKey)) == null) break block14;
                    long lastCheckMillis = inMem.getLastCheckMillis();
                    if (up.timestampExpired(lastCheckMillis)) {
                        inMem.setExpired(true);
                        this.gaCache.put(gaKey, inMem);
                    }
                    if (this._eventManager != null) {
                        event.setResult("found in memory, expired is " + inMem.isExpired());
                    }
                    repositoryGAMetadata = inMem;
                    if (this._eventManager == null) break block15;
                    event.stop();
                    this._eventManager.fireEvent((MercuryEvent)event);
                }
                return repositoryGAMetadata;
            }
            try {
                File gaDir = this.getGADir(coord);
                File gamF = this.getGAFile(gaDir, repoGuid);
                CachedGAMetadata md = null;
                if (gamF.exists()) {
                    md = new CachedGAMetadata(gamF);
                    long lastCheckMillis = md.getLastCheckMillis();
                    if (up != null && up.timestampExpired(lastCheckMillis)) {
                        md.setExpired(true);
                    }
                    this.gaCache.put(gaKey, md);
                    if (this._eventManager != null) {
                        event.setResult("found on disk, expired is " + md.isExpired());
                    }
                } else if (this._eventManager != null) {
                    event.setResult("not found");
                }
                cachedGAMetadata = md;
                if (this._eventManager == null) break block16;
            }
            catch (Exception e) {
                try {
                    throw new MetadataCorruptionException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (this._eventManager != null) {
                        event.stop();
                        this._eventManager.fireEvent(event);
                    }
                    throw throwable;
                }
            }
            event.stop();
            this._eventManager.fireEvent((MercuryEvent)event);
        }
        return cachedGAMetadata;
    }

    public RepositoryGAVMetadata findGAV(String repoGuid, RepositoryUpdatePolicy up, ArtifactCoordinates coord) throws MetadataCorruptionException {
        CachedGAVMetadata cachedGAVMetadata;
        GenericEvent event;
        block19: {
            RepositoryGAVMetadata inMem;
            String gavKey;
            FileLockBundle lock;
            block17: {
                RepositoryGAVMetadata repositoryGAVMetadata;
                block18: {
                    lock = null;
                    event = null;
                    gavKey = this.getGAVKey(coord);
                    if (this._eventManager != null) {
                        event = new GenericEvent(EventTypeEnum.fsCache, EVENT_FIND_GAV, gavKey);
                    }
                    if ((inMem = this.gavCache.get(gavKey)) == null) break block17;
                    long lastCheckMillis = inMem.getLastCheckMillis();
                    if (up.timestampExpired(lastCheckMillis)) {
                        inMem.setExpired(true);
                        this.gavCache.put(gavKey, inMem);
                    }
                    if (this._eventManager != null) {
                        event.setResult("found in memory, expired is " + inMem.isExpired());
                    }
                    repositoryGAVMetadata = inMem;
                    if (lock == null) break block18;
                    lock.release();
                }
                if (this._eventManager != null) {
                    event.stop();
                    this._eventManager.fireEvent((MercuryEvent)event);
                }
                return repositoryGAVMetadata;
            }
            try {
                File gavDir = this.getGAVDir(coord);
                lock = FileUtil.lockDir((String)gavDir.getCanonicalPath(), (long)500L, (long)5L);
                File gavmF = this.getGAVFile(gavDir, repoGuid);
                CachedGAVMetadata md = null;
                if (gavmF.exists()) {
                    md = new CachedGAVMetadata(gavmF);
                    if (up != null && up.timestampExpired(md.getLastCheck())) {
                        md.setExpired(true);
                    }
                    if (this._eventManager != null) {
                        event.setResult("found on disk, expired is " + inMem.isExpired());
                    }
                    this.gavCache.put(gavKey, md);
                } else if (this._eventManager != null) {
                    event.setResult("not found");
                }
                cachedGAVMetadata = md;
                if (lock == null) break block19;
            }
            catch (Exception e) {
                try {
                    throw new MetadataCorruptionException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.release();
                    }
                    if (this._eventManager != null) {
                        event.stop();
                        this._eventManager.fireEvent(event);
                    }
                    throw throwable;
                }
            }
            lock.release();
        }
        if (this._eventManager != null) {
            event.stop();
            this._eventManager.fireEvent((MercuryEvent)event);
        }
        return cachedGAVMetadata;
    }

    public void updateGA(String repoGuid, RepositoryGAMetadata gam) throws MetadataCacheException {
        GenericEvent event;
        block8: {
            FileLockBundle lock = null;
            event = null;
            try {
                String gaKey = this.getGAKey(gam.getGA());
                if (this._eventManager != null) {
                    event = new GenericEvent(EventTypeEnum.fsCache, EVENT_UPDATE_GA, gaKey);
                }
                File gaDir = this.getGADir(gam.getGA());
                lock = FileUtil.lockDir((String)gaDir.getCanonicalPath(), (long)500L, (long)5L);
                File gamF = this.getGAFile(gaDir, repoGuid);
                CachedGAMetadata md = new CachedGAMetadata(gam);
                md.cm.save(gamF);
                this.gaCache.put(gaKey, md);
                if (lock == null) break block8;
            }
            catch (Exception e) {
                try {
                    throw new MetadataCacheException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.release();
                    }
                    if (this._eventManager != null) {
                        event.stop();
                        this._eventManager.fireEvent(event);
                    }
                    throw throwable;
                }
            }
            lock.release();
        }
        if (this._eventManager != null) {
            event.stop();
            this._eventManager.fireEvent((MercuryEvent)event);
        }
    }

    public void updateGAV(String repoGuid, RepositoryGAVMetadata gavm) throws MetadataCacheException {
        GenericEvent event;
        block8: {
            FileLockBundle lock = null;
            event = null;
            try {
                String gavKey = this.getGAKey(gavm.getGAV());
                if (this._eventManager != null) {
                    event = new GenericEvent(EventTypeEnum.fsCache, EVENT_UPDATE_GA, gavKey);
                }
                File gavDir = this.getGAVDir(gavm.getGAV());
                lock = FileUtil.lockDir((String)gavDir.getCanonicalPath(), (long)500L, (long)5L);
                File gavmF = this.getGAVFile(gavDir, repoGuid);
                CachedGAVMetadata md = new CachedGAVMetadata(gavm);
                md.cm.save(gavmF);
                this.gavCache.put(gavKey, md);
                if (lock == null) break block8;
            }
            catch (Exception e) {
                try {
                    throw new MetadataCacheException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.release();
                    }
                    if (this._eventManager != null) {
                        event.stop();
                        this._eventManager.fireEvent(event);
                    }
                    throw throwable;
                }
            }
            lock.release();
        }
        if (this._eventManager != null) {
            event.stop();
            this._eventManager.fireEvent((MercuryEvent)event);
        }
    }

    public byte[] findRaw(ArtifactBasicMetadata bmd) throws MetadataCacheException {
        byte[] byArray;
        block14: {
            File f;
            byte[] res;
            String rawKey;
            GenericEvent event;
            block12: {
                byte[] byArray2;
                block13: {
                    block10: {
                        byte[] byArray3;
                        block11: {
                            event = null;
                            rawKey = bmd.getGAV();
                            if (this._eventManager != null) {
                                event = new GenericEvent(EventTypeEnum.fsCache, EVENT_FIND_RAW, rawKey);
                            }
                            if ((res = this.rawCache.get(rawKey)) == null) break block10;
                            if (this._eventManager != null) {
                                event.setResult("found in memory");
                            }
                            byArray3 = res;
                            if (this._eventManager == null) break block11;
                            event.stop();
                            this._eventManager.fireEvent((MercuryEvent)event);
                        }
                        return byArray3;
                    }
                    f = new File(this.getGAVDir(bmd.getEffectiveCoordinates()), bmd.getArtifactId() + "-" + bmd.getVersion() + "." + bmd.getType());
                    if (f.exists()) break block12;
                    byArray2 = null;
                    if (this._eventManager == null) break block13;
                    event.stop();
                    this._eventManager.fireEvent((MercuryEvent)event);
                }
                return byArray2;
            }
            try {
                res = FileUtil.readRawData((File)f);
                this.rawCache.put(rawKey, res);
                if (this._eventManager != null) {
                    event.setResult("found on disk");
                }
                byArray = res;
                if (this._eventManager == null) break block14;
            }
            catch (IOException e) {
                try {
                    throw new MetadataCacheException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (this._eventManager != null) {
                        event.stop();
                        this._eventManager.fireEvent(event);
                    }
                    throw throwable;
                }
            }
            event.stop();
            this._eventManager.fireEvent((MercuryEvent)event);
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveRaw(ArtifactBasicMetadata bmd, byte[] rawBytes) throws MetadataCacheException {
        GenericEvent event = null;
        try {
            String rawKey = bmd.getGAV();
            if (this._eventManager != null) {
                event = new GenericEvent(EventTypeEnum.fsCache, EVENT_SAVE_RAW, rawKey);
            }
            this.rawCache.put(rawKey, rawBytes);
            File f = new File(this.getGAVDir(bmd.getEffectiveCoordinates()), bmd.getArtifactId() + "-" + bmd.getVersion() + "." + bmd.getType());
            FileUtil.writeRawData((File)f, (byte[])rawBytes);
            if (this._eventManager == null) return;
        }
        catch (IOException e) {
            try {
                throw new MetadataCacheException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (this._eventManager == null) throw throwable;
                event.stop();
                this._eventManager.fireEvent(event);
                throw throwable;
            }
        }
        event.stop();
        this._eventManager.fireEvent((MercuryEvent)event);
        return;
    }

    private String getGAKey(ArtifactCoordinates coord) {
        return coord.getGroupId() + ":" + coord.getArtifactId();
    }

    private String getGAVKey(ArtifactCoordinates coord) {
        return coord.getGroupId() + ":" + coord.getArtifactId() + ":" + coord.getVersion();
    }

    private File getGADir(ArtifactCoordinates coord) {
        File dir = new File(this.root, coord.getGroupId() + "/" + coord.getArtifactId());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private File getGAFile(File gaDir, String repoGuid) {
        return new File(gaDir, "meta-ga-" + repoGuid + ".xml");
    }

    private File getGAVDir(ArtifactCoordinates coord) {
        File dir;
        String version = coord.getVersion();
        Quality q = new Quality(version);
        if (q.compareTo(Quality.SNAPSHOT_TS_QUALITY) == 0) {
            DefaultArtifactVersion dav = new DefaultArtifactVersion(version);
            version = dav.getBase() + "-" + "SNAPSHOT";
        }
        if (!(dir = new File(this.getGADir(coord), coord.getArtifactId() + "-" + version)).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private File getGAVFile(File gavDir, String repoGuid) {
        return new File(gavDir, "meta-gav-" + repoGuid + ".xml");
    }

    public void register(MercuryEventListener listener) {
        if (this._eventManager == null) {
            this._eventManager = new EventManager();
        }
        this._eventManager.register(listener);
    }

    public void unRegister(MercuryEventListener listener) {
        if (this._eventManager != null) {
            this._eventManager.unRegister(listener);
        }
    }

    public void setEventManager(EventManager eventManager) {
        if (this._eventManager == null) {
            this._eventManager = eventManager;
        } else {
            this._eventManager.getListeners().addAll(eventManager.getListeners());
        }
    }
}

