/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.cache.md;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.mercury.repository.cache.md.Attribute;

public class Element
implements Serializable {
    private String name;
    private List attributes;
    private List elements;
    private String modelEncoding = "UTF-8";

    public void addAttribute(Attribute attribute) {
        if (!(attribute instanceof Attribute)) {
            throw new ClassCastException("Element.addAttributes(attribute) parameter must be instanceof " + Attribute.class.getName());
        }
        this.getAttributes().add(attribute);
    }

    public void addElement(Element element) {
        if (!(element instanceof Element)) {
            throw new ClassCastException("Element.addElements(element) parameter must be instanceof " + Element.class.getName());
        }
        this.getElements().add(element);
        element.createElementAssociation(this);
    }

    public void breakElementAssociation(Element element) {
        if (!this.getElements().contains(element)) {
            throw new IllegalStateException("element isn't associated.");
        }
        this.getElements().remove(element);
    }

    public void createElementAssociation(Element element) {
        List elements = this.getElements();
        if (this.getElements().contains(element)) {
            throw new IllegalStateException("element is already assigned.");
        }
        elements.add(element);
    }

    public List getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        return this.attributes;
    }

    public List getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        return this.elements;
    }

    public String getName() {
        return this.name;
    }

    public void removeAttribute(Attribute attribute) {
        if (!(attribute instanceof Attribute)) {
            throw new ClassCastException("Element.removeAttributes(attribute) parameter must be instanceof " + Attribute.class.getName());
        }
        this.getAttributes().remove(attribute);
    }

    public void removeElement(Element element) {
        if (!(element instanceof Element)) {
            throw new ClassCastException("Element.removeElements(element) parameter must be instanceof " + Element.class.getName());
        }
        element.breakElementAssociation(this);
        this.getElements().remove(element);
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

