/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.cache.md.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.apache.maven.mercury.repository.cache.md.Attribute;
import org.apache.maven.mercury.repository.cache.md.CachedRawMetadata;
import org.apache.maven.mercury.repository.cache.md.Element;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class CachedMetadataXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, CachedRawMetadata cachedRawMetadata) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(cachedRawMetadata.getModelEncoding(), null);
        this.writeCachedRawMetadata(cachedRawMetadata, "cachedRawMetadata", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeAttribute(Attribute attribute, String tagName, XmlSerializer serializer) throws IOException {
        if (attribute != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (attribute.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(attribute.getName()).endTag(this.NAMESPACE, "name");
            }
            if (attribute.getValue() != null) {
                serializer.startTag(this.NAMESPACE, "value").text(attribute.getValue()).endTag(this.NAMESPACE, "value");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeCachedRawMetadata(CachedRawMetadata cachedRawMetadata, String tagName, XmlSerializer serializer) throws IOException {
        if (cachedRawMetadata != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (cachedRawMetadata.getLastUpdated() != null) {
                serializer.startTag(this.NAMESPACE, "lastUpdated").text(cachedRawMetadata.getLastUpdated()).endTag(this.NAMESPACE, "lastUpdated");
            }
            if (cachedRawMetadata.getElements() != null && cachedRawMetadata.getElements().size() > 0) {
                serializer.startTag(this.NAMESPACE, "elements");
                for (Element o : cachedRawMetadata.getElements()) {
                    this.writeElement(o, "element", serializer);
                }
                serializer.endTag(this.NAMESPACE, "elements");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeElement(Element element, String tagName, XmlSerializer serializer) throws IOException {
        if (element != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (element.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(element.getName()).endTag(this.NAMESPACE, "name");
            }
            if (element.getAttributes() != null && element.getAttributes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "attributes");
                for (Serializable o : element.getAttributes()) {
                    this.writeAttribute((Attribute)o, "attribute", serializer);
                }
                serializer.endTag(this.NAMESPACE, "attributes");
            }
            if (element.getElements() != null && element.getElements().size() > 0) {
                serializer.startTag(this.NAMESPACE, "elements");
                for (Serializable o : element.getElements()) {
                    this.writeElement((Element)o, "element", serializer);
                }
                serializer.endTag(this.NAMESPACE, "elements");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

