/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.local.m2;

import java.io.File;
import org.apache.maven.mercury.builder.api.DependencyProcessor;
import org.apache.maven.mercury.repository.api.AbstractRepository;
import org.apache.maven.mercury.repository.api.LocalRepository;
import org.apache.maven.mercury.repository.api.NonExistentProtocolException;
import org.apache.maven.mercury.repository.api.RepositoryReader;
import org.apache.maven.mercury.repository.api.RepositoryWriter;
import org.apache.maven.mercury.repository.local.m2.LocalRepositoryReaderM2;
import org.apache.maven.mercury.repository.local.m2.LocalRepositoryWriterM2;
import org.apache.maven.mercury.transport.api.Server;

public class LocalRepositoryM2
extends AbstractRepository
implements LocalRepository {
    private File directory;
    public static final String METADATA_FILE_NAME = "maven-metadata-local.xml";

    private void setDirectory(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("null.directory");
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.directory = directory;
    }

    public LocalRepositoryM2(Server server, DependencyProcessor dependencyProcessor) {
        super(server.getId(), "m2");
        this.setDirectory(new File(server.getURL().getFile()));
        this.server = server;
        this.setDependencyProcessor(dependencyProcessor);
    }

    public LocalRepositoryM2(String id, File directory, DependencyProcessor dependencyProcessor) {
        super(id, "m2");
        this.setDirectory(directory);
        this.setDependencyProcessor(dependencyProcessor);
    }

    public LocalRepositoryM2(String id, File directory, String type, DependencyProcessor dependencyProcessor) {
        super(id, type);
        this.setDirectory(directory);
        this.setDependencyProcessor(dependencyProcessor);
    }

    public File getDirectory() {
        return this.directory;
    }

    public RepositoryReader getReader() {
        return new LocalRepositoryReaderM2(this, this.getDependencyProcessor());
    }

    public RepositoryReader getReader(String protocol) {
        return this.getReader();
    }

    public RepositoryWriter getWriter() {
        return new LocalRepositoryWriterM2(this);
    }

    public RepositoryWriter getWriter(String protocol) throws NonExistentProtocolException {
        return this.getWriter();
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWriteable() {
        return true;
    }

    public String getType() {
        return "m2";
    }

    public String getMetadataName() {
        return METADATA_FILE_NAME;
    }
}

