/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.local.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.mercury.artifact.Artifact;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.DefaultArtifact;
import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.QualityRange;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.artifact.version.VersionException;
import org.apache.maven.mercury.artifact.version.VersionRange;
import org.apache.maven.mercury.artifact.version.VersionRangeFactory;
import org.apache.maven.mercury.builder.api.DependencyProcessor;
import org.apache.maven.mercury.builder.api.MetadataReader;
import org.apache.maven.mercury.builder.api.MetadataReaderException;
import org.apache.maven.mercury.crypto.api.StreamObserverException;
import org.apache.maven.mercury.crypto.api.StreamVerifier;
import org.apache.maven.mercury.crypto.api.StreamVerifierException;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.repository.api.AbstracRepositoryReader;
import org.apache.maven.mercury.repository.api.AbstractRepOpResult;
import org.apache.maven.mercury.repository.api.ArtifactBasicResults;
import org.apache.maven.mercury.repository.api.ArtifactResults;
import org.apache.maven.mercury.repository.api.LocalRepository;
import org.apache.maven.mercury.repository.api.Repository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.api.RepositoryReader;
import org.apache.maven.mercury.repository.local.m2.ArtifactLocation;
import org.apache.maven.mercury.util.FileUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRepositoryReaderM2
extends AbstracRepositoryReader
implements RepositoryReader,
MetadataReader {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(LocalRepositoryReaderM2.class);
    private static final Language _lang = new DefaultLanguage(LocalRepositoryReaderM2.class);
    private static final String[] _protocols = new String[]{"file"};
    LocalRepository _repo;
    File _repoDir;

    public LocalRepositoryReaderM2(LocalRepository repo, DependencyProcessor mdProcessor) {
        if (repo == null) {
            throw new IllegalArgumentException("localRepo cannot be null");
        }
        this._repoDir = repo.getDirectory();
        if (this._repoDir == null) {
            throw new IllegalArgumentException("localRepo directory cannot be null");
        }
        if (!this._repoDir.exists()) {
            throw new IllegalArgumentException("localRepo directory \"" + this._repoDir.getAbsolutePath() + "\" should exist");
        }
        this._repo = repo;
        if (mdProcessor == null) {
            throw new IllegalArgumentException("MetadataProcessor cannot be null ");
        }
        this.setDependencyProcessor(mdProcessor);
    }

    public Repository getRepository() {
        return this._repo;
    }

    private static ArtifactLocation calculateLocation(String root, ArtifactBasicMetadata bmd, AbstractRepOpResult res) {
        ArtifactLocation loc = new ArtifactLocation(root, bmd);
        File gaDir = new File(root, loc.getGaPath());
        if (!gaDir.exists()) {
            res.addError(bmd, (Exception)new RepositoryException(_lang.getMessage("ga.not.found", new String[]{bmd.toString(), loc.getGaPath()})));
            return null;
        }
        Quality vq = new Quality(loc.getVersion());
        if ("RELEASE".equals(loc.getVersion()) || "LATEST".equals(loc.getVersion())) {
            File[] files;
            boolean noSnapshots = "RELEASE".equals(loc.getVersion());
            loc.setVersion(null);
            DefaultArtifactVersion tempDav = null;
            DefaultArtifactVersion tempDav2 = null;
            for (File vf : files = gaDir.listFiles()) {
                if (vf.isFile()) continue;
                String vn = vf.getName();
                if (noSnapshots && vn.endsWith("SNAPSHOT")) continue;
                if (loc.getVersion() == null) {
                    loc.setVersion(vn);
                    tempDav = new DefaultArtifactVersion(vn);
                    continue;
                }
                tempDav2 = new DefaultArtifactVersion(vn);
                if (tempDav2.compareTo((Object)tempDav) <= 0) continue;
                loc.setVersion(vn);
                tempDav = tempDav2;
            }
            if (loc.getVersion() == null) {
                res.addError(bmd, (Exception)new RepositoryException(_lang.getMessage("gav.not.found", new String[]{bmd.toString(), loc.getGaPath()})));
                return null;
            }
            if (loc.getVersion().endsWith("SNAPSHOT")) {
                loc.setVersionDir(loc.getVersion());
                if (!LocalRepositoryReaderM2.findLatestSnapshot(bmd, loc, res)) {
                    return null;
                }
            } else {
                loc.setVersionDir(loc.getVersion());
            }
        } else if (loc.getVersion().endsWith("SNAPSHOT")) {
            File gavDir = new File(gaDir, loc.getVersion());
            if (!gavDir.exists()) {
                res.addError(bmd, (Exception)new RepositoryException(_lang.getMessage("gavdir.not.found", new String[]{bmd.toString(), gavDir.getAbsolutePath()})));
                return null;
            }
            if (!LocalRepositoryReaderM2.findLatestSnapshot(bmd, loc, res)) {
                return null;
            }
        } else if (vq.equals((Object)Quality.SNAPSHOT_TS_QUALITY)) {
            loc.setVersionDir(loc.getBaseVersion() + "-" + "SNAPSHOT");
        }
        return loc;
    }

    public ArtifactResults readArtifacts(Collection<ArtifactBasicMetadata> query) throws RepositoryException, IllegalArgumentException {
        if (query == null || query.isEmpty()) {
            throw new IllegalArgumentException(_lang.getMessage("empty.query", new String[]{query == null ? "null" : "empty"}));
        }
        ArtifactResults res = new ArtifactResults();
        Set vFacs = null;
        if (this._repo.hasServer() && this._repo.getServer().hasReaderStreamVerifierFactories()) {
            vFacs = this._repo.getServer().getReaderStreamVerifierFactories();
        }
        for (ArtifactBasicMetadata bmd : query) {
            DefaultArtifact da;
            DefaultArtifact defaultArtifact = da = bmd instanceof DefaultArtifact ? (DefaultArtifact)bmd : new DefaultArtifact(bmd);
            ArtifactLocation loc = LocalRepositoryReaderM2.calculateLocation(this._repoDir.getAbsolutePath(), bmd, (AbstractRepOpResult)res);
            if (loc == null) continue;
            File binary = new File(loc.getAbsPath());
            if (!binary.exists()) {
                res.addError(bmd, (Exception)new RepositoryException(_lang.getMessage("binary.not.found", new String[]{bmd.toString(), binary.getAbsolutePath()})));
                continue;
            }
            try {
                if (LocalRepositoryReaderM2.checkFile(binary, vFacs)) {
                    da.setFile(binary);
                    da.setTracker((Object)this._repo);
                }
                if ("pom".equals(bmd.getType())) {
                    da.setPomBlob(FileUtil.readRawData((File)binary));
                } else {
                    File pomFile = new File(loc.getAbsPomPath());
                    if (pomFile.exists()) {
                        if (LocalRepositoryReaderM2.checkFile(pomFile, vFacs)) {
                            da.setPomBlob(FileUtil.readRawData((File)pomFile));
                        }
                    } else {
                        _log.warn(_lang.getMessage("pom.not.found", new String[]{bmd.toString()}));
                    }
                }
                da.setVersion(loc.getVersion());
                res.add(bmd, (Artifact)da);
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return res;
    }

    private static boolean checkFile(File f, Set<StreamVerifierFactory> vFacs) throws RepositoryException, StreamVerifierException {
        if (vFacs != null) {
            String fileName = f.getAbsolutePath();
            HashSet<StreamVerifier> vs = new HashSet<StreamVerifier>(vFacs.size());
            for (StreamVerifierFactory svf : vFacs) {
                StreamVerifier sv = svf.newInstance();
                String ext = sv.getAttributes().getExtension();
                String sigFileName = fileName + (ext.startsWith(".") ? "" : ".") + ext;
                File sigFile = new File(sigFileName);
                if (sigFile.exists()) {
                    try {
                        sv.initSignature(FileUtil.readRawDataAsString((File)sigFile));
                    }
                    catch (IOException e) {
                        throw new RepositoryException(_lang.getMessage("cannot.read.signature.file", new String[]{sigFileName, e.getMessage()}));
                    }
                    vs.add(sv);
                    continue;
                }
                if (sv.getAttributes().isLenient()) continue;
                throw new RepositoryException(_lang.getMessage("no.signature.file", new String[]{ext, sigFileName}));
            }
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(f);
                byte[] buf = new byte[1024];
                int n = -1;
                while ((n = fin.read(buf)) != -1) {
                    for (StreamVerifier sv : vs) {
                        try {
                            sv.bytesReady(buf, 0, n);
                        }
                        catch (StreamObserverException e) {
                            if (sv.getAttributes().isLenient()) continue;
                            throw new RepositoryException((Throwable)e);
                        }
                    }
                }
                for (StreamVerifier sv : vs) {
                    if (sv.verifySignature()) {
                        if (!sv.getAttributes().isSufficient()) continue;
                        break;
                    }
                    if (sv.getAttributes().isLenient()) continue;
                    throw new RepositoryException(_lang.getMessage("signature.failed", new String[]{sv.getAttributes().getExtension(), fileName}));
                }
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception any) {}
                }
            }
        }
        return true;
    }

    public ArtifactBasicResults readDependencies(Collection<ArtifactBasicMetadata> query) throws RepositoryException, IllegalArgumentException {
        if (query == null || query.size() < 1) {
            return null;
        }
        ArtifactBasicResults ror = null;
        File pomFile = null;
        for (ArtifactBasicMetadata bmd : query) {
            String pomPath = bmd.getGroupId().replace('.', '/') + "/" + bmd.getArtifactId() + "/" + bmd.getVersion() + "/" + bmd.getArtifactId() + '-' + bmd.getVersion() + ".pom";
            pomFile = new File(this._repoDir, pomPath);
            if (!pomFile.exists()) {
                _log.warn("file \"" + pomPath + "\" does not exist in local repo");
                continue;
            }
            try {
                List deps = this._mdProcessor.getDependencies(bmd, (MetadataReader)(this._mdReader == null ? this : this._mdReader), System.getenv(), (Map)System.getProperties());
                ror = ArtifactBasicResults.add(ror, (ArtifactBasicMetadata)bmd, (List)deps);
            }
            catch (Exception e) {
                _log.warn("error reading " + bmd.toString() + " dependencies", (Throwable)e);
            }
        }
        return ror;
    }

    private static boolean findLatestSnapshot(ArtifactBasicMetadata bmd, ArtifactLocation loc, AbstractRepOpResult res) {
        File binary = new File(loc.getAbsPath());
        if (binary.exists()) {
            return true;
        }
        File gavDir = new File(loc.getGavPath());
        File[] files = gavDir.listFiles();
        loc.setVersion(null);
        DefaultArtifactVersion tempDav = null;
        DefaultArtifactVersion tempDav2 = null;
        int aLen = loc.getBaseName().length();
        for (File vf : files) {
            String vn;
            if (vf.isFile() || (vn = vf.getName().substring(aLen + 1)).endsWith("SNAPSHOT")) continue;
            if (loc.getVersion() == null) {
                loc.setVersion(vn);
                tempDav = new DefaultArtifactVersion(vn);
                continue;
            }
            tempDav2 = new DefaultArtifactVersion(vn);
            if (tempDav2.compareTo((Object)tempDav) <= 0) continue;
            loc.setVersion(vn);
            tempDav = tempDav2;
        }
        if (loc.getVersion() == null) {
            res.addError(bmd, (Exception)new RepositoryException(_lang.getMessage("snapshot.not.found", new String[]{bmd.toString(), gavDir.getAbsolutePath()})));
            return false;
        }
        return true;
    }

    public ArtifactBasicResults readVersions(Collection<ArtifactBasicMetadata> query) throws RepositoryException, IllegalArgumentException {
        if (query == null || query.size() < 1) {
            return null;
        }
        ArtifactBasicResults res = new ArtifactBasicResults(query.size());
        File gaDir = null;
        for (ArtifactBasicMetadata bmd : query) {
            VersionRange versionQuery;
            gaDir = new File(this._repoDir, bmd.getGroupId().replace('.', '/') + "/" + bmd.getArtifactId());
            if (!gaDir.exists()) continue;
            File[] versionFiles = gaDir.listFiles();
            try {
                versionQuery = VersionRangeFactory.create((String)bmd.getVersion(), (QualityRange)this._repo.getVersionRangeQualityRange());
            }
            catch (VersionException e) {
                res = ArtifactBasicResults.add((ArtifactBasicResults)res, (ArtifactBasicMetadata)bmd, (Exception)new RepositoryException((Throwable)e));
                continue;
            }
            Quality vq = new Quality(bmd.getVersion());
            if (vq.equals((Object)Quality.FIXED_RELEASE_QUALITY) || vq.equals((Object)Quality.FIXED_LATEST_QUALITY) || vq.equals((Object)Quality.SNAPSHOT_QUALITY)) {
                ArtifactLocation loc = LocalRepositoryReaderM2.calculateLocation(this._repoDir.getAbsolutePath(), bmd, (AbstractRepOpResult)res);
                if (loc == null) continue;
                ArtifactBasicMetadata vmd = new ArtifactBasicMetadata();
                vmd.setGroupId(bmd.getGroupId());
                vmd.setArtifactId(bmd.getArtifactId());
                vmd.setClassifier(bmd.getClassifier());
                vmd.setType(bmd.getType());
                vmd.setVersion(loc.getVersion());
                res = ArtifactBasicResults.add((ArtifactBasicResults)res, (ArtifactBasicMetadata)bmd, (ArtifactBasicMetadata)vmd);
                continue;
            }
            for (File vf : versionFiles) {
                String version;
                Quality q;
                if (!vf.isDirectory() || !this._repo.isAcceptedQuality(q = new Quality(version = vf.getName())) || !versionQuery.includes(vf.getName())) continue;
                ArtifactBasicMetadata vmd = new ArtifactBasicMetadata();
                vmd.setGroupId(bmd.getGroupId());
                vmd.setArtifactId(bmd.getArtifactId());
                vmd.setClassifier(bmd.getClassifier());
                vmd.setType(bmd.getType());
                vmd.setVersion(vf.getName());
                res = ArtifactBasicResults.add((ArtifactBasicResults)res, (ArtifactBasicMetadata)bmd, (ArtifactBasicMetadata)vmd);
            }
        }
        return res;
    }

    public byte[] readRawData(ArtifactBasicMetadata bmd, String classifier, String type) throws MetadataReaderException {
        return this.readRawData(LocalRepositoryReaderM2.relPathOf(bmd, classifier, type, null));
    }

    private static String relPathOf(ArtifactBasicMetadata bmd, String classifier, String type, DefaultArtifactVersion inDav) {
        Quality aq;
        DefaultArtifactVersion dav = inDav;
        if (inDav == null) {
            dav = new DefaultArtifactVersion(bmd.getVersion());
        }
        boolean isSnapshot = (aq = dav.getQuality()).equals((Object)Quality.SNAPSHOT_QUALITY) || aq.equals((Object)Quality.SNAPSHOT_TS_QUALITY);
        String bmdPath = bmd.getGroupId().replace('.', '/') + '/' + bmd.getArtifactId() + '/' + (isSnapshot ? dav.getBase() + '-' + "SNAPSHOT" : bmd.getVersion());
        String path = bmdPath + '/' + bmd.getBaseName(classifier) + '.' + (type == null ? bmd.getType() : type);
        return path;
    }

    public byte[] readRawData(String path) throws MetadataReaderException {
        File file = new File(this._repoDir, path);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            int len = (int)file.length();
            byte[] pom = new byte[len];
            fis.read(pom);
            byte[] byArray = pom;
            return byArray;
        }
        catch (IOException e) {
            throw new MetadataReaderException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception any) {}
            }
        }
    }

    public String readStringData(String path) throws MetadataReaderException {
        byte[] data = this.readRawData(path);
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    public boolean canHandle(String protocol) {
        return "file".equals(protocol);
    }

    public String[] getProtocols() {
        return _protocols;
    }

    public void close() {
    }
}

