/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.remote.m2;

import org.apache.maven.mercury.builder.api.DependencyProcessor;
import org.apache.maven.mercury.repository.api.AbstractRepository;
import org.apache.maven.mercury.repository.api.NonExistentProtocolException;
import org.apache.maven.mercury.repository.api.RemoteRepository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.api.RepositoryReader;
import org.apache.maven.mercury.repository.api.RepositoryUpdateIntervalPolicy;
import org.apache.maven.mercury.repository.api.RepositoryUpdatePolicy;
import org.apache.maven.mercury.repository.api.RepositoryWriter;
import org.apache.maven.mercury.repository.remote.m2.RemoteRepositoryReaderM2;
import org.apache.maven.mercury.repository.remote.m2.RemoteRepositoryWriterM2;
import org.apache.maven.mercury.transport.api.Server;

public class RemoteRepositoryM2
extends AbstractRepository
implements RemoteRepository {
    public static final String METADATA_FILE_NAME = "maven-metadata.xml";
    private Server _server;
    private RepositoryUpdatePolicy _updatePolicy = new RepositoryUpdateIntervalPolicy("daily");

    public RemoteRepositoryM2(Server server, DependencyProcessor dependencyProcessor) {
        this(server.getId(), server, dependencyProcessor);
    }

    public RemoteRepositoryM2(String id, Server server, DependencyProcessor dependencyProcessor) {
        super(id, "m2");
        this._server = server;
        this.setDependencyProcessor(dependencyProcessor);
    }

    public Server getServer() {
        return this._server;
    }

    public RepositoryReader getReader() throws RepositoryException {
        return new RemoteRepositoryReaderM2(this, this.getDependencyProcessor());
    }

    public RepositoryReader getReader(String protocol) throws RepositoryException {
        return this.getReader();
    }

    public RepositoryWriter getWriter() throws RepositoryException {
        return new RemoteRepositoryWriterM2(this);
    }

    public RepositoryWriter getWriter(String protocol) throws NonExistentProtocolException {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWriteable() {
        return true;
    }

    public String getType() {
        return "m2";
    }

    public RepositoryUpdatePolicy getUpdatePolicy() {
        return this._updatePolicy;
    }

    public void setUpdatePolicy(RepositoryUpdatePolicy updatePolicy) {
        this._updatePolicy = updatePolicy;
    }

    public String getMetadataName() {
        return METADATA_FILE_NAME;
    }
}

