/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.remote.m2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.mercury.artifact.Artifact;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.ArtifactCoordinates;
import org.apache.maven.mercury.artifact.DefaultArtifact;
import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.QualityRange;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.artifact.version.VersionException;
import org.apache.maven.mercury.artifact.version.VersionRange;
import org.apache.maven.mercury.artifact.version.VersionRangeFactory;
import org.apache.maven.mercury.builder.api.DependencyProcessor;
import org.apache.maven.mercury.builder.api.MetadataReader;
import org.apache.maven.mercury.builder.api.MetadataReaderException;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.repository.api.AbstracRepositoryReader;
import org.apache.maven.mercury.repository.api.AbstractRepOpResult;
import org.apache.maven.mercury.repository.api.ArtifactBasicResults;
import org.apache.maven.mercury.repository.api.ArtifactResults;
import org.apache.maven.mercury.repository.api.LocalRepository;
import org.apache.maven.mercury.repository.api.MetadataCacheException;
import org.apache.maven.mercury.repository.api.MetadataCorruptionException;
import org.apache.maven.mercury.repository.api.RemoteRepository;
import org.apache.maven.mercury.repository.api.Repository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.api.RepositoryGAMetadata;
import org.apache.maven.mercury.repository.api.RepositoryGAVMetadata;
import org.apache.maven.mercury.repository.api.RepositoryReader;
import org.apache.maven.mercury.repository.local.m2.ArtifactLocation;
import org.apache.maven.mercury.repository.local.m2.LocalRepositoryM2;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataBuilder;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.remote.m2.RemoteRepositoryM2OperationException;
import org.apache.maven.mercury.spi.http.client.HttpClientException;
import org.apache.maven.mercury.spi.http.client.retrieve.DefaultRetrievalRequest;
import org.apache.maven.mercury.spi.http.client.retrieve.DefaultRetriever;
import org.apache.maven.mercury.spi.http.client.retrieve.RetrievalRequest;
import org.apache.maven.mercury.spi.http.client.retrieve.RetrievalResponse;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.apache.maven.mercury.util.FileUtil;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRepositoryReaderM2
extends AbstracRepositoryReader
implements RepositoryReader,
MetadataReader {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(RemoteRepositoryReaderM2.class);
    private static final Language _lang = new DefaultLanguage(RemoteRepositoryReaderM2.class);
    private static final String[] _protocols = new String[]{"http", "https", "dav", "webdav"};
    DefaultRetriever _transport;
    RemoteRepository _repo;
    List<LocalRepository> _localRepos;
    File _defaultRoot;

    public RemoteRepositoryReaderM2(RemoteRepository repo, DependencyProcessor mdProcessor) throws RepositoryException {
        this(repo, mdProcessor, null);
    }

    public RemoteRepositoryReaderM2(RemoteRepository repo, DependencyProcessor mdProcessor, List<LocalRepository> localRepos) throws RepositoryException {
        if (repo == null) {
            throw new IllegalArgumentException(_lang.getMessage("bad.repository.null", new String[0]));
        }
        if (repo.getServer() == null) {
            throw new IllegalArgumentException(_lang.getMessage("bad.repository.server.null", new String[0]));
        }
        if (repo.getServer().getURL() == null) {
            throw new IllegalArgumentException(_lang.getMessage("bad.repository.server.url.null", new String[0]));
        }
        this._repo = repo;
        if (mdProcessor == null) {
            throw new IllegalArgumentException("MetadataProcessor cannot be null ");
        }
        this.setDependencyProcessor(mdProcessor);
        try {
            File temp = File.createTempFile("temp-", "-locator");
            this._defaultRoot = new File(temp.getParentFile(), "repo");
            this._defaultRoot.mkdirs();
            _log.info("temporary repository  folder set to " + this._defaultRoot.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        if (localRepos == null || localRepos.isEmpty()) {
            this._localRepos = new ArrayList<LocalRepository>(1);
            this._localRepos.add((LocalRepository)new LocalRepositoryM2("temp", this._defaultRoot, this.getDependencyProcessor()));
        } else {
            this._localRepos = localRepos;
        }
        try {
            this._transport = new DefaultRetriever();
            HashSet<Server> servers = new HashSet<Server>(1);
            servers.add(repo.getServer());
            this._transport.setServers(servers);
        }
        catch (HttpClientException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Repository getRepository() {
        return this._repo;
    }

    private final ArtifactLocation calculateLocation(String root, ArtifactBasicMetadata bmd, AbstractRepOpResult res) throws RepositoryException, MetadataReaderException, MetadataException {
        ArtifactLocation loc = new ArtifactLocation(root, bmd);
        Collection<String> versions = null;
        try {
            versions = this.getCachedVersions(loc, bmd);
        }
        catch (MetadataCacheException e) {
            throw new MetadataException((Throwable)e);
        }
        if (Util.isEmpty(versions)) {
            throw new RepositoryException(_lang.getMessage("group.md.no.versions", new String[]{this._repo.getServer().getURL().toString(), loc.getGaPath()}));
        }
        Quality vq = new Quality(loc.getVersion());
        if ("RELEASE".equals(loc.getVersion()) || "LATEST".equals(loc.getVersion())) {
            boolean noSnapshots = "RELEASE".equals(loc.getVersion());
            String ver = VersionRangeFactory.findLatest(versions, (boolean)noSnapshots);
            if (ver == null) {
                res.addError(bmd, (Exception)new RepositoryException(_lang.getMessage("gav.not.found", new String[]{bmd.toString(), loc.getGaPath()})));
                return null;
            }
            loc.setVersion(ver);
            if (loc.getVersion().endsWith("SNAPSHOT")) {
                loc.setVersionDir(loc.getVersion());
                if (!this.findLatestSnapshot(bmd, loc, res)) {
                    return null;
                }
            } else {
                loc.setVersionDir(loc.getVersion());
            }
        } else if (loc.getVersion().endsWith("SNAPSHOT")) {
            if (!versions.contains(loc.getVersion()) && !this.findLatestSnapshot(bmd, loc, res)) {
                return null;
            }
        } else if (vq.equals((Object)Quality.SNAPSHOT_TS_QUALITY)) {
            loc.setVersionDir(loc.getBaseVersion() + "-" + "SNAPSHOT");
        }
        return loc;
    }

    private Collection<String> getCachedSnapshots(ArtifactBasicMetadata bmd, ArtifactLocation loc) throws MetadataCacheException, RepositoryException, MetadataReaderException, MetadataException {
        String mdPath;
        byte[] mdBytes;
        RepositoryGAVMetadata gavm = null;
        ArtifactCoordinates coord = null;
        if (this._mdCache != null) {
            try {
                coord = bmd.getEffectiveCoordinates();
                coord.setVersion(loc.getVersion());
                gavm = this._mdCache.findGAV(this._repo.getId(), this._repo.getUpdatePolicy(), coord);
                if (gavm != null) {
                    return gavm.getSnapshots();
                }
            }
            catch (MetadataCorruptionException e) {
                _log.error(_lang.getMessage("cached.data.problem", new String[]{e.getMessage(), bmd.toString()}));
            }
        }
        if ((mdBytes = this.readRawData(mdPath = loc.getGavPath() + '/' + this._repo.getMetadataName())) == null) {
            throw new RepositoryException(_lang.getMessage("no.gav.md", new String[]{this._repo.getServer().getURL().toString(), mdPath}));
        }
        Metadata gavMd = MetadataBuilder.read((InputStream)new ByteArrayInputStream(mdBytes));
        if (gavMd == null) {
            throw new RepositoryException(_lang.getMessage("gav.md.no.versions", new String[]{this._repo.getServer().getURL().toString(), mdPath}));
        }
        gavm = new RepositoryGAVMetadata(gavMd);
        if (this._mdCache != null) {
            this._mdCache.updateGAV(this._repo.getId(), gavm);
        }
        if (Util.isEmpty((Collection)gavm.getSnapshots())) {
            throw new RepositoryException(_lang.getMessage("gav.md.no.versions", new String[]{this._repo.getServer().getURL().toString(), mdPath}));
        }
        return gavm.getSnapshots();
    }

    private boolean findLatestSnapshot(ArtifactBasicMetadata bmd, ArtifactLocation loc, AbstractRepOpResult res) throws MetadataReaderException, MetadataException, RemoteRepositoryM2OperationException {
        DefaultArtifactVersion dav = new DefaultArtifactVersion(loc.getVersion());
        Collection<String> versions = null;
        try {
            versions = this.getCachedSnapshots(bmd, loc);
        }
        catch (Exception e) {
            res.addError(bmd, (Exception)new RepositoryException(_lang.getMessage("cached.metadata.reading.exception", new String[]{e.getMessage(), bmd.toString(), this._repo.getServer().getURL().toString()})));
            return false;
        }
        if (versions.contains(loc.getVersion())) {
            return true;
        }
        String ver = VersionRangeFactory.findLatest(versions, (boolean)true);
        if (ver == null) {
            res.addError(bmd, (Exception)new RepositoryException(_lang.getMessage("snapshot.not.found", new String[]{this._repo.getServer().getURL().toString(), bmd.toString()})));
            return false;
        }
        loc.setVersion(ver);
        return true;
    }

    public ArtifactResults readArtifacts(Collection<ArtifactBasicMetadata> query) throws RepositoryException {
        if (query == null || query.size() < 1) {
            return null;
        }
        ArtifactResults res = new ArtifactResults();
        for (ArtifactBasicMetadata bmd : query) {
            try {
                this.readArtifact(bmd, res);
            }
            catch (Exception e) {
                res.addError(bmd, e);
            }
        }
        return res;
    }

    private File findLocalRoot(Quality vq) {
        for (LocalRepository lr : this._localRepos) {
            if (!lr.isWriteable() || !lr.getVersionRangeQualityRange().isAcceptedQuality(vq)) continue;
            return lr.getDirectory();
        }
        return this._defaultRoot;
    }

    public void readArtifact(ArtifactBasicMetadata bmd, ArtifactResults res) throws IOException, RepositoryException, MetadataReaderException, MetadataException {
        RetrievalResponse resp;
        DefaultArtifact da = bmd instanceof DefaultArtifact ? (DefaultArtifact)bmd : new DefaultArtifact(bmd);
        ArtifactLocation loc = this.calculateLocation(this._repo.getServer().getURL().toString(), bmd, (AbstractRepOpResult)res);
        if (loc == null) {
            return;
        }
        da.setVersion(loc.getVersion());
        Quality vq = new Quality(loc.getVersion());
        File root = this.findLocalRoot(vq);
        File binFile = new File(root, loc.getRelPath());
        File pomFile = null;
        DefaultRetrievalRequest drr = new DefaultRetrievalRequest();
        Binding binBinding = new Binding(new URL(loc.getAbsPath()), binFile);
        drr.addBinding(binBinding);
        boolean isPom = "pom".equals(bmd.getType());
        if (!isPom) {
            pomFile = new File(root, loc.getRelPomPath());
            Binding pomBinding = new Binding(new URL(loc.getAbsPomPath()), pomFile);
            drr.addBinding(pomBinding);
        }
        if ((resp = this._transport.retrieve((RetrievalRequest)drr)).hasExceptions()) {
            res.addError(bmd, (Exception)new RepositoryException(resp.getExceptions().toString()));
        } else {
            da.setFile(binFile);
            da.setPomBlob(FileUtil.readRawData((File)(isPom ? binFile : pomFile)));
            res.add(bmd, (Artifact)da);
        }
    }

    public ArtifactBasicResults readDependencies(Collection<ArtifactBasicMetadata> query) throws RepositoryException {
        if (query == null || query.size() < 1) {
            return null;
        }
        ArtifactBasicResults ror = new ArtifactBasicResults(16);
        for (ArtifactBasicMetadata bmd : query) {
            try {
                List deps = this._mdProcessor.getDependencies(bmd, (MetadataReader)(this._mdReader == null ? this : this._mdReader), System.getenv(), (Map)System.getProperties());
                ror.add(bmd, deps);
            }
            catch (Exception e) {
                _log.warn("error reading " + bmd.toString() + " dependencies", (Throwable)e);
            }
        }
        return ror;
    }

    private Collection<String> getCachedVersions(ArtifactLocation loc, ArtifactBasicMetadata bmd) throws MetadataException, MetadataReaderException, MetadataCacheException {
        byte[] mavenMetadata;
        RepositoryGAMetadata gam = null;
        ArtifactCoordinates coord = null;
        if (this._mdCache != null) {
            try {
                coord = bmd.getEffectiveCoordinates();
                coord.setVersion(loc.getVersion());
                gam = this._mdCache.findGA(this._repo.getId(), this._repo.getUpdatePolicy(), coord);
                if (gam != null && !gam.isExpired()) {
                    return gam.getVersions();
                }
            }
            catch (MetadataCorruptionException e) {
                _log.error(_lang.getMessage("cached.data.problem", new String[]{e.getMessage(), bmd.toString()}));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug(this._repo.getId() + ": did not find in the cache - go out for " + bmd);
        }
        if ((mavenMetadata = this.readRawData(loc.getGaPath() + "/" + this._repo.getMetadataName())) == null) {
            throw new MetadataReaderException();
        }
        Metadata mmd = MetadataBuilder.getMetadata((byte[])mavenMetadata);
        if (mmd == null || mmd.getVersioning() == null) {
            _log.warn(_lang.getMessage("maven.bad.metadata", new String[]{loc.getGaPath() + "/" + this._repo.getMetadataName(), this._repo.getId()}));
            return null;
        }
        gam = new RepositoryGAMetadata(mmd);
        if (gam == null || Util.isEmpty((Collection)gam.getVersions())) {
            _log.warn(_lang.getMessage("maven.metadata.no.versions", new String[]{loc.getGaPath() + "/" + this._repo.getMetadataName(), this._repo.getId()}));
            return null;
        }
        if (this._mdCache != null) {
            this._mdCache.updateGA(this._repo.getId(), gam);
        }
        return gam.getVersions();
    }

    public ArtifactBasicResults readVersions(Collection<ArtifactBasicMetadata> query) throws RepositoryException {
        if (query == null || query.size() < 1) {
            return null;
        }
        ArtifactBasicResults res = new ArtifactBasicResults(query.size());
        String root = this._repo.getServer().getURL().toString();
        for (ArtifactBasicMetadata bmd : query) {
            VersionRange versionQuery;
            Collection<String> versions;
            ArtifactLocation loc;
            block11: {
                loc = new ArtifactLocation(root, bmd);
                versions = null;
                try {
                    versions = this.getCachedVersions(loc, bmd);
                    if (Util.isEmpty(versions)) {
                    }
                    break block11;
                }
                catch (Exception e) {
                    res.addError(bmd, e);
                }
                continue;
            }
            try {
                versionQuery = VersionRangeFactory.create((String)bmd.getVersion(), (QualityRange)this._repo.getVersionRangeQualityRange());
            }
            catch (VersionException e) {
                res.addError(bmd, (Exception)new RepositoryException((Throwable)e));
                continue;
            }
            Quality vq = new Quality(bmd.getVersion());
            if (vq.equals((Object)Quality.FIXED_RELEASE_QUALITY) || vq.equals((Object)Quality.FIXED_LATEST_QUALITY) || vq.equals((Object)Quality.SNAPSHOT_QUALITY)) {
                try {
                    loc = this.calculateLocation(root, bmd, (AbstractRepOpResult)res);
                }
                catch (Exception e) {
                    res.addError(bmd, e);
                    continue;
                }
                if (loc == null) continue;
                ArtifactBasicMetadata vmd = new ArtifactBasicMetadata();
                vmd.setGroupId(bmd.getGroupId());
                vmd.setArtifactId(bmd.getArtifactId());
                vmd.setClassifier(bmd.getClassifier());
                vmd.setType(bmd.getType());
                vmd.setVersion(loc.getVersion());
                res = ArtifactBasicResults.add((ArtifactBasicResults)res, (ArtifactBasicMetadata)bmd, (ArtifactBasicMetadata)vmd);
                continue;
            }
            for (String version : versions) {
                Quality q = new Quality(version);
                if (!this._repo.isAcceptedQuality(q) || !versionQuery.includes(version)) continue;
                ArtifactBasicMetadata vmd = new ArtifactBasicMetadata();
                vmd.setGroupId(bmd.getGroupId());
                vmd.setArtifactId(bmd.getArtifactId());
                vmd.setClassifier(bmd.getClassifier());
                vmd.setType(bmd.getType());
                vmd.setVersion(version);
                res = ArtifactBasicResults.add((ArtifactBasicResults)res, (ArtifactBasicMetadata)bmd, (ArtifactBasicMetadata)vmd);
            }
        }
        return res;
    }

    public byte[] readRawData(ArtifactBasicMetadata bmd, String classifier, String type) throws MetadataReaderException {
        byte[] res = null;
        ArtifactBasicMetadata mod = null;
        if (this._mdCache != null && "pom".equals(type)) {
            mod = new ArtifactBasicMetadata();
            mod.setGroupId(bmd.getGroupId());
            mod.setArtifactId(bmd.getArtifactId());
            mod.setVersion(bmd.getVersion());
            mod.setClassifier(classifier);
            mod.setType(type);
            try {
                res = this._mdCache.findRaw(mod);
                if (res != null) {
                    return res;
                }
            }
            catch (MetadataCacheException e) {
                _log.error(_lang.getMessage("cached.data.problem", new String[]{e.getMessage(), bmd.toString()}));
            }
        }
        String bmdPath = bmd.getGroupId().replace('.', '/') + '/' + bmd.getArtifactId() + '/' + bmd.getVersion() + '/' + bmd.getBaseName(classifier) + '.' + (type == null ? bmd.getType() : type);
        res = this.readRawData(bmdPath);
        if (this._mdCache != null && res != null && mod != null) {
            try {
                this._mdCache.saveRaw(mod, res);
            }
            catch (MetadataCacheException e) {
                throw new MetadataReaderException((Throwable)e);
            }
        }
        return res;
    }

    public byte[] readRawData(String path) throws MetadataReaderException {
        if (path == null || path.length() < 1) {
            return null;
        }
        FileInputStream fis = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
            String separator = "/";
            if (path.startsWith(separator)) {
                separator = "";
            }
            String url = (path.startsWith("http") ? "" : this._repo.getServer().getURL().toString() + separator) + path;
            Binding binding = new Binding(new URL(url), baos);
            DefaultRetrievalRequest request = new DefaultRetrievalRequest();
            request.addBinding(binding);
            RetrievalResponse response = this._transport.retrieve((RetrievalRequest)request);
            if (response.hasExceptions()) {
                _log.info(_lang.getMessage("read.raw.exceptions", new String[]{path, response.getExceptions().toString()}));
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new MetadataReaderException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception any) {}
            }
        }
    }

    public boolean canHandle(String protocol) {
        return "http".equals(protocol);
    }

    public void close() {
    }

    public String[] getProtocols() {
        return _protocols;
    }
}

