/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.remote.m2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.mercury.artifact.Artifact;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.DefaultArtifact;
import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.repository.api.AbstractRepositoryWriter;
import org.apache.maven.mercury.repository.api.RemoteRepository;
import org.apache.maven.mercury.repository.api.Repository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.api.RepositoryGAMetadata;
import org.apache.maven.mercury.repository.api.RepositoryGAVMetadata;
import org.apache.maven.mercury.repository.api.RepositoryReader;
import org.apache.maven.mercury.repository.api.RepositoryWriter;
import org.apache.maven.mercury.repository.metadata.AddVersionOperation;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataBuilder;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.SetSnapshotOperation;
import org.apache.maven.mercury.repository.metadata.Snapshot;
import org.apache.maven.mercury.repository.metadata.SnapshotOperand;
import org.apache.maven.mercury.repository.metadata.StringOperand;
import org.apache.maven.mercury.spi.http.client.HttpClientException;
import org.apache.maven.mercury.spi.http.client.deploy.DefaultDeployRequest;
import org.apache.maven.mercury.spi.http.client.deploy.DefaultDeployer;
import org.apache.maven.mercury.spi.http.client.deploy.DeployRequest;
import org.apache.maven.mercury.spi.http.client.deploy.DeployResponse;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.apache.maven.mercury.util.FileUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRepositoryWriterM2
extends AbstractRepositoryWriter
implements RepositoryWriter {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(RemoteRepositoryWriterM2.class);
    private static final Language _lang = new DefaultLanguage(RemoteRepositoryWriterM2.class);
    private static final String[] _protocols = new String[]{"http", "https", "dav", "webdav"};
    RemoteRepository _repo;
    Server _server;
    RepositoryReader _reader;
    DefaultDeployer _transport;

    public RemoteRepositoryWriterM2(RemoteRepository repo) throws RepositoryException {
        if (repo == null) {
            throw new IllegalArgumentException("localRepo cannot be null");
        }
        this._server = repo.getServer();
        if (this._server == null) {
            throw new IllegalArgumentException(_lang.getMessage("bad.repository.server.null", new String[0]));
        }
        if (this._server.getURL() == null) {
            throw new IllegalArgumentException(_lang.getMessage("bad.repository.server.url.null", new String[0]));
        }
        this._repo = repo;
        this._reader = this._repo.getReader();
        try {
            this._transport = new DefaultDeployer();
            HashSet<Server> servers = new HashSet<Server>(1);
            servers.add(this._server);
            this._transport.setServers(servers);
        }
        catch (HttpClientException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Repository getRepository() {
        return this._repo;
    }

    public boolean canHandle(String protocol) {
        return "file".equals(protocol);
    }

    public String[] getProtocols() {
        return _protocols;
    }

    public void close() {
    }

    public void writeArtifacts(Collection<Artifact> artifacts) throws RepositoryException {
        if (artifacts == null || artifacts.size() < 1) {
            return;
        }
        HashSet<StreamVerifierFactory> vFacs = null;
        Server server = this._repo.getServer();
        if (server != null && server.hasWriterStreamVerifierFactories()) {
            vFacs = server.getWriterStreamVerifierFactories();
        }
        if (vFacs == null) {
            vFacs = new HashSet<StreamVerifierFactory>(1);
        }
        for (Artifact artifact : artifacts) {
            this.writeArtifact(artifact, vFacs);
        }
    }

    public void writeArtifact(Artifact artifact, Set<StreamVerifierFactory> vFacs) throws RepositoryException {
        DefaultArtifactVersion dav;
        Quality aq;
        InputStream in;
        boolean hasPomBlob;
        byte[] pomBlob;
        boolean isPom;
        block21: {
            if (artifact == null) {
                throw new RepositoryException(_lang.getMessage("null.artifact", new String[0]));
            }
            if (artifact.getFile() == null || !artifact.getFile().exists()) {
                throw new RepositoryException(_lang.getMessage("bad.artifact.file", new String[]{artifact.toString(), artifact.getFile() == null ? "null" : artifact.getFile().getAbsolutePath()}));
            }
            isPom = "pom".equals(artifact.getType());
            pomBlob = artifact.getPomBlob();
            boolean bl = hasPomBlob = pomBlob != null && pomBlob.length > 0;
            if (!artifact.hasClassifier() && !hasPomBlob) {
                throw new RepositoryException(_lang.getMessage("no.pom.in.primary.artifact", new String[]{artifact.toString()}));
            }
            in = artifact.getStream();
            if (in == null) {
                File aFile = artifact.getFile();
                if (aFile == null && !isPom) {
                    throw new RepositoryException(_lang.getMessage("artifact.no.stream", new String[]{artifact.toString()}));
                }
                try {
                    in = new FileInputStream(aFile);
                }
                catch (FileNotFoundException e) {
                    if (isPom) break block21;
                    throw new RepositoryException(_lang.getMessage("artifact.no.file", new String[]{artifact.toString(), aFile.getAbsolutePath(), e.getMessage()}));
                }
            }
        }
        boolean isSnapshot = (aq = (dav = new DefaultArtifactVersion(artifact.getVersion())).getQuality()).equals((Object)Quality.SNAPSHOT_QUALITY) || aq.equals((Object)Quality.SNAPSHOT_TS_QUALITY);
        String relGroupPath = artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId();
        String relVersionPath = relGroupPath + '/' + (isSnapshot ? dav.getBase() + '-' + "SNAPSHOT" : artifact.getVersion());
        try {
            Metadata md;
            if (isPom) {
                if (in == null && !hasPomBlob) {
                    throw new RepositoryException(_lang.getMessage("pom.artifact.no.stream", new String[]{artifact.toString()}));
                }
                if (in != null) {
                    byte[] pomBlobBytes = FileUtil.readRawData((InputStream)in);
                    boolean bl = hasPomBlob = pomBlobBytes != null && pomBlobBytes.length > 0;
                    if (hasPomBlob) {
                        pomBlob = pomBlobBytes;
                    }
                }
            }
            String url = this._server.getURL().toString();
            String gaMdUrl = url + '/' + relGroupPath + '/' + this._repo.getMetadataName();
            byte[] gaMdBytes = this._reader.readRawData(gaMdUrl);
            String gavMdUrl = url + '/' + relVersionPath + '/' + this._repo.getMetadataName();
            byte[] gavMdBytes = this._reader.readRawData(gavMdUrl);
            HashSet<Binding> bindings = new HashSet<Binding>(4);
            String binUrl = url + '/' + relVersionPath + '/' + artifact.getBaseName() + '.' + artifact.getType();
            bindings.add(new Binding(new URL(binUrl), artifact.getFile()));
            Metadata metadata = md = gaMdBytes == null ? null : MetadataBuilder.getMetadata((byte[])gaMdBytes);
            if (md == null) {
                md = new Metadata();
                md.setGroupId(artifact.getGroupId());
                md.setArtifactId(artifact.getArtifactId());
            }
            AddVersionOperation mdOp = null;
            if (isSnapshot) {
                Snapshot sn = MetadataBuilder.createSnapshot((String)artifact.getVersion());
                sn.setLocalCopy(true);
                mdOp = new SetSnapshotOperation(new SnapshotOperand(sn));
            } else {
                mdOp = new AddVersionOperation(new StringOperand(artifact.getVersion()));
            }
            byte[] gaResBytes = MetadataBuilder.changeMetadata((Metadata)md, (MetadataOperation)mdOp);
            Metadata gaMd = MetadataBuilder.getMetadata((byte[])gaResBytes);
            bindings.add(new Binding(new URL(gaMdUrl), (InputStream)new ByteArrayInputStream(gaResBytes)));
            Metadata metadata2 = md = gavMdBytes == null ? null : MetadataBuilder.getMetadata((byte[])gavMdBytes);
            if (md == null) {
                md = new Metadata();
                md.setGroupId(artifact.getGroupId());
                md.setArtifactId(artifact.getArtifactId());
                md.setVersion(artifact.getVersion());
            }
            byte[] gavResBytes = MetadataBuilder.changeMetadata((Metadata)md, (MetadataOperation)mdOp);
            Metadata gavMd = MetadataBuilder.getMetadata((byte[])gavResBytes);
            bindings.add(new Binding(new URL(gavMdUrl), (InputStream)new ByteArrayInputStream(gavResBytes)));
            if (!isPom && hasPomBlob) {
                String pomUrl = url + '/' + relVersionPath + '/' + artifact.getArtifactId() + '-' + artifact.getVersion() + ".pom";
                bindings.add(new Binding(new URL(pomUrl), (InputStream)new ByteArrayInputStream(pomBlob)));
            }
            DefaultDeployRequest request = new DefaultDeployRequest();
            request.setBindings(bindings);
            DeployResponse response = this._transport.deploy((DeployRequest)request);
            if (response.hasExceptions()) {
                throw new RepositoryException(response.getExceptions().toString());
            }
            if (this._mdCache != null) {
                this._mdCache.updateGA(this._repo.getId(), new RepositoryGAMetadata(gaMd));
                this._mdCache.updateGAV(this._repo.getId(), new RepositoryGAVMetadata(gavMd));
                if (hasPomBlob && DefaultArtifact.class.isAssignableFrom(artifact.getClass())) {
                    this._mdCache.saveRaw((ArtifactBasicMetadata)((DefaultArtifact)artifact), pomBlob);
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

