/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.MojoExecution;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Provides;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.di.testing.MavenDIExtension;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.Mojo;
import org.apache.maven.api.plugin.descriptor.MojoDescriptor;
import org.apache.maven.api.plugin.descriptor.Parameter;
import org.apache.maven.api.plugin.descriptor.PluginDescriptor;
import org.apache.maven.api.plugin.testing.Basedir;
import org.apache.maven.api.plugin.testing.InjectMojo;
import org.apache.maven.api.plugin.testing.MojoParameter;
import org.apache.maven.api.plugin.testing.stubs.MojoExecutionStub;
import org.apache.maven.api.plugin.testing.stubs.PluginStub;
import org.apache.maven.api.plugin.testing.stubs.ProducedArtifactStub;
import org.apache.maven.api.plugin.testing.stubs.ProjectStub;
import org.apache.maven.api.plugin.testing.stubs.RepositorySystemSupplier;
import org.apache.maven.api.plugin.testing.stubs.SessionMock;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactFactory;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.LocalRepositoryManager;
import org.apache.maven.api.services.ProjectBuilder;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.model.PathTranslator;
import org.apache.maven.api.services.xml.ModelXmlFactory;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.configuration.internal.EnhancedComponentConfigurator;
import org.apache.maven.di.Injector;
import org.apache.maven.di.Key;
import org.apache.maven.di.impl.DIException;
import org.apache.maven.internal.impl.DefaultLog;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.model.DefaultModelPathTranslator;
import org.apache.maven.internal.impl.model.DefaultPathTranslator;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.internal.xml.XmlPlexusConfiguration;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.v4.MavenMerger;
import org.apache.maven.model.v4.MavenStaxReader;
import org.apache.maven.plugin.PluginParameterExpressionEvaluatorV4;
import org.apache.maven.plugin.descriptor.io.PluginDescriptorStaxReader;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.eclipse.aether.RepositorySystem;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.LoggerFactory;

public class MojoExtension
extends MavenDIExtension
implements ParameterResolver,
BeforeEachCallback {
    protected static String pluginBasedir;
    protected static String basedir;

    public static String getTestId() {
        return context.getRequiredTestClass().getSimpleName() + "-" + context.getRequiredTestMethod().getName();
    }

    public static String getBasedir() {
        return Objects.requireNonNull(basedir != null ? basedir : MavenDIExtension.basedir);
    }

    public static String getPluginBasedir() {
        return Objects.requireNonNull(pluginBasedir);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(InjectMojo.class) || parameterContext.getDeclaringExecutable().isAnnotationPresent(InjectMojo.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            String goal;
            Class<?> holder = parameterContext.getTarget().get().getClass();
            PluginDescriptor descriptor = (PluginDescriptor)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get(PluginDescriptor.class, PluginDescriptor.class);
            Model model = (Model)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get(Model.class, Model.class);
            InjectMojo parameterInjectMojo = parameterContext.getAnnotatedElement().getAnnotation(InjectMojo.class);
            if (parameterInjectMojo != null) {
                String pom = parameterInjectMojo.pom();
                if (pom != null && !pom.isEmpty()) {
                    try (Reader r = this.openPomUrl(holder, pom, new Path[1]);){
                        Model localModel = new MavenStaxReader().read(r);
                        model = new MavenMerger().merge(localModel, model, false, null);
                        model = new DefaultModelPathTranslator((PathTranslator)new DefaultPathTranslator()).alignToBaseDirectory(model, Paths.get(MojoExtension.getBasedir(), new String[0]), null);
                    }
                }
                goal = parameterInjectMojo.goal();
            } else {
                InjectMojo methodInjectMojo = AnnotationSupport.findAnnotation((AnnotatedElement)parameterContext.getDeclaringExecutable(), InjectMojo.class).orElse(null);
                goal = methodInjectMojo != null ? methodInjectMojo.goal() : MojoExtension.getGoalFromMojoImplementationClass(parameterContext.getParameter().getType());
            }
            LinkedHashSet mojoParameters = new LinkedHashSet();
            for (AnnotatedElement ae : Arrays.asList(parameterContext.getDeclaringExecutable(), parameterContext.getAnnotatedElement())) {
                mojoParameters.addAll(AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)ae, MojoParameter.class));
            }
            String[] coord = this.mojoCoordinates(goal);
            XmlNode pluginConfiguration = model.getBuild().getPlugins().stream().filter(p -> Objects.equals(p.getGroupId(), coord[0]) && Objects.equals(p.getArtifactId(), coord[1])).map(ConfigurationContainer::getConfiguration).findFirst().orElseGet(() -> new XmlNodeImpl("config"));
            List children = mojoParameters.stream().map(mp -> new XmlNodeImpl(mp.name(), mp.value())).collect(Collectors.toList());
            XmlNodeImpl config = new XmlNodeImpl("configuration", null, null, children, null);
            pluginConfiguration = XmlNode.merge((XmlNode)config, (XmlNode)pluginConfiguration);
            Mojo mojo = this.lookup(Mojo.class, coord[0] + ":" + coord[1] + ":" + coord[2] + ":" + coord[3]);
            for (MojoDescriptor mojoDescriptor : descriptor.getMojos()) {
                if (!Objects.equals(mojoDescriptor.getGoal(), coord[3]) || pluginConfiguration == null) continue;
                pluginConfiguration = this.finalizeConfig(pluginConfiguration, mojoDescriptor);
            }
            Session session = (Session)this.getInjector().getInstance(Session.class);
            Project project = (Project)this.getInjector().getInstance(Project.class);
            MojoExecution mojoExecution = (MojoExecution)this.getInjector().getInstance(MojoExecution.class);
            WrapEvaluator evaluator = new WrapEvaluator(this.getInjector(), (TypeAwareExpressionEvaluator)new PluginParameterExpressionEvaluatorV4(session, project, mojoExecution));
            EnhancedComponentConfigurator configurator = new EnhancedComponentConfigurator();
            configurator.configureComponent((Object)mojo, (PlexusConfiguration)new XmlPlexusConfiguration(pluginConfiguration), (ExpressionEvaluator)evaluator, null, null);
            return mojo;
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Unable to resolve mojo", (Throwable)e);
        }
    }

    private static String getGoalFromMojoImplementationClass(Class<?> cl) throws IOException {
        return cl.getAnnotation(Named.class).value();
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        PluginDescriptor pluginDescriptor;
        if (pluginBasedir == null) {
            pluginBasedir = MavenDIExtension.getBasedir();
        }
        if ((basedir = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)context.getElement().get()), Basedir.class).map(Basedir::value).orElse(pluginBasedir)) != null) {
            basedir = basedir.isEmpty() ? pluginBasedir + "/target/tests/" + context.getRequiredTestClass().getSimpleName() + "/" + context.getRequiredTestMethod().getName() : basedir.replace("${basedir}", pluginBasedir);
        }
        this.setContext(context);
        Path basedirPath = Paths.get(MojoExtension.getBasedir(), new String[0]);
        final InjectMojo mojo = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)context.getElement().get()), InjectMojo.class).orElse(null);
        Model defaultModel = Model.newBuilder().groupId("myGroupId").artifactId("myArtifactId").version("1.0-SNAPSHOT").packaging("jar").build(Build.newBuilder().directory(basedirPath.resolve("target").toString()).outputDirectory(basedirPath.resolve("target/classes").toString()).sourceDirectory(basedirPath.resolve("src/main/java").toString()).testSourceDirectory(basedirPath.resolve("src/test/java").toString()).testOutputDirectory(basedirPath.resolve("target/test-classes").toString()).build()).build();
        final Path[] modelPath = new Path[]{null};
        Model tmodel = null;
        if (mojo != null) {
            String pom = mojo.pom();
            if (pom != null && !pom.isEmpty()) {
                try (Reader r = this.openPomUrl(context.getRequiredTestClass(), pom, modelPath);){
                    tmodel = new MavenStaxReader().read(r);
                }
            }
            Path pomPath = basedirPath.resolve("pom.xml");
            if (Files.exists(pomPath, new LinkOption[0])) {
                try (BufferedReader r = Files.newBufferedReader(pomPath);){
                    tmodel = new MavenStaxReader().read((Reader)r);
                    modelPath[0] = pomPath;
                }
            }
        }
        final Model model = tmodel == null ? defaultModel : new MavenMerger().merge(tmodel, defaultModel, false, null);
        tmodel = new DefaultModelPathTranslator((PathTranslator)new DefaultPathTranslator()).alignToBaseDirectory(tmodel, Paths.get(MojoExtension.getBasedir(), new String[0]), null);
        context.getStore(ExtensionContext.Namespace.GLOBAL).put(Model.class, (Object)tmodel);
        ClassLoader classLoader = context.getRequiredTestClass().getClassLoader();
        try (InputStream is = Objects.requireNonNull(classLoader.getResourceAsStream(this.getPluginDescriptorLocation()), "Unable to find plugin descriptor: " + this.getPluginDescriptorLocation());
             BufferedReader reader = new BufferedReader((Reader)new XmlStreamReader(is));){
            pluginDescriptor = new PluginDescriptorStaxReader().read((Reader)reader);
        }
        context.getStore(ExtensionContext.Namespace.GLOBAL).put(PluginDescriptor.class, (Object)pluginDescriptor);
        class Foo {
            Foo() {
            }

            @Provides
            @Singleton
            @Priority(value=-10)
            private InternalSession createSession() {
                return SessionMock.getMockSession(MojoExtension.getBasedir());
            }

            @Provides
            @Singleton
            @Priority(value=-10)
            private Project createProject(InternalSession s) {
                ProjectStub stub = new ProjectStub();
                if (!"pom".equals(model.getPackaging())) {
                    ProducedArtifactStub artifact = new ProducedArtifactStub(model.getGroupId(), model.getArtifactId(), "", model.getVersion(), model.getPackaging());
                    stub.setMainArtifact(artifact);
                }
                stub.setModel(model);
                stub.setBasedir(Paths.get(MojoExtension.getBasedir(), new String[0]));
                stub.setPomPath(modelPath[0]);
                ((ArtifactManager)s.getService(ArtifactManager.class)).setPath(stub.getPomArtifact(), modelPath[0]);
                return stub;
            }

            @Provides
            @Singleton
            @Priority(value=-10)
            private MojoExecution createMojoExecution() {
                MojoExecutionStub mes = new MojoExecutionStub("executionId", null);
                if (mojo != null) {
                    String goal = mojo.goal();
                    int idx = goal.lastIndexOf(58);
                    if (idx >= 0) {
                        goal = goal.substring(idx + 1);
                    }
                    mes.setGoal(goal);
                    for (MojoDescriptor md : pluginDescriptor.getMojos()) {
                        if (!goal.equals(md.getGoal())) continue;
                        mes.setDescriptor(md);
                    }
                    Objects.requireNonNull(mes.getDescriptor());
                }
                PluginStub plugin = new PluginStub();
                plugin.setDescriptor(pluginDescriptor);
                mes.setPlugin(plugin);
                return mes;
            }

            @Provides
            @Singleton
            @Priority(value=-10)
            private Log createLog() {
                return new DefaultLog(LoggerFactory.getLogger((String)"anonymous"));
            }

            @Provides
            static RepositorySystemSupplier newRepositorySystemSupplier() {
                return new RepositorySystemSupplier();
            }

            @Provides
            static RepositorySystem newRepositorySystem(RepositorySystemSupplier repositorySystemSupplier) {
                return repositorySystemSupplier.getRepositorySystem();
            }

            @Provides
            @Priority(value=10)
            static RepositoryFactory newRepositoryFactory(Session session) {
                return (RepositoryFactory)session.getService(RepositoryFactory.class);
            }

            @Provides
            @Priority(value=10)
            static VersionParser newVersionParser(Session session) {
                return (VersionParser)session.getService(VersionParser.class);
            }

            @Provides
            @Priority(value=10)
            static LocalRepositoryManager newLocalRepositoryManager(Session session) {
                return (LocalRepositoryManager)session.getService(LocalRepositoryManager.class);
            }

            @Provides
            @Priority(value=10)
            static ArtifactInstaller newArtifactInstaller(Session session) {
                return (ArtifactInstaller)session.getService(ArtifactInstaller.class);
            }

            @Provides
            @Priority(value=10)
            static ArtifactDeployer newArtifactDeployer(Session session) {
                return (ArtifactDeployer)session.getService(ArtifactDeployer.class);
            }

            @Provides
            @Priority(value=10)
            static ArtifactManager newArtifactManager(Session session) {
                return (ArtifactManager)session.getService(ArtifactManager.class);
            }

            @Provides
            @Priority(value=10)
            static ProjectManager newProjectManager(Session session) {
                return (ProjectManager)session.getService(ProjectManager.class);
            }

            @Provides
            @Priority(value=10)
            static ArtifactFactory newArtifactFactory(Session session) {
                return (ArtifactFactory)session.getService(ArtifactFactory.class);
            }

            @Provides
            @Priority(value=10)
            static ProjectBuilder newProjectBuilder(Session session) {
                return (ProjectBuilder)session.getService(ProjectBuilder.class);
            }

            @Provides
            @Priority(value=10)
            static ModelXmlFactory newModelXmlFactory(Session session) {
                return (ModelXmlFactory)session.getService(ModelXmlFactory.class);
            }
        }
        this.getInjector().bindInstance(Foo.class, (Object)new Foo());
        this.getInjector().injectInstance(context.getRequiredTestInstance());
    }

    private Reader openPomUrl(Class<?> holder, String pom, Path[] modelPath) throws IOException {
        Path path;
        if (pom.startsWith("file:")) {
            Path path2;
            modelPath[0] = path2 = Paths.get(MojoExtension.getBasedir(), new String[0]).resolve(pom.substring("file:".length()));
            return Files.newBufferedReader(path2);
        }
        if (pom.startsWith("classpath:")) {
            URL url = holder.getResource(pom.substring("classpath:".length()));
            if (url == null) {
                throw new IllegalStateException("Unable to find pom on classpath: " + pom);
            }
            return new XmlStreamReader(url.openStream());
        }
        if (pom.contains("<project>")) {
            return new StringReader(pom);
        }
        modelPath[0] = path = Paths.get(MojoExtension.getBasedir(), new String[0]).resolve(pom);
        return Files.newBufferedReader(path);
    }

    protected String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    protected String[] mojoCoordinates(String goal) throws Exception {
        if (goal.matches(".*:.*:.*:.*")) {
            return goal.split(":");
        }
        Path pluginPom = Paths.get(MojoExtension.getPluginBasedir(), "pom.xml");
        Xpp3Dom pluginPomDom = Xpp3DomBuilder.build((Reader)Files.newBufferedReader(pluginPom));
        String artifactId = pluginPomDom.getChild("artifactId").getValue();
        String groupId = MojoExtension.resolveFromRootThenParent(pluginPomDom, "groupId");
        String version = MojoExtension.resolveFromRootThenParent(pluginPomDom, "version");
        return new String[]{groupId, artifactId, version, goal};
    }

    private XmlNode finalizeConfig(XmlNode config, MojoDescriptor mojoDescriptor) {
        ArrayList<XmlNode> children = new ArrayList<XmlNode>();
        if (mojoDescriptor != null && mojoDescriptor.getParameters() != null) {
            XmlNode defaultConfiguration = MojoDescriptorCreator.convert((MojoDescriptor)mojoDescriptor);
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                XmlNode parameterDefaults;
                XmlNode parameterConfiguration = config.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = config.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = XmlNode.merge((XmlNode)parameterConfiguration, (XmlNode)(parameterDefaults = defaultConfiguration.getChild(parameter.getName())), (Boolean)Boolean.TRUE)) == null) continue;
                HashMap attributes = new HashMap(parameterConfiguration.getAttributes());
                parameterConfiguration = new XmlNodeImpl(parameter.getName(), parameterConfiguration.getValue(), attributes, parameterConfiguration.getChildren(), parameterConfiguration.getInputLocation());
                children.add(parameterConfiguration);
            }
        }
        return new XmlNodeImpl("configuration", null, null, children, null);
    }

    private boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static Optional<Xpp3Dom> child(Xpp3Dom element, String name) {
        return Optional.ofNullable(element.getChild(name));
    }

    private static Stream<Xpp3Dom> children(Xpp3Dom element) {
        return Stream.of(element.getChildren());
    }

    public static XmlNode extractPluginConfiguration(String artifactId, Xpp3Dom pomDom) throws Exception {
        Xpp3Dom pluginConfigurationElement = MojoExtension.child(pomDom, "build").flatMap(buildElement -> MojoExtension.child(buildElement, "plugins")).map(MojoExtension::children).orElseGet(Stream::empty).filter(e -> e.getChild("artifactId").getValue().equals(artifactId)).findFirst().flatMap(buildElement -> MojoExtension.child(buildElement, "configuration")).orElse(Xpp3DomBuilder.build((Reader)new StringReader("<configuration/>")));
        return pluginConfigurationElement.getDom();
    }

    private static String resolveFromRootThenParent(Xpp3Dom pluginPomDom, String element) throws Exception {
        return Optional.ofNullable(MojoExtension.child(pluginPomDom, element).orElseGet(() -> MojoExtension.child(pluginPomDom, "parent").flatMap(e -> MojoExtension.child(e, element)).orElse(null))).map(Xpp3Dom::getValue).orElseThrow(() -> new Exception("unable to determine " + element));
    }

    public static Object getVariableValueFromObject(Object object, String variable) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        return field.get(object);
    }

    public static Map<String, Object> getVariablesAndValuesFromObject(Object object) throws IllegalAccessException {
        return MojoExtension.getVariablesAndValuesFromObject(object.getClass(), object);
    }

    public static Map<String, Object> getVariablesAndValuesFromObject(Class<?> clazz, Object object) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            map.put(((Field)field).getName(), ((Field)field).get(object));
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            map.putAll(MojoExtension.getVariablesAndValuesFromObject(superclass, object));
        }
        return map;
    }

    public static void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        Objects.requireNonNull(field, "Field " + variable + " not found");
        field.setAccessible(true);
        field.set(object, value);
    }

    static class WrapEvaluator
    implements TypeAwareExpressionEvaluator {
        private final Injector injector;
        private final TypeAwareExpressionEvaluator evaluator;

        WrapEvaluator(Injector injector, TypeAwareExpressionEvaluator evaluator) {
            this.injector = injector;
            this.evaluator = evaluator;
        }

        public Object evaluate(String expression) throws ExpressionEvaluationException {
            return this.evaluate(expression, null);
        }

        public Object evaluate(String expression, Class<?> type) throws ExpressionEvaluationException {
            String expr;
            Object value = this.evaluator.evaluate(expression, type);
            if (value == null && (expr = this.stripTokens(expression)) != null) {
                try {
                    value = this.injector.getInstance(Key.of(type, (Object)expr));
                }
                catch (DIException dIException) {
                    // empty catch block
                }
            }
            return value;
        }

        private String stripTokens(String expr) {
            if (expr.startsWith("${") && expr.endsWith("}")) {
                return expr.substring(2, expr.length() - 1);
            }
            return null;
        }

        public File alignToBaseDirectory(File path) {
            return this.evaluator.alignToBaseDirectory(path);
        }
    }
}

