/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;

public class ReleaseDescriptor
implements Serializable {
    private String name;
    private String description;
    private String ScmCommentPrefix = "[maven-release-manager] ";
    private String scmSourceUrl;
    private String scmTagBase;
    private String scmBranchBase;
    private String scmReleaseLabel;
    private String scmUsername;
    private String scmPassword;
    private String scmPrivateKey;
    private String scmPrivateKeyPassPhrase;
    private boolean scmUseEditMode = false;
    private String scmRelativePathProjectDirectory;
    private Map releaseVersions;
    private Map developmentVersions;
    private Map resolvedSnapshotDependencies;
    private boolean updateDependencies = true;
    private boolean useReleaseProfile = true;
    private Map originalScmInfo;
    private String workingDirectory;
    private String checkoutDirectory;
    private String completedPhase;
    private boolean addSchema = false;
    private boolean generateReleasePoms = false;
    private boolean autoVersionSubmodules = false;
    private boolean interactive = true;
    private boolean snapshotReleasePluginAllowed = false;
    private String additionalArguments;
    private String pomFileName;
    private String preparationGoals;
    private String performGoals;
    private boolean commitByProject = false;
    private boolean branchCreation = false;
    private boolean updateBranchVersions = false;
    private boolean updateWorkingCopyVersions = false;
    private boolean updateVersionsToSnapshot = false;
    private boolean allowTimestampedSnapshots = false;
    private String defaultReleaseVersion;
    private String defaultDevelopmentVersion;
    private boolean remoteTagging = false;
    private String scmReleasedPomRevision;
    private boolean localCheckout = false;
    private String modelEncoding = "UTF-8";
    public static final String DEVELOPMENT_KEY = "dev";
    public static final String RELEASE_KEY = "rel";
    public static final String ORIGINAL_VERSION = "original";
    private Map originalVersions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addDevelopmentVersion(Object key, String value) {
        this.getDevelopmentVersions().put(key, value);
    }

    public void addOriginalScmInfo(Object key, String value) {
        this.getOriginalScmInfo().put(key, value);
    }

    public void addReleaseVersion(Object key, String value) {
        this.getReleaseVersions().put(key, value);
    }

    public void addResolvedSnapshotDependency(Object key, String value) {
        this.getResolvedSnapshotDependencies().put(key, value);
    }

    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    public String getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public String getCompletedPhase() {
        return this.completedPhase;
    }

    public String getDefaultDevelopmentVersion() {
        return this.defaultDevelopmentVersion;
    }

    public String getDefaultReleaseVersion() {
        return this.defaultReleaseVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public Map getDevelopmentVersions() {
        if (this.developmentVersions == null) {
            this.developmentVersions = new HashMap();
        }
        return this.developmentVersions;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getName() {
        return this.name;
    }

    public Map getOriginalScmInfo() {
        if (this.originalScmInfo == null) {
            this.originalScmInfo = new HashMap();
        }
        return this.originalScmInfo;
    }

    public String getPerformGoals() {
        return this.performGoals;
    }

    public String getPomFileName() {
        return this.pomFileName;
    }

    public String getPreparationGoals() {
        return this.preparationGoals;
    }

    public Map getReleaseVersions() {
        if (this.releaseVersions == null) {
            this.releaseVersions = new HashMap();
        }
        return this.releaseVersions;
    }

    public Map getResolvedSnapshotDependencies() {
        if (this.resolvedSnapshotDependencies == null) {
            this.resolvedSnapshotDependencies = new HashMap();
        }
        return this.resolvedSnapshotDependencies;
    }

    public String getScmBranchBase() {
        return this.scmBranchBase;
    }

    public String getScmCommentPrefix() {
        return this.ScmCommentPrefix;
    }

    public String getScmPassword() {
        return this.scmPassword;
    }

    public String getScmPrivateKey() {
        return this.scmPrivateKey;
    }

    public String getScmPrivateKeyPassPhrase() {
        return this.scmPrivateKeyPassPhrase;
    }

    public String getScmRelativePathProjectDirectory() {
        return this.scmRelativePathProjectDirectory;
    }

    public String getScmReleaseLabel() {
        return this.scmReleaseLabel;
    }

    public String getScmReleasedPomRevision() {
        return this.scmReleasedPomRevision;
    }

    public String getScmSourceUrl() {
        return this.scmSourceUrl;
    }

    public String getScmTagBase() {
        return this.scmTagBase;
    }

    public String getScmUsername() {
        return this.scmUsername;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isAddSchema() {
        return this.addSchema;
    }

    public boolean isAllowTimestampedSnapshots() {
        return this.allowTimestampedSnapshots;
    }

    public boolean isAutoVersionSubmodules() {
        return this.autoVersionSubmodules;
    }

    public boolean isBranchCreation() {
        return this.branchCreation;
    }

    public boolean isCommitByProject() {
        return this.commitByProject;
    }

    public boolean isGenerateReleasePoms() {
        return this.generateReleasePoms;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isLocalCheckout() {
        return this.localCheckout;
    }

    public boolean isRemoteTagging() {
        return this.remoteTagging;
    }

    public boolean isScmUseEditMode() {
        return this.scmUseEditMode;
    }

    public boolean isSnapshotReleasePluginAllowed() {
        return this.snapshotReleasePluginAllowed;
    }

    public boolean isUpdateBranchVersions() {
        return this.updateBranchVersions;
    }

    public boolean isUpdateDependencies() {
        return this.updateDependencies;
    }

    public boolean isUpdateVersionsToSnapshot() {
        return this.updateVersionsToSnapshot;
    }

    public boolean isUpdateWorkingCopyVersions() {
        return this.updateWorkingCopyVersions;
    }

    public boolean isUseReleaseProfile() {
        return this.useReleaseProfile;
    }

    public void setAddSchema(boolean addSchema) {
        this.addSchema = addSchema;
    }

    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public void setAllowTimestampedSnapshots(boolean allowTimestampedSnapshots) {
        this.allowTimestampedSnapshots = allowTimestampedSnapshots;
    }

    public void setAutoVersionSubmodules(boolean autoVersionSubmodules) {
        this.autoVersionSubmodules = autoVersionSubmodules;
    }

    public void setBranchCreation(boolean branchCreation) {
        this.branchCreation = branchCreation;
    }

    public void setCheckoutDirectory(String checkoutDirectory) {
        this.checkoutDirectory = checkoutDirectory;
    }

    public void setCommitByProject(boolean commitByProject) {
        this.commitByProject = commitByProject;
    }

    public void setCompletedPhase(String completedPhase) {
        this.completedPhase = completedPhase;
    }

    public void setDefaultDevelopmentVersion(String defaultDevelopmentVersion) {
        this.defaultDevelopmentVersion = defaultDevelopmentVersion;
    }

    public void setDefaultReleaseVersion(String defaultReleaseVersion) {
        this.defaultReleaseVersion = defaultReleaseVersion;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDevelopmentVersions(Map developmentVersions) {
        this.developmentVersions = developmentVersions;
    }

    public void setGenerateReleasePoms(boolean generateReleasePoms) {
        this.generateReleasePoms = generateReleasePoms;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public void setLocalCheckout(boolean localCheckout) {
        this.localCheckout = localCheckout;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginalScmInfo(Map originalScmInfo) {
        this.originalScmInfo = originalScmInfo;
    }

    public void setPerformGoals(String performGoals) {
        this.performGoals = performGoals;
    }

    public void setPomFileName(String pomFileName) {
        this.pomFileName = pomFileName;
    }

    public void setPreparationGoals(String preparationGoals) {
        this.preparationGoals = preparationGoals;
    }

    public void setReleaseVersions(Map releaseVersions) {
        this.releaseVersions = releaseVersions;
    }

    public void setRemoteTagging(boolean remoteTagging) {
        this.remoteTagging = remoteTagging;
    }

    public void setResolvedSnapshotDependencies(Map resolvedSnapshotDependencies) {
        this.resolvedSnapshotDependencies = resolvedSnapshotDependencies;
    }

    public void setScmBranchBase(String scmBranchBase) {
        this.scmBranchBase = scmBranchBase;
    }

    public void setScmCommentPrefix(String ScmCommentPrefix) {
        this.ScmCommentPrefix = ScmCommentPrefix;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public void setScmPrivateKey(String scmPrivateKey) {
        this.scmPrivateKey = scmPrivateKey;
    }

    public void setScmPrivateKeyPassPhrase(String scmPrivateKeyPassPhrase) {
        this.scmPrivateKeyPassPhrase = scmPrivateKeyPassPhrase;
    }

    public void setScmRelativePathProjectDirectory(String scmRelativePathProjectDirectory) {
        this.scmRelativePathProjectDirectory = scmRelativePathProjectDirectory;
    }

    public void setScmReleaseLabel(String scmReleaseLabel) {
        this.scmReleaseLabel = scmReleaseLabel;
    }

    public void setScmReleasedPomRevision(String scmReleasedPomRevision) {
        this.scmReleasedPomRevision = scmReleasedPomRevision;
    }

    public void setScmSourceUrl(String scmSourceUrl) {
        this.scmSourceUrl = scmSourceUrl;
    }

    public void setScmTagBase(String scmTagBase) {
        this.scmTagBase = scmTagBase;
    }

    public void setScmUseEditMode(boolean scmUseEditMode) {
        this.scmUseEditMode = scmUseEditMode;
    }

    public void setScmUsername(String scmUsername) {
        this.scmUsername = scmUsername;
    }

    public void setSnapshotReleasePluginAllowed(boolean snapshotReleasePluginAllowed) {
        this.snapshotReleasePluginAllowed = snapshotReleasePluginAllowed;
    }

    public void setUpdateBranchVersions(boolean updateBranchVersions) {
        this.updateBranchVersions = updateBranchVersions;
    }

    public void setUpdateDependencies(boolean updateDependencies) {
        this.updateDependencies = updateDependencies;
    }

    public void setUpdateVersionsToSnapshot(boolean updateVersionsToSnapshot) {
        this.updateVersionsToSnapshot = updateVersionsToSnapshot;
    }

    public void setUpdateWorkingCopyVersions(boolean updateWorkingCopyVersions) {
        this.updateWorkingCopyVersions = updateWorkingCopyVersions;
    }

    public void setUseReleaseProfile(boolean useReleaseProfile) {
        this.useReleaseProfile = useReleaseProfile;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void mapResolvedSnapshotDependencies(String artifactName, String releaseVersion, String developmentVersion) {
        if (this.resolvedSnapshotDependencies == null) {
            this.resolvedSnapshotDependencies = new HashMap();
        } else if (!$assertionsDisabled && this.resolvedSnapshotDependencies.containsKey(artifactName)) {
            throw new AssertionError();
        }
        HashMap<String, String> versionsMap = new HashMap<String, String>();
        versionsMap.put(DEVELOPMENT_KEY, developmentVersion);
        versionsMap.put(RELEASE_KEY, releaseVersion);
        this.resolvedSnapshotDependencies.put(artifactName, versionsMap);
    }

    public void mapReleaseVersion(String projectId, String nextVersion) {
        if (this.releaseVersions == null) {
            this.releaseVersions = new HashMap();
        } else if (!$assertionsDisabled && this.releaseVersions.containsKey(projectId)) {
            throw new AssertionError();
        }
        this.releaseVersions.put(projectId, nextVersion);
    }

    public void mapDevelopmentVersion(String projectId, String nextVersion) {
        if (this.developmentVersions == null) {
            this.developmentVersions = new HashMap();
        } else if (!$assertionsDisabled && this.developmentVersions.containsKey(projectId)) {
            throw new AssertionError();
        }
        this.developmentVersions.put(projectId, nextVersion);
    }

    public void mapOriginalScmInfo(String projectId, Scm scm) {
        if (this.originalScmInfo == null) {
            this.originalScmInfo = new HashMap();
        } else if (!$assertionsDisabled && this.originalScmInfo.containsKey(projectId)) {
            throw new AssertionError();
        }
        this.originalScmInfo.put(projectId, scm);
    }

    public synchronized Map getOriginalVersions(List reactorProjects) {
        if (this.originalVersions == null) {
            this.originalVersions = new HashMap();
            Iterator i = reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject project = (MavenProject)i.next();
                this.originalVersions.put(ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId()), project.getVersion());
            }
        }
        return this.originalVersions;
    }

    public String getDependencyDevelopmentVersion(String artifactConflictId) {
        if (this.resolvedSnapshotDependencies == null && this.resolvedSnapshotDependencies.containsKey(artifactConflictId)) {
            Map versionMap = (Map)this.resolvedSnapshotDependencies.get(artifactConflictId);
            return (String)versionMap.get(DEVELOPMENT_KEY);
        }
        return null;
    }

    public String getDependencyReleaseVersion(String artifactConflictId) {
        if (this.resolvedSnapshotDependencies == null && this.resolvedSnapshotDependencies.containsKey(artifactConflictId)) {
            Map versionMap = (Map)this.resolvedSnapshotDependencies.get(artifactConflictId);
            return (String)versionMap.get(RELEASE_KEY);
        }
        return null;
    }

    boolean saveEquals(String a, String b) {
        return a != null ? a.equals(b) : b == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReleaseDescriptor that = (ReleaseDescriptor)obj;
        if (this.updateDependencies != that.updateDependencies || this.useReleaseProfile != that.useReleaseProfile || this.autoVersionSubmodules != that.autoVersionSubmodules || this.snapshotReleasePluginAllowed != that.snapshotReleasePluginAllowed || this.commitByProject != that.commitByProject || this.branchCreation != that.branchCreation || this.updateBranchVersions != that.updateBranchVersions || this.updateWorkingCopyVersions != that.updateWorkingCopyVersions || this.updateVersionsToSnapshot != that.updateVersionsToSnapshot || this.allowTimestampedSnapshots != that.allowTimestampedSnapshots || this.remoteTagging != that.remoteTagging || this.localCheckout != that.localCheckout) {
            return false;
        }
        if (!(this.saveEquals(this.defaultDevelopmentVersion, that.defaultDevelopmentVersion) && this.saveEquals(this.scmRelativePathProjectDirectory, that.scmRelativePathProjectDirectory) && this.saveEquals(this.checkoutDirectory, that.checkoutDirectory) && this.saveEquals(this.performGoals, that.performGoals) && this.saveEquals(this.defaultReleaseVersion, that.defaultReleaseVersion) && this.saveEquals(this.scmReleasedPomRevision, that.scmReleasedPomRevision))) {
            return false;
        }
        if (this.addSchema != that.addSchema) {
            return false;
        }
        if (this.generateReleasePoms != that.generateReleasePoms) {
            return false;
        }
        if (this.interactive != that.interactive) {
            return false;
        }
        if (this.scmUseEditMode != that.scmUseEditMode) {
            return false;
        }
        if (!this.saveEquals(this.completedPhase, that.completedPhase)) {
            return false;
        }
        if ((this.developmentVersions != null && (this.developmentVersions == null || this.developmentVersions.size() != 0) || that.developmentVersions != null && (that.developmentVersions == null || that.developmentVersions.size() != 0)) && (this.developmentVersions != null ? !((Object)this.developmentVersions).equals(that.developmentVersions) : that.developmentVersions != null)) {
            return false;
        }
        if ((this.originalScmInfo != null && (this.originalScmInfo == null || this.originalScmInfo.size() != 0) || that.originalScmInfo != null && (that.originalScmInfo == null || that.originalScmInfo.size() != 0)) && (this.originalScmInfo != null ? !this.compareScmCollections(that.originalScmInfo) : that.originalScmInfo != null)) {
            return false;
        }
        if ((this.releaseVersions != null && (this.releaseVersions == null || this.releaseVersions.size() != 0) || that.releaseVersions != null && (that.releaseVersions == null || that.releaseVersions.size() != 0)) && (this.releaseVersions != null ? !((Object)this.releaseVersions).equals(that.releaseVersions) : that.releaseVersions != null)) {
            return false;
        }
        if (!this.saveEquals(this.additionalArguments, that.additionalArguments)) {
            return false;
        }
        if (!this.saveEquals(this.preparationGoals, that.preparationGoals)) {
            return false;
        }
        if (!this.saveEquals(this.pomFileName, that.pomFileName)) {
            return false;
        }
        if (!this.saveEquals(this.scmPrivateKeyPassPhrase, that.scmPrivateKeyPassPhrase)) {
            return false;
        }
        if (!this.saveEquals(this.scmPassword, that.scmPassword)) {
            return false;
        }
        if (!this.saveEquals(this.scmPrivateKey, that.scmPrivateKey)) {
            return false;
        }
        if (!this.saveEquals(this.scmReleaseLabel, that.scmReleaseLabel)) {
            return false;
        }
        if (!this.saveEquals(this.scmTagBase, that.scmTagBase)) {
            return false;
        }
        if (!this.saveEquals(this.scmBranchBase, that.scmBranchBase)) {
            return false;
        }
        if (!this.saveEquals(this.scmSourceUrl, that.scmSourceUrl)) {
            return false;
        }
        if (!this.saveEquals(this.scmUsername, that.scmUsername)) {
            return false;
        }
        return this.saveEquals(this.workingDirectory, that.workingDirectory);
    }

    private boolean compareScmCollections(Map that) {
        if (that == null && this.originalScmInfo == null) {
            return true;
        }
        if (that == null && this.originalScmInfo != null || that != null && this.originalScmInfo == null) {
            return false;
        }
        if (that.size() != this.originalScmInfo.size()) {
            return false;
        }
        Iterator i = this.originalScmInfo.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Scm thatScm = (Scm)that.get(entry.getKey());
            Scm thisScm = (Scm)entry.getValue();
            if (thatScm == null && thisScm == null) {
                return true;
            }
            if (thatScm == null) {
                return false;
            }
            if (thisScm == null) {
                return true;
            }
            if (thisScm.getConnection() != null ? !thisScm.getConnection().equals(thatScm.getConnection()) : thatScm.getConnection() != null) {
                return false;
            }
            if (thisScm.getDeveloperConnection() != null ? !thisScm.getDeveloperConnection().equals(thatScm.getDeveloperConnection()) : thatScm.getDeveloperConnection() != null) {
                return false;
            }
            if (thisScm.getUrl() != null ? !thisScm.getUrl().equals(thatScm.getUrl()) : thatScm.getUrl() != null) {
                return false;
            }
            if (!(thisScm.getTag() != null ? !thisScm.getTag().equals(thatScm.getTag()) : thatScm.getTag() != null)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.completedPhase != null ? this.completedPhase.hashCode() : 0;
        result = 29 * result + (this.scmReleaseLabel != null ? this.scmReleaseLabel.hashCode() : 0);
        result = 29 * result + (this.additionalArguments != null ? this.additionalArguments.hashCode() : 0);
        result = 29 * result + (this.preparationGoals != null ? this.preparationGoals.hashCode() : 0);
        result = 29 * result + (this.pomFileName != null ? this.pomFileName.hashCode() : 0);
        result = 29 * result + (this.scmTagBase != null ? this.scmTagBase.hashCode() : 0);
        result = 29 * result + (this.scmBranchBase != null ? this.scmBranchBase.hashCode() : 0);
        result = 29 * result + (this.scmUsername != null ? this.scmUsername.hashCode() : 0);
        result = 29 * result + (this.scmPassword != null ? this.scmPassword.hashCode() : 0);
        result = 29 * result + (this.scmSourceUrl != null ? this.scmSourceUrl.hashCode() : 0);
        result = 29 * result + (this.scmPrivateKey != null ? this.scmPrivateKey.hashCode() : 0);
        result = 29 * result + (this.scmPrivateKeyPassPhrase != null ? this.scmPrivateKeyPassPhrase.hashCode() : 0);
        result = 29 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
        result = 29 * result + (this.scmUseEditMode ? 1 : 0);
        result = 29 * result + (this.addSchema ? 1 : 0);
        result = 29 * result + (this.generateReleasePoms ? 1 : 0);
        result = 29 * result + (this.interactive ? 1 : 0);
        result = 29 * result + (this.releaseVersions != null ? ((Object)this.releaseVersions).hashCode() : 0);
        result = 29 * result + (this.developmentVersions != null ? ((Object)this.developmentVersions).hashCode() : 0);
        result = 29 * result + (this.originalScmInfo != null ? ((Object)this.originalScmInfo).hashCode() : 0);
        result = 29 * result + (this.updateDependencies ? 1 : 0);
        result = 29 * result + (this.useReleaseProfile ? 1 : 0);
        result = 29 * result + (this.autoVersionSubmodules ? 1 : 0);
        result = 29 * result + (this.snapshotReleasePluginAllowed ? 1 : 0);
        result = 29 * result + (this.commitByProject ? 1 : 0);
        result = 29 * result + (this.branchCreation ? 1 : 0);
        result = 29 * result + (this.updateBranchVersions ? 1 : 0);
        result = 29 * result + (this.updateWorkingCopyVersions ? 1 : 0);
        result = 29 * result + (this.updateVersionsToSnapshot ? 1 : 0);
        result = 29 * result + (this.allowTimestampedSnapshots ? 1 : 0);
        result = 29 * result + (this.remoteTagging ? 1 : 0);
        result = 29 * result + (this.localCheckout ? 1 : 0);
        result = 29 * result + (this.defaultDevelopmentVersion != null ? this.defaultDevelopmentVersion.hashCode() : 0);
        result = 29 * result + (this.scmRelativePathProjectDirectory != null ? this.scmRelativePathProjectDirectory.hashCode() : 0);
        result = 29 * result + (this.checkoutDirectory != null ? this.checkoutDirectory.hashCode() : 0);
        result = 29 * result + (this.performGoals != null ? this.performGoals.hashCode() : 0);
        result = 29 * result + (this.defaultReleaseVersion != null ? this.defaultReleaseVersion.hashCode() : 0);
        result = 29 * result + (this.scmReleasedPomRevision != null ? this.scmReleasedPomRevision.hashCode() : 0);
        return result;
    }

    static {
        $assertionsDisabled = !ReleaseDescriptor.class.desiredAssertionStatus();
    }
}

