/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputVariablesPhase
extends AbstractReleasePhase {
    private Prompter prompter;
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    protected ScmProvider getScmProvider(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment) throws ReleaseScmRepositoryException, ReleaseExecutionException {
        try {
            ScmRepository repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            return this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage() + " for URL: " + releaseDescriptor.getScmSourceUrl(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
    }

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        MavenProject project = ReleaseUtil.getRootProject(reactorProjects);
        String tag = releaseDescriptor.getScmReleaseLabel();
        if (tag == null) {
            String defaultTag;
            String key = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            String releaseVersion = (String)releaseDescriptor.getReleaseVersions().get(key);
            if (releaseVersion == null) {
                throw new ReleaseExecutionException("Project tag cannot be selected if version is not yet mapped");
            }
            String scmTagNameFormat = releaseDescriptor.getScmTagNameFormat();
            if (scmTagNameFormat != null) {
                StringSearchInterpolator interpolator = new StringSearchInterpolator("@{", "}");
                List<String> possiblePrefixes = Arrays.asList("project", "pom");
                Properties values = new Properties();
                values.setProperty("artifactId", project.getArtifactId());
                values.setProperty("groupId", project.getGroupId());
                values.setProperty("version", releaseVersion);
                interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource(possiblePrefixes, values, true));
                PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(possiblePrefixes);
                try {
                    defaultTag = interpolator.interpolate(scmTagNameFormat, (RecursionInterceptor)recursionInterceptor);
                }
                catch (InterpolationException e) {
                    throw new ReleaseExecutionException("Could not interpolate specified tag name format: " + scmTagNameFormat, e);
                }
            } else {
                defaultTag = project.getArtifactId() + "-" + releaseVersion;
            }
            ScmProvider provider = null;
            try {
                provider = this.getScmProvider(releaseDescriptor, releaseEnvironment);
            }
            catch (ReleaseScmRepositoryException e) {
                throw new ReleaseExecutionException("No scm provider can be found for url: " + releaseDescriptor.getScmSourceUrl(), e);
            }
            defaultTag = provider.sanitizeTagName(defaultTag);
            if (releaseDescriptor.isInteractive()) {
                try {
                    tag = this.prompter.prompt("What is SCM release tag or label for \"" + project.getName() + "\"? (" + project.getGroupId() + ":" + project.getArtifactId() + ")", defaultTag);
                }
                catch (PrompterException e) {
                    throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), e);
                }
            } else {
                tag = defaultTag;
            }
            releaseDescriptor.setScmReleaseLabel(tag);
        }
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
        result.setResultCode(0);
        return result;
    }
}

