/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ReleasePhase.class, hint="rewrite-poms-for-development")
public class RewritePomsForDevelopmentPhase
extends AbstractRewritePomsPhase {
    @Override
    protected final String getPomSuffix() {
        return "next";
    }

    @Override
    protected void transformScm(MavenProject project, Model modelTarget, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result) throws ReleaseExecutionException {
        Scm scmRoot;
        if (project.getScm() != null && (scmRoot = modelTarget.getScm()) != null) {
            ScmTranslator translator = this.getScmTranslators().get(scmRepository.getProvider());
            if (translator != null) {
                Scm scm = releaseDescriptor.getOriginalScmInfo(projectId);
                if (scm != null) {
                    scmRoot.setConnection(scm.getConnection());
                    scmRoot.setDeveloperConnection(scm.getDeveloperConnection());
                    scmRoot.setUrl(scm.getUrl());
                    scmRoot.setTag(translator.resolveTag(scm.getTag()));
                } else {
                    modelTarget.setScm(null);
                }
            } else {
                String message = "No SCM translator found - skipping rewrite";
                result.appendDebug(message);
                this.getLogger().debug(message);
            }
        }
    }

    @Override
    protected String getOriginalVersion(ReleaseDescriptor releaseDescriptor, String projectKey, boolean simulate) {
        return simulate ? releaseDescriptor.getProjectOriginalVersion(projectKey) : releaseDescriptor.getProjectReleaseVersion(projectKey);
    }

    @Override
    protected String getNextVersion(ReleaseDescriptor releaseDescriptor, String key) {
        return releaseDescriptor.getProjectDevelopmentVersion(key);
    }

    @Override
    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getDependencyDevelopmentVersion(artifactVersionlessKey);
    }
}

