/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.commands.checkout;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevScmProvider;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.apache.maven.scm.provider.accurev.commands.checkout.BaseAccuRevCheckOutCommand;
import org.apache.maven.scm.util.AbstractConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class AccuRevCheckOutWorkspaceCommand
extends AbstractCheckOutCommand
implements BaseAccuRevCheckOutCommand {
    private String accuRevExecutable;

    public AccuRevCheckOutWorkspaceCommand(String executable) {
        this.accuRevExecutable = executable;
    }

    public String getMethodName() {
        return "mkws";
    }

    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        try {
            AccuRevScmProviderRepository accurevRepository;
            Commandline makeCommandline;
            int exitCode;
            final CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            if (!fileSet.getBasedir().exists()) {
                fileSet.getBasedir().mkdirs();
            }
            if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)(makeCommandline = this.createMakeWorkspaceCommandLine(accurevRepository = (AccuRevScmProviderRepository)repository, fileSet, version)), (StreamConsumer)stdout, (StreamConsumer)stdout)) != 0) {
                return new CheckOutScmResult(makeCommandline.toString(), "The AccuRev command failed. Cannot create workspace: " + stdout.getOutput(), stdout.getOutput(), false);
            }
            Commandline updateCommandline = this.createUpdateWorkspaceCommand(accurevRepository, fileSet, version);
            final ArrayList checkedFiles = new ArrayList();
            exitCode = CommandLineUtils.executeCommandLine((Commandline)updateCommandline, (StreamConsumer)new AbstractConsumer(this.getLogger()){
                private Pattern pattern;
                {
                    super(x0);
                    this.pattern = Pattern.compile("Updating element (.*)");
                }

                public void consumeLine(String line) {
                    stdout.consumeLine(line);
                    Matcher m = this.pattern.matcher(line);
                    if (m.matches()) {
                        checkedFiles.add(m.group(1));
                    }
                }
            }, (StreamConsumer)stdout);
            if (exitCode != 0) {
                return new CheckOutScmResult(updateCommandline.toString(), "The AccuRev command failed. Cannot update workspace", stdout.getOutput(), false);
            }
            return new CheckOutScmResult(makeCommandline.toString() + " & " + updateCommandline.toString(), checkedFiles);
        }
        catch (CommandLineException e) {
            throw new ScmException("internal error");
        }
    }

    protected Commandline createUpdateWorkspaceCommand(AccuRevScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.accuRevExecutable);
        ArrayList<String> params = new ArrayList<String>();
        params.add("update");
        AccuRevScmProvider.appendHostToParamsIfNeeded(repository, params);
        params.add("-r");
        params.add(repository.getWorkspaceName());
        commandline.addArguments(params.toArray(new String[params.size()]));
        return commandline;
    }

    protected Commandline createMakeWorkspaceCommandLine(AccuRevScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) {
        Commandline cmd = new Commandline();
        cmd.setExecutable(this.accuRevExecutable);
        cmd.addArguments(new String[]{"mkws"});
        ArrayList params = new ArrayList();
        AccuRevScmProvider.appendHostToParamsIfNeeded(repository, params);
        cmd.addArguments(params.toArray(new String[params.size()]));
        cmd.addArguments(new String[]{"-w", repository.getWorkspaceName(), "-b", repository.getStreamName(), "-l", fileSet.getBasedir().getAbsolutePath()});
        return cmd;
    }
}

