/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.tag;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.bazaar.BazaarUtils;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;
import org.apache.maven.scm.provider.bazaar.command.tag.BazaarLsConsumer;
import org.apache.maven.scm.provider.bazaar.repository.BazaarScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class BazaarTagCommand
extends AbstractTagCommand {
    protected ScmResult executeTagCommand(ScmProviderRepository repository, ScmFileSet fileSet, String tagName, ScmTagParameters scmTagParameters) throws ScmException {
        if (tagName == null || StringUtils.isEmpty((String)tagName.trim())) {
            throw new ScmException("tag name must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("tagging specific files is not allowed");
        }
        File bazaarRoot = fileSet.getBasedir();
        BazaarConsumer consumer = new BazaarConsumer(this.getLogger());
        String[] tagCmd = new String[]{"tag", tagName};
        ScmResult tagResult = BazaarUtils.execute(consumer, this.getLogger(), bazaarRoot, tagCmd);
        if (!tagResult.isSuccess()) {
            return new TagScmResult(null, tagResult);
        }
        BazaarLsConsumer lsConsumer = new BazaarLsConsumer(this.getLogger(), bazaarRoot, ScmFileStatus.TAGGED);
        String[] lsCmd = new String[]{"ls", "--recursive", "--revision", "tag:" + tagName};
        ScmResult lsResult = BazaarUtils.execute(lsConsumer, this.getLogger(), bazaarRoot, lsCmd);
        if (!lsResult.isSuccess()) {
            return new TagScmResult(null, lsResult);
        }
        BazaarScmProviderRepository bazaarRepository = (BazaarScmProviderRepository)repository;
        if (!bazaarRepository.getURI().equals(fileSet.getBasedir().getAbsolutePath())) {
            String[] pushCmd = new String[]{"push", bazaarRepository.getURI()};
            ScmResult pushResult = BazaarUtils.execute(new BazaarConsumer(this.getLogger()), this.getLogger(), fileSet.getBasedir(), pushCmd);
            if (!pushResult.isSuccess()) {
                return new TagScmResult(null, pushResult);
            }
        }
        return new TagScmResult(lsConsumer.getListedFiles(), tagResult);
    }
}

