/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.changelog;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCvsChangeLogCommand
extends AbstractChangeLogCommand
implements CvsCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, String startTag, String endTag, String datePattern) throws ScmException {
        return this.executeChangeLogCommand(repo, fileSet, null, null, null, startTag, endTag, datePattern);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, String branch, String datePattern) throws ScmException {
        return this.executeChangeLogCommand(repo, fileSet, startDate, endDate, branch, null, null, datePattern);
    }

    private ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, String branch, String startTag, String endTag, String datePattern) throws ScmException {
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = CvsCommandUtils.getBaseCommand("log", repository, fileSet);
        if (startDate != null) {
            SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            String dateRange = endDate == null ? ">" + outputDate.format(startDate) : outputDate.format(startDate) + "<" + outputDate.format(endDate);
            cl.createArgument().setValue("-d");
            cl.createArgument().setValue("\"" + dateRange + "\"");
        }
        if (branch != null) {
            cl.createArgument().setValue("-r" + branch);
        }
        if (startTag != null) {
            String param = "-r" + startTag + "::" + (endTag != null ? endTag : "");
            cl.createArgument().setValue(param);
        }
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        return this.executeCvsCommand(cl, startDate, endDate, datePattern);
    }

    protected abstract ChangeLogScmResult executeCvsCommand(Commandline var1, Date var2, Date var3, String var4) throws ScmException;
}

