/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.login;

import java.io.IOException;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.login.AbstractLoginCommand;
import org.apache.maven.scm.command.login.LoginScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.command.login.CvsPass;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;

public class CvsLoginCommand
extends AbstractLoginCommand {
    public LoginScmResult executeLoginCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CvsScmProviderRepository repo = (CvsScmProviderRepository)repository;
        if (!"pserver".equals(repo.getTransport())) {
            return new LoginScmResult(null, "The cvs login ignored for " + repo.getTransport() + ".", "", true);
        }
        if (CvsCommandUtils.isCvsNT()) {
            return new LoginScmResult(null, "The cvs login ignored for CVSNT.", "", true);
        }
        CvsPass passGenerator = new CvsPass(this.getLogger());
        passGenerator.setCvsroot(repo.getCvsRootForCvsPass());
        passGenerator.setPassword(repo.getPassword());
        try {
            passGenerator.execute();
        }
        catch (IOException e) {
            throw new ScmException("Error while executing cvs login command.", (Throwable)e);
        }
        return new LoginScmResult(null, "The cvs command succeed.", "", true);
    }
}

