/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.list;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCvsListCommand
extends AbstractListCommand
implements CvsCommand {
    private static Boolean rlsSUPPORTSD = Os.isFamily((String)"windows") ? null : Boolean.TRUE;

    protected ListScmResult executeListCommand(ScmProviderRepository repo, ScmFileSet fileSet, boolean recursive, ScmVersion version) throws ScmException {
        Boolean supD = rlsSUPPORTSD;
        while (true) {
            ListScmResult res;
            if ((res = this.executeListCommand1(repo, fileSet, recursive, version, supD)).isSuccess() || supD != null) {
                if (rlsSUPPORTSD == null && res.isSuccess()) {
                    rlsSUPPORTSD = supD == null ? Boolean.TRUE : supD;
                }
                return res;
            }
            supD = Boolean.FALSE;
        }
    }

    private ListScmResult executeListCommand1(ScmProviderRepository repo, ScmFileSet fileSet, boolean recursive, ScmVersion version, Boolean supD) throws ScmException {
        String modulePref;
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = CvsCommandUtils.getBaseCommand("rls", repository, fileSet, "-n");
        if (version != null && !StringUtils.isEmpty((String)version.getName())) {
            cl.createArg().setValue("-r");
            cl.createArg().setValue(version.getName());
        }
        if (supD != Boolean.FALSE) {
            cl.createArg().setValue("-d");
        }
        cl.createArg().setValue("-e");
        if (recursive) {
            cl.createArg().setValue("-R");
        }
        modulePref = !StringUtils.isEmpty((String)(modulePref = repository.getModule())) ? modulePref + File.separatorChar : "";
        for (File target : fileSet.getFileList()) {
            String path = target.getPath();
            if (path.startsWith("\\")) {
                path = path.substring(1);
            }
            path = modulePref + path;
            cl.createArg().setValue(path);
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Executing: " + cl);
            this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        return this.executeCvsCommand(cl);
    }

    protected abstract ListScmResult executeCvsCommand(Commandline var1) throws ScmException;
}

