/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.info;

import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.util.AbstractConsumer;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.Commandline;

public class GitInfoConsumer
extends AbstractConsumer {
    private final InfoItem infoItem = new InfoItem();
    private final int revisionLength;

    public GitInfoConsumer(Path path, int revisionLength) {
        this.infoItem.setPath(path.toString());
        this.infoItem.setURL(path.toUri().toASCIIString());
        this.revisionLength = revisionLength;
    }

    public void consumeLine(String line) {
        String[] parts;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("consume line {}", (Object)line);
        }
        if ((parts = line.split("\\s", 4)).length != 4) {
            throw new IllegalArgumentException("Unexpected line: expecting 4 tokens separated by whitespace but got " + line);
        }
        this.infoItem.setLastChangedAuthor(parts[LineParts.AUTHOR_NAME.getIndex()] + " <" + parts[LineParts.AUTHOR_EMAIL.getIndex()] + ">");
        String revision = parts[LineParts.HASH.getIndex()];
        if (this.revisionLength > -1) {
            revision = StringUtils.truncate((String)revision, (int)Integer.max(4, this.revisionLength));
        }
        this.infoItem.setRevision(revision);
        this.infoItem.setLastChangedDateTime(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(parts[LineParts.AUTHOR_LAST_MODIFIED.getIndex()]));
    }

    public InfoItem getInfoItem() {
        return this.infoItem;
    }

    public static Arg getFormatArgument() {
        Commandline.Argument arg = new Commandline.Argument();
        arg.setValue("--format=format:%H %aI %aE %aN");
        return arg;
    }

    static enum LineParts {
        HASH(0),
        AUTHOR_NAME(3),
        AUTHOR_EMAIL(2),
        AUTHOR_LAST_MODIFIED(1);

        private final int index;

        private LineParts(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

