/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.HgConfig;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class HgUtils {
    private static final Map EXIT_CODE_MAP = new HashMap();
    private static final List DEFAULT_EXIT_CODES = new ArrayList();

    public static ScmResult execute(HgConsumer consumer, ScmLogger logger, File workingDir, String[] cmdAndArgs) throws ScmException {
        try {
            Commandline cmd = HgUtils.buildCmd(workingDir, cmdAndArgs);
            if (logger.isInfoEnabled()) {
                logger.info("EXECUTING: " + cmd);
            }
            int exitCode = HgUtils.executeCmd(consumer, cmd);
            List exitCodes = DEFAULT_EXIT_CODES;
            if (EXIT_CODE_MAP.containsKey(cmdAndArgs[0])) {
                exitCodes = (List)EXIT_CODE_MAP.get(cmdAndArgs[0]);
            }
            boolean success = exitCodes.contains(new Integer(exitCode));
            String providerMsg = "Execution of hg command succeded";
            if (!success) {
                HgConfig config = new HgConfig(workingDir);
                providerMsg = "\nEXECUTION FAILED\n  Execution of cmd : " + cmdAndArgs[0] + " failed with exit code: " + exitCode + "." + "\n  Working directory was: " + "\n    " + workingDir.getAbsolutePath() + config.toString(workingDir) + "\n";
                if (logger.isErrorEnabled()) {
                    logger.error(providerMsg);
                }
            }
            return new ScmResult(cmd.toString(), providerMsg, consumer.getStdErr(), success);
        }
        catch (ScmException se) {
            String msg = "EXECUTION FAILED\n  Execution failed before invoking the Hg command. Last exception:\n    " + se.getMessage();
            if (se.getCause() != null) {
                msg = msg + "\n  Nested exception:\n    " + se.getCause().getMessage();
            }
            if (logger.isErrorEnabled()) {
                logger.error(msg);
            }
            throw se;
        }
    }

    static Commandline buildCmd(File workingDir, String[] cmdAndArgs) throws ScmException {
        boolean success;
        Commandline cmd = new Commandline();
        cmd.setExecutable("hg");
        cmd.setWorkingDirectory(workingDir.getAbsolutePath());
        cmd.addArguments(cmdAndArgs);
        if (!workingDir.exists() && !(success = workingDir.mkdirs())) {
            String msg = "Working directory did not exist and it couldn't be created: " + workingDir;
            throw new ScmException(msg);
        }
        return cmd;
    }

    static int executeCmd(HgConsumer consumer, Commandline cmd) throws ScmException {
        int exitCode;
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)consumer, (StreamConsumer)consumer);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Command could not be executed: " + cmd, (Throwable)ex);
        }
        return exitCode;
    }

    public static ScmResult execute(File workingDir, String[] cmdAndArgs) throws ScmException {
        DefaultLog logger = new DefaultLog();
        return HgUtils.execute(new HgConsumer((ScmLogger)logger), (ScmLogger)logger, workingDir, cmdAndArgs);
    }

    public static String[] expandCommandLine(String[] cmdAndArgs, ScmFileSet additionalFiles) {
        List filesList = additionalFiles.getFileList();
        String[] cmd = new String[filesList.size() + cmdAndArgs.length];
        System.arraycopy(cmdAndArgs, 0, cmd, 0, cmdAndArgs.length);
        int i = 0;
        Iterator iterator = filesList.iterator();
        while (iterator.hasNext()) {
            String file;
            File scmFile = (File)iterator.next();
            cmd[i + cmdAndArgs.length] = file = scmFile.getPath().replace('\\', File.separatorChar);
            ++i;
        }
        return cmd;
    }

    public static int getCurrentRevisionNumber(ScmLogger logger, File workingDir) throws ScmException {
        String[] revCmd = new String[]{"id"};
        HgRevNoConsumer consumer = new HgRevNoConsumer(logger);
        HgUtils.execute(consumer, logger, workingDir, revCmd);
        return consumer.getCurrentRevisionNumber();
    }

    static {
        DEFAULT_EXIT_CODES.add(new Integer(0));
        ArrayList<Integer> diffExitCodes = new ArrayList<Integer>();
        diffExitCodes.add(new Integer(0));
        diffExitCodes.add(new Integer(1));
        diffExitCodes.add(new Integer(2));
        EXIT_CODE_MAP.put("diff", diffExitCodes);
    }

    private static class HgRevNoConsumer
    extends HgConsumer {
        private int revNo;

        HgRevNoConsumer(ScmLogger logger) {
            super(logger);
        }

        public void doConsume(ScmFileStatus status, String line) {
            try {
                this.revNo = Integer.valueOf(line);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        int getCurrentRevisionNumber() {
            return this.revNo;
        }
    }
}

