/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.info;

import java.io.File;
import java.io.IOException;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class JGitInfoCommand
extends AbstractCommand
implements GitCommand {
    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        File basedir = fileSet.getBasedir();
        Git git = null;
        try {
            git = JGitUtils.openRepo(basedir);
            ObjectId objectId = git.getRepository().resolve("HEAD");
            if (objectId == null) {
                throw new ScmException("Cannot resolve HEAD in git repository at " + basedir);
            }
            LinkedList<InfoItem> infoItems = new LinkedList<InfoItem>();
            if (fileSet.getFileList().isEmpty()) {
                RevCommit headCommit = git.getRepository().parseCommit((AnyObjectId)objectId);
                infoItems.add(this.getInfoItem(headCommit, fileSet.getBasedir()));
            } else {
                for (File file : JGitUtils.getWorkingCopyRelativePaths(git.getRepository().getWorkTree(), fileSet)) {
                    infoItems.add(this.getInfoItem(git.getRepository(), objectId, file));
                }
            }
            InfoScmResult infoScmResult = new InfoScmResult(infoItems, new ScmResult("JGit.resolve(HEAD)", "", objectId.toString(), true));
            return infoScmResult;
        }
        catch (Exception e) {
            throw new ScmException("JGit resolve failure!", (Throwable)e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }

    protected InfoItem getInfoItem(Repository repository, ObjectId headObjectId, File file) throws IOException {
        RevCommit commit = this.getMostRecentCommitForPath(repository, headObjectId, JGitUtils.toNormalizedFilePath(file));
        return this.getInfoItem(commit, file);
    }

    protected InfoItem getInfoItem(RevCommit fileCommit, File file) {
        InfoItem infoItem = new InfoItem();
        infoItem.setPath(file.getPath());
        infoItem.setRevision(StringUtils.trim((String)fileCommit.name()));
        infoItem.setURL(file.toPath().toUri().toASCIIString());
        PersonIdent authorIdent = fileCommit.getAuthorIdent();
        infoItem.setLastChangedDateTime((TemporalAccessor)authorIdent.getWhen().toInstant().atZone(authorIdent.getTimeZone().toZoneId()));
        infoItem.setLastChangedAuthor(authorIdent.getName() + " <" + authorIdent.getEmailAddress() + ">");
        return infoItem;
    }

    private RevCommit getMostRecentCommitForPath(Repository repository, ObjectId headObjectId, String path) throws IOException {
        RevCommit latestCommit = null;
        try (RevWalk revWalk = new RevWalk(repository);){
            RevCommit headCommit = revWalk.parseCommit((AnyObjectId)headObjectId);
            revWalk.markStart(headCommit);
            revWalk.sort(RevSort.COMMIT_TIME_DESC);
            revWalk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)TreeFilter.ANY_DIFF));
            latestCommit = revWalk.next();
        }
        return latestCommit;
    }
}

