/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.SvnChangeSet;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class SvnChangeLogConsumer
extends AbstractConsumer {
    private static final String SVN_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss zzzzzzzzz";
    private static final int GET_HEADER = 1;
    private static final int GET_FILE = 2;
    private static final int GET_COMMENT = 3;
    private static final String FILE_BEGIN_TOKEN = " ";
    private static final String FILE_END_TOKEN = "";
    private static final int FILE_START_INDEX = 5;
    private static final String COMMENT_END_TOKEN = "------------------------------------------------------------------------";
    private static final String PATTERN = "^rev (\\d+):\\s+(\\w+)\\s+\\|\\s+(\\d+-\\d+-\\d+ \\d+:\\d+:\\d+) ([\\-+])(\\d\\d)(\\d\\d)";
    private static final String PATTERN2 = "^r(\\d+)\\s+\\|\\s+(\\(\\S+\\s+\\S+\\)|\\S+)\\s+\\|\\s+(\\d+-\\d+-\\d+ \\d+:\\d+:\\d+) ([\\-+])(\\d\\d)(\\d\\d)";
    private int status = 1;
    private List entries = new ArrayList();
    private SvnChangeSet currentChange;
    private String currentRevision;
    private StringBuffer currentComment;
    private RE headerRegexp;
    private RE headerRegexp2;
    private String userDateFormat;

    public SvnChangeLogConsumer(ScmLogger logger, String userDateFormat) {
        super(logger);
        this.userDateFormat = userDateFormat;
        try {
            this.headerRegexp = new RE(PATTERN);
            this.headerRegexp2 = new RE(PATTERN2);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse svn log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public List getModifications() {
        return this.entries;
    }

    public void consumeLine(String line) {
        this.getLogger().debug(line);
        switch (this.status) {
            case 1: {
                this.processGetHeader(line);
                break;
            }
            case 2: {
                this.processGetFile(line);
                break;
            }
            case 3: {
                this.processGetComment(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.status);
            }
        }
    }

    private void processGetHeader(String line) {
        if (!this.headerRegexp.match(line)) {
            if (!this.headerRegexp2.match(line)) {
                return;
            }
            this.headerRegexp = this.headerRegexp2;
        }
        this.currentRevision = this.headerRegexp.getParen(1);
        this.currentChange = new SvnChangeSet();
        this.currentChange.setAuthor(this.headerRegexp.getParen(2));
        this.currentChange.setDate(this.parseDate());
        this.status = 2;
    }

    private void processGetFile(String line) {
        if (line.startsWith(FILE_BEGIN_TOKEN)) {
            String name = line.substring(5);
            this.currentChange.addFile(new ChangeFile(name, this.currentRevision));
            this.status = 2;
        } else if (line.equals(FILE_END_TOKEN)) {
            this.currentComment = new StringBuffer();
            this.status = 3;
        }
    }

    private void processGetComment(String line) {
        if (line.equals(COMMENT_END_TOKEN)) {
            this.currentChange.setComment(this.currentComment.toString());
            this.entries.add(this.currentChange);
            this.status = 1;
        } else {
            this.currentComment.append(line).append('\n');
        }
    }

    private Date parseDate() {
        StringBuffer date = new StringBuffer().append(this.headerRegexp.getParen(3)).append(" GMT").append(this.headerRegexp.getParen(4)).append(this.headerRegexp.getParen(5)).append(':').append(this.headerRegexp.getParen(6));
        return this.parseDate(date.toString(), this.userDateFormat, SVN_TIMESTAMP_PATTERN);
    }
}

