/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.info;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.command.info.InfoItem;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnInfoConsumer
implements StreamConsumer {
    private List<InfoItem> infoItems = new ArrayList<InfoItem>();
    private InfoItem currentItem = new InfoItem();

    public void consumeLine(String s) {
        if (s.equals("")) {
            if (this.currentItem != null) {
                this.infoItems.add(this.currentItem);
            }
            this.currentItem = new InfoItem();
        } else if (s.startsWith("Path: ")) {
            this.currentItem.setPath(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("URL: ")) {
            this.currentItem.setURL(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("Repository Root: ")) {
            this.currentItem.setRepositoryRoot(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("Repository UUID: ")) {
            this.currentItem.setRepositoryUUID(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("Revision: ")) {
            this.currentItem.setRevision(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("Node Kind: ")) {
            this.currentItem.setNodeKind(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("Schedule: ")) {
            this.currentItem.setSchedule(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("Last Changed Author: ")) {
            this.currentItem.setLastChangedAuthor(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("Last Changed Rev: ")) {
            this.currentItem.setLastChangedRevision(SvnInfoConsumer.getValue(s));
        } else if (s.startsWith("Last Changed Date: ")) {
            this.currentItem.setLastChangedDate(SvnInfoConsumer.getValue(s));
        }
    }

    private static String getValue(String s) {
        int idx = s.indexOf(": ");
        if (idx < 0) {
            return null;
        }
        return s.substring(idx + 2);
    }

    public List<InfoItem> getInfoItems() {
        return this.infoItems;
    }
}

