/*
 * $Id$
 */

package org.apache.maven.scm.providers.vss.settings.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.scm.providers.vss.settings.Settings;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class VssXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class VssXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param settings
     * @throws java.io.IOException
     */
    public void write(Writer writer, Settings settings)
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( settings.getModelEncoding(), null );
        writeSettings( settings, "vss-settings", serializer );
        serializer.endDocument();
    } //-- void write(Writer, Settings) 

    /**
     * Method writeSettings.
     * 
     * @param settings
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeSettings(Settings settings, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( settings != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( settings.getVssDirectory() != null )
            {
                serializer.startTag( NAMESPACE, "vssDirectory" ).text( settings.getVssDirectory() ).endTag( NAMESPACE, "vssDirectory" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeSettings(Settings, String, XmlSerializer) 


}
