/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.shared.model.fileset;

/**
 * Class SetBase.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class SetBase
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Specifies whether symbolic links should be
     * traversed, or handled as-is.
     *           
     */
    private boolean followSymlinks = false;

    /**
     * 
     *             Specifies the output directory relative to the
     * root
     *             of the root directory of the assembly.  For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     */
    private String outputDirectory;

    /**
     * 
     *             Whether to include exclusion patterns for common
     * temporary and SCM control
     *             files (true by default).
     *           
     */
    private boolean useDefaultExcludes = true;

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;

    /**
     * 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     *             
     *           
     */
    private String fileMode = "0644";

    /**
     * 
     *             
     *             Similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0755 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     *             
     *           
     */
    private String directoryMode = "0755";

    /**
     * 
     *             Specifies the mapper used.
     *           
     */
    private Mapper mapper = new Mapper();


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string a string object.
     */
    public void addExclude( String string )
    {
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addInclude.
     * 
     * @param string a string object.
     */
    public void addInclude( String string )
    {
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Get similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0755 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     * 
     * @return String
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Get similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     * 
     * @return String
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get specifies the mapper used.
     * 
     * @return Mapper
     */
    public Mapper getMapper()
    {
        return this.mapper;
    } //-- Mapper getMapper()

    /**
     * Get specifies the output directory relative to the root
     *             of the root directory of the assembly.  For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     * 
     * @return String
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory()

    /**
     * Get specifies whether symbolic links should be traversed, or
     * handled as-is.
     * 
     * @return boolean
     */
    public boolean isFollowSymlinks()
    {
        return this.followSymlinks;
    } //-- boolean isFollowSymlinks()

    /**
     * Get whether to include exclusion patterns for common
     * temporary and SCM control
     *             files (true by default).
     * 
     * @return boolean
     */
    public boolean isUseDefaultExcludes()
    {
        return this.useDefaultExcludes;
    } //-- boolean isUseDefaultExcludes()

    /**
     * Method removeExclude.
     * 
     * @param string a string object.
     */
    public void removeExclude( String string )
    {
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeInclude.
     * 
     * @param string a string object.
     */
    public void removeInclude( String string )
    {
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Set similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0755 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     * 
     * @param directoryMode a directoryMode object.
     */
    public void setDirectoryMode( String directoryMode )
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode( String )

    /**
     * Set when &lt;exclude&gt; subelements are present, they
     * define
     *             a set of files and directory to exclude.
     * 
     * @param excludes a excludes object.
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set similar to a UNIX permission.  Format:
     * (User)(Group)(Other) where each
     *             component is a sum of Read = 4, Write = 2, and
     * Execute = 1.  For example,
     *             the default value of 0644 translates to User
     * read-write, Group and Other
     *             read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style
     *             permissions)</a>
     * 
     * @param fileMode a fileMode object.
     */
    public void setFileMode( String fileMode )
    {
        this.fileMode = fileMode;
    } //-- void setFileMode( String )

    /**
     * Set specifies whether symbolic links should be traversed, or
     * handled as-is.
     * 
     * @param followSymlinks a followSymlinks object.
     */
    public void setFollowSymlinks( boolean followSymlinks )
    {
        this.followSymlinks = followSymlinks;
    } //-- void setFollowSymlinks( boolean )

    /**
     * Set when &lt;include&gt; subelements are present, they
     * define
     *             a set of files and directory to include.
     * 
     * @param includes a includes object.
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set specifies the mapper used.
     * 
     * @param mapper a mapper object.
     */
    public void setMapper( Mapper mapper )
    {
        this.mapper = mapper;
    } //-- void setMapper( Mapper )

    /**
     * Set specifies the output directory relative to the root
     *             of the root directory of the assembly.  For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     * 
     * @param outputDirectory a outputDirectory object.
     */
    public void setOutputDirectory( String outputDirectory )
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory( String )

    /**
     * Set whether to include exclusion patterns for common
     * temporary and SCM control
     *             files (true by default).
     * 
     * @param useDefaultExcludes a useDefaultExcludes object.
     */
    public void setUseDefaultExcludes( boolean useDefaultExcludes )
    {
        this.useDefaultExcludes = useDefaultExcludes;
    } //-- void setUseDefaultExcludes( boolean )

    
    /**
     * @return the file-set inclusion rules in array form.
     */
    public String[] getIncludesArray()
    {
        String[] includesArry = null;
        java.util.List<String> includes = getIncludes();
        if ( includes != null && !includes.isEmpty() )
        {
            includesArry = (String[]) includes.toArray( new String[0] );
        }
        else if ( includes != null )
        {
            includesArry = new String[0];
        }

        return includesArry;
    }

    /**
     * @return the file-set exclusion rules in array form.
     */
    public String[] getExcludesArray()
    {
        String[] excludesArry = null;
        java.util.List<String> excludes = getExcludes();
        if ( excludes != null && !excludes.isEmpty() )
        {
            excludesArry = (String[]) excludes.toArray( new String[0] );
        }
        else if ( excludes != null )
        {
            excludesArry = new String[0];
        }

        return excludesArry;
    }

          
}
