/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.asm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ConstantPoolParser {
    public static final int HEAD = -889275714;
    public static final byte CONSTANT_UTF8 = 1;
    public static final byte CONSTANT_INTEGER = 3;
    public static final byte CONSTANT_FLOAT = 4;
    public static final byte CONSTANT_LONG = 5;
    public static final byte CONSTANT_DOUBLE = 6;
    public static final byte CONSTANT_CLASS = 7;
    public static final byte CONSTANT_STRING = 8;
    public static final byte CONSTANT_FIELDREF = 9;
    public static final byte CONSTANT_METHODREF = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF = 11;
    public static final byte CONSTANT_NAME_AND_TYPE = 12;
    public static final byte CONSTANT_METHODHANDLE = 15;
    public static final byte CONSTANT_METHOD_TYPE = 16;
    public static final byte CONSTANT_INVOKE_DYNAMIC = 18;
    public static final byte CONSTANT_MODULE = 19;
    public static final byte CONSTANT_PACKAGE = 20;
    private static final int OXF0 = 240;
    private static final int OXE0 = 224;
    private static final int OX3F = 63;

    static Set<String> getConstantPoolClassReferences(byte[] b) {
        return ConstantPoolParser.parseConstantPoolClassReferences(ByteBuffer.wrap(b));
    }

    static Set<String> parseConstantPoolClassReferences(ByteBuffer buf) {
        if (buf.order(ByteOrder.BIG_ENDIAN).getInt() != -889275714) {
            return Collections.emptySet();
        }
        buf.getChar();
        buf.getChar();
        HashSet<Integer> classes = new HashSet<Integer>();
        HashMap<Integer, String> stringConstants = new HashMap<Integer, String>();
        int num = buf.getChar();
        block14: for (int ix = 1; ix < num; ++ix) {
            byte tag = buf.get();
            switch (tag) {
                default: {
                    throw new RuntimeException("Unknown constant pool type '" + tag + "'");
                }
                case 1: {
                    stringConstants.put(ix, ConstantPoolParser.decodeString(buf));
                    continue block14;
                }
                case 7: 
                case 16: {
                    classes.add(Integer.valueOf(buf.getChar()));
                    continue block14;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    ConstantPoolParser.consumeReference(buf);
                    continue block14;
                }
                case 3: {
                    ConstantPoolParser.consumeInt(buf);
                    continue block14;
                }
                case 4: {
                    ConstantPoolParser.consumeFloat(buf);
                    continue block14;
                }
                case 6: {
                    ConstantPoolParser.consumeDouble(buf);
                    ++ix;
                    continue block14;
                }
                case 5: {
                    ConstantPoolParser.consumeLong(buf);
                    ++ix;
                    continue block14;
                }
                case 8: {
                    ConstantPoolParser.consumeString(buf);
                    continue block14;
                }
                case 15: {
                    ConstantPoolParser.consumeMethodHandle(buf);
                    continue block14;
                }
                case 18: {
                    ConstantPoolParser.consumeInvokeDynamic(buf);
                    continue block14;
                }
                case 19: {
                    ConstantPoolParser.consumeModule(buf);
                    continue block14;
                }
                case 20: {
                    ConstantPoolParser.consumePackage(buf);
                }
            }
        }
        HashSet<String> result = new HashSet<String>();
        for (Integer aClass : classes) {
            String className = (String)stringConstants.get(aClass);
            if (!ConstantPoolParser.isImportableClass(className)) continue;
            result.add(className);
        }
        return result;
    }

    private static String decodeString(ByteBuffer buf) {
        char size = buf.getChar();
        int oldLimit = buf.limit();
        ((Buffer)buf).limit(buf.position() + size);
        StringBuilder sb = new StringBuilder(size + (size >> 1) + 16);
        while (buf.hasRemaining()) {
            byte b = buf.get();
            if (b > 0) {
                sb.append((char)b);
                continue;
            }
            byte b2 = buf.get();
            if ((b & 0xF0) != 224) {
                sb.append((char)((b & 0x1F) << 6 | b2 & 0x3F));
                continue;
            }
            byte b3 = buf.get();
            sb.append((char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F));
        }
        ((Buffer)buf).limit(oldLimit);
        return sb.toString();
    }

    private static boolean isImportableClass(String className) {
        return className.indexOf(47) != -1;
    }

    private static void consumeReference(ByteBuffer buf) {
        buf.getChar();
        buf.getChar();
    }

    private static void consumeInt(ByteBuffer buf) {
        buf.getInt();
    }

    private static void consumeFloat(ByteBuffer buf) {
        buf.getFloat();
    }

    private static void consumeDouble(ByteBuffer buf) {
        buf.getDouble();
    }

    private static void consumeLong(ByteBuffer buf) {
        buf.getLong();
    }

    private static void consumeString(ByteBuffer buf) {
        buf.getChar();
    }

    private static void consumeMethodHandle(ByteBuffer buf) {
        buf.get();
        buf.getChar();
    }

    private static void consumeInvokeDynamic(ByteBuffer buf) {
        buf.getChar();
        buf.getChar();
    }

    private static void consumeModule(ByteBuffer buf) {
        buf.getChar();
    }

    private static void consumePackage(ByteBuffer buf) {
        buf.getChar();
    }
}

