/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.it.LauncherException;
import org.apache.maven.it.MavenLauncher;
import org.apache.maven.shared.utils.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Embedded3xLauncher
implements MavenLauncher {
    private final Object mavenCli;
    private final Method doMain;

    private Embedded3xLauncher(Object mavenCli, Method doMain) {
        this.mavenCli = mavenCli;
        this.doMain = doMain;
    }

    public static Embedded3xLauncher createFromMavenHome(String mavenHome, String classworldConf, List<URL> classpath) throws LauncherException {
        if (mavenHome == null || mavenHome.length() <= 0) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome);
        }
        System.setProperty("maven.home", mavenHome);
        File config = classworldConf != null ? new File(classworldConf) : new File(mavenHome, "bin/m2.conf");
        ClassLoader bootLoader = Embedded3xLauncher.getBootLoader(mavenHome, classpath);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bootLoader);
        try {
            Class<?> launcherClass = bootLoader.loadClass("org.codehaus.plexus.classworlds.launcher.Launcher");
            Object launcher = launcherClass.newInstance();
            Method configure = launcherClass.getMethod("configure", InputStream.class);
            configure.invoke(launcher, new FileInputStream(config));
            Method getWorld = launcherClass.getMethod("getWorld", null);
            Object classWorld = getWorld.invoke(launcher, null);
            Method getMainClass = launcherClass.getMethod("getMainClass", null);
            Class cliClass = (Class)getMainClass.invoke(launcher, null);
            Constructor newMavenCli = cliClass.getConstructor(classWorld.getClass());
            Object mavenCli = newMavenCli.newInstance(classWorld);
            Class[] parameterTypes = new Class[]{String[].class, String.class, PrintStream.class, PrintStream.class};
            Method doMain = cliClass.getMethod("doMain", parameterTypes);
            Embedded3xLauncher embedded3xLauncher = new Embedded3xLauncher(mavenCli, doMain);
            return embedded3xLauncher;
        }
        catch (ClassNotFoundException e) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome, e);
        }
        catch (InstantiationException e) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome, e);
        }
        catch (IllegalAccessException e) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome, e);
        }
        catch (NoSuchMethodException e) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome, e);
        }
        catch (InvocationTargetException e) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome, e);
        }
        catch (IOException e) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public static Embedded3xLauncher createFromClasspath() throws LauncherException {
        ClassLoader coreLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> cliClass = coreLoader.loadClass("org.apache.maven.cli.MavenCli");
            Object mavenCli = cliClass.newInstance();
            Class[] parameterTypes = new Class[]{String[].class, String.class, PrintStream.class, PrintStream.class};
            Method doMain = cliClass.getMethod("doMain", parameterTypes);
            return new Embedded3xLauncher(mavenCli, doMain);
        }
        catch (ClassNotFoundException e) {
            throw new LauncherException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new LauncherException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new LauncherException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new LauncherException(e.getMessage(), e);
        }
    }

    private static ClassLoader getBootLoader(String mavenHome, List<URL> classpath) {
        List<URL> urls = classpath;
        if (urls == null) {
            urls = new ArrayList<URL>();
            File bootDir = new File(mavenHome, "boot");
            Embedded3xLauncher.addUrls(urls, bootDir);
        }
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("Invalid Maven home directory " + mavenHome);
        }
        URL[] ucp = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(ucp, ClassLoader.getSystemClassLoader().getParent());
    }

    private static void addUrls(List<URL> urls, File directory) {
        File[] jars = directory.listFiles();
        if (jars != null) {
            for (int i = 0; i < jars.length; ++i) {
                File jar = jars[i];
                if (!jar.getName().endsWith(".jar")) continue;
                try {
                    urls.add(jar.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw (RuntimeException)new IllegalStateException().initCause(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] cliArgs, String workingDirectory, File logFile) throws IOException, LauncherException {
        PrintStream out = logFile != null ? new PrintStream(new FileOutputStream(logFile)) : System.out;
        try {
            int n;
            Properties originalProperties = System.getProperties();
            System.setProperties(null);
            System.setProperty("maven.home", originalProperties.getProperty("maven.home", ""));
            System.setProperty("user.dir", new File(workingDirectory).getAbsolutePath());
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.mavenCli.getClass().getClassLoader());
            try {
                Object result = this.doMain.invoke(this.mavenCli, cliArgs, workingDirectory, out, out);
                n = ((Number)result).intValue();
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            catch (Throwable throwable) {
                try {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                    System.setProperties(originalProperties);
                    throw throwable;
                }
                catch (IllegalAccessException e) {
                    throw new LauncherException("Failed to run Maven: " + e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new LauncherException("Failed to run Maven: " + e.getMessage(), e);
                }
            }
            System.setProperties(originalProperties);
            return n;
        }
        finally {
            if (logFile != null) {
                out.close();
            }
        }
    }

    @Override
    public String getMavenVersion() throws LauncherException {
        String version;
        Properties props = new Properties();
        InputStream is = this.mavenCli.getClass().getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new LauncherException("Failed to read Maven version", e);
            }
            finally {
                IOUtil.close((InputStream)is);
            }
        }
        if ((version = props.getProperty("version")) != null) {
            return version;
        }
        throw new LauncherException("Could not determine embedded Maven version");
    }
}

