/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.Map;
import java.util.Set;
import org.apache.maven.shared.utils.io.SelectorUtils;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

final class FailingMethodFilter
extends Filter {
    private final Map<Class<?>, Set<String>> failingClassMethodPatterns;

    public FailingMethodFilter(Map<Class<?>, Set<String>> failingClassMethodPatterns) {
        this.failingClassMethodPatterns = failingClassMethodPatterns;
    }

    public boolean shouldRun(Description description) {
        return this.isDescriptionMatch(description);
    }

    private boolean isDescriptionMatch(Description description) {
        if (description.getTestClass() == null || description.getMethodName() == null) {
            for (Description childrenDescription : description.getChildren()) {
                if (!this.isDescriptionMatch(childrenDescription)) continue;
                return true;
            }
            return false;
        }
        Set<String> testMethodPatterns = this.failingClassMethodPatterns.get(description.getTestClass());
        String testMethod = description.getMethodName();
        return testMethodPatterns != null && FailingMethodFilter.matchMethod(testMethodPatterns, testMethod);
    }

    private static boolean matchMethod(Set<String> patterns, String methodName) {
        for (String pattern : patterns) {
            if (!SelectorUtils.match((String)pattern, (String)methodName)) continue;
            return true;
        }
        return false;
    }

    public String describe() {
        return "By failing class method";
    }
}

