package org.apache.maven.surefire.report;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;

/**
 * Text file reporter.
 *
 * @author <a href="mailto:jruiz@exist.com">Johnny R. Ruiz III</a>
 * @version $Id: FileReporter.java 1204688 2011-11-21 20:25:19Z krosenvold $
 */
public class FileReporter
    extends AbstractFileReporter
{

    public FileReporter( boolean trimStackTrace, File reportsDirectory )
    {
        super( trimStackTrace, PLAIN, reportsDirectory );
    }
    
    public FileReporter( boolean trimStackTrace, File reportsDirectory, String reportNamePrefix )
    {
        super( trimStackTrace, PLAIN, reportsDirectory, reportNamePrefix);
    }
}
