/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import javax.annotation.Nonnull;

public final class Relocator {
    private static final String RELOCATION_BASE = "org.apache.maven.surefire.";
    private static final String PACKAGE_DELIMITER = "shadefire";

    private Relocator() {
        throw new IllegalStateException("no instantiable constructor");
    }

    @Nonnull
    public static String relocate(@Nonnull String className) {
        if (className.contains(PACKAGE_DELIMITER)) {
            return className;
        }
        if (!className.startsWith(RELOCATION_BASE)) {
            throw new IllegalArgumentException("'" + className + "' should start with '" + RELOCATION_BASE + "'");
        }
        String rest = className.substring(RELOCATION_BASE.length());
        String s = "org.apache.maven.surefire.shadefire.";
        return "org.apache.maven.surefire.shadefire." + rest;
    }
}

