/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.SurefireExecutionParameters;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.surefire.booter.ForkConfiguration;
import org.apache.maven.surefire.booter.SurefireBooter;
import org.apache.maven.surefire.report.BriefConsoleReporter;
import org.apache.maven.surefire.report.BriefFileReporter;
import org.apache.maven.surefire.report.ConsoleReporter;
import org.apache.maven.surefire.report.DetailedConsoleReporter;
import org.apache.maven.surefire.report.FileReporter;
import org.apache.maven.surefire.report.ForkingConsoleReporter;
import org.apache.maven.surefire.report.XMLReporter;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSurefireMojo
extends AbstractMojo
implements SurefireExecutionParameters {
    private static final String BRIEF_REPORT_FORMAT = "brief";
    private static final String PLAIN_REPORT_FORMAT = "plain";

    protected abstract String getPluginName();

    protected abstract boolean verifyParameters() throws MojoFailureException;

    protected final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.getToolchainManager() != null) {
            tc = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession());
        }
        return tc;
    }

    private void convertTestNGParameters() {
        if (this.getProperties() == null) {
            this.setProperties(new Properties());
        }
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        if (this.getExcludedGroups() != null) {
            this.getProperties().setProperty("excludegroups", this.getExcludedGroups());
        }
        if (this.getGroups() != null) {
            this.getProperties().setProperty("groups", this.getGroups());
        }
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        if (this.getObjectFactory() != null) {
            this.getProperties().setProperty("objectfactory", this.getObjectFactory());
        }
    }

    protected boolean isAnyConcurrencySelected() {
        return this.getParallel() != null && this.getParallel().trim().length() > 0;
    }

    private void convertJunitCoreParameters() {
        if (this.getProperties() == null) {
            this.setProperties(new Properties());
        }
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadCount", Integer.toString(this.getThreadCount()));
        }
        if (this.getPerCoreThreadCount() != null) {
            this.getProperties().setProperty("perCoreThreadCount", this.getPerCoreThreadCount());
        }
        if (this.getUseUnlimitedThreads() != null) {
            this.getProperties().setProperty("useUnlimitedThreads", this.getUseUnlimitedThreads());
        }
        Artifact configurableParallelComputer = (Artifact)this.getProjectArtifactMap().get("org.jdogma.junit:configurable-parallel-computer");
        this.getProperties().setProperty("configurableParallelComputerPresent", Boolean.toString(configurableParallelComputer != null));
    }

    private boolean isJunit47Compatible(Artifact artifact) throws MojoExecutionException {
        return this.isWithinVersionSpec(artifact, "[4.7,)");
    }

    private boolean isAnyJunit4(Artifact artifact) throws MojoExecutionException {
        return this.isWithinVersionSpec(artifact, "[4.0,)");
    }

    private boolean isWithinVersionSpec(Artifact artifact, String versionSpec) throws MojoExecutionException {
        if (artifact == null) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            try {
                return range.containsVersion(artifact.getSelectedVersion());
            }
            catch (NullPointerException e) {
                return range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getBaseVersion()));
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Bug in junit 4.7 plugin. Please report with stacktrace");
        }
        catch (OverConstrainedVersionException e) {
            throw new MojoExecutionException("Bug in junit 4.7 plugin. Please report with stacktrace");
        }
    }

    protected boolean isForkModeNever() {
        return "never".equals(this.getForkMode());
    }

    protected SurefireBooter constructSurefireBooter() throws MojoExecutionException, MojoFailureException {
        Artifact testNgArtifact;
        Artifact junitArtifact;
        SurefireBooter surefireBooter = new SurefireBooter();
        Artifact surefireArtifact = (Artifact)this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        if (surefireArtifact == null) {
            throw new MojoExecutionException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        surefireArtifact.isSnapshot();
        try {
            this.addArtifact(surefireBooter, surefireArtifact);
            junitArtifact = (Artifact)this.getProjectArtifactMap().get(this.getJunitArtifactName());
            if (junitArtifact == null && "junit:junit".equals(this.getJunitArtifactName())) {
                junitArtifact = (Artifact)this.getProjectArtifactMap().get("junit:junit-dep");
            }
            if ((testNgArtifact = (Artifact)this.getProjectArtifactMap().get(this.getTestNGArtifactName())) != null) {
                VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,)");
                if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(testNgArtifact.getVersion()))) {
                    throw new MojoFailureException("TestNG support requires version 4.7 or above. You have declared version " + testNgArtifact.getVersion());
                }
                this.convertTestNGParameters();
                if (this.getTestClassesDirectory() != null) {
                    this.getProperties().setProperty("testng.test.classpath", this.getTestClassesDirectory().getAbsolutePath());
                }
                this.addArtifact(surefireBooter, testNgArtifact);
                this.addProvider(surefireBooter, "surefire-testng", surefireArtifact.getBaseVersion(), testNgArtifact);
            } else if (junitArtifact != null && this.isAnyJunit4(junitArtifact)) {
                if (this.isAnyConcurrencySelected() && this.isJunit47Compatible(junitArtifact)) {
                    this.convertJunitCoreParameters();
                    this.addProvider(surefireBooter, "surefire-junit47", surefireArtifact.getBaseVersion(), null);
                } else {
                    this.addProvider(surefireBooter, "surefire-junit4", surefireArtifact.getBaseVersion(), null);
                }
            } else {
                this.addProvider(surefireBooter, "surefire-junit", surefireArtifact.getBaseVersion(), null);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to locate required surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error determining the TestNG version requested: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error to resolving surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.getSuiteXmlFiles() != null && this.getSuiteXmlFiles().length > 0 && this.getTest() == null) {
            if (testNgArtifact == null) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
            surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGXmlTestSuite", new Object[]{this.getSuiteXmlFiles(), this.getTestSourceDirectory().getAbsolutePath(), testNgArtifact.getVersion(), testNgArtifact.getClassifier(), this.getProperties(), this.getReportsDirectory()});
        } else {
            String junitDirectoryTestSuite;
            ArrayList<Object> excludes;
            ArrayList<Object> includes;
            if (this.getTest() != null) {
                includes = new ArrayList();
                excludes = new ArrayList();
                if (this.getFailIfNoTests() == null) {
                    this.setFailIfNoTests(Boolean.TRUE);
                }
                String[] testRegexes = StringUtils.split((String)this.getTest(), (String)",");
                for (int i = 0; i < testRegexes.length; ++i) {
                    String testRegex = testRegexes[i];
                    if (testRegex.endsWith(".java")) {
                        testRegex = testRegex.substring(0, testRegex.length() - 5);
                    }
                    testRegex = testRegex.replace('.', '/');
                    includes.add("**/" + testRegex + ".java");
                }
            } else {
                includes = this.getIncludes();
                excludes = this.getExcludes();
                if (includes == null || includes.size() == 0) {
                    includes = new ArrayList<String>(Arrays.asList(this.getDefaultIncludes()));
                }
                if (excludes == null || excludes.size() == 0) {
                    excludes = new ArrayList<String>(Arrays.asList("**/*$*"));
                }
            }
            if (testNgArtifact != null) {
                surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGDirectoryTestSuite", new Object[]{this.getTestClassesDirectory(), includes, excludes, this.getTestSourceDirectory().getAbsolutePath(), testNgArtifact.getVersion(), testNgArtifact.getClassifier(), this.getProperties(), this.getReportsDirectory()});
            } else if (this.isAnyConcurrencySelected() && this.isJunit47Compatible(junitArtifact)) {
                junitDirectoryTestSuite = "org.apache.maven.surefire.junitcore.JUnitCoreDirectoryTestSuite";
                this.getLog().info((CharSequence)("Concurrency config is " + this.getProperties().toString()));
                surefireBooter.addTestSuite(junitDirectoryTestSuite, new Object[]{this.getTestClassesDirectory(), includes, excludes, this.getProperties()});
            } else {
                junitDirectoryTestSuite = this.isAnyJunit4(junitArtifact) ? "org.apache.maven.surefire.junit4.JUnit4DirectoryTestSuite" : "org.apache.maven.surefire.junit.JUnitDirectoryTestSuite";
                surefireBooter.addTestSuite(junitDirectoryTestSuite, new Object[]{this.getTestClassesDirectory(), includes, excludes});
            }
        }
        List classpathElements = null;
        try {
            classpathElements = this.generateTestClasspath();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to generate test classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)"Test Classpath :");
        Iterator i = classpathElements.iterator();
        while (i.hasNext()) {
            String classpathElement = (String)i.next();
            this.getLog().debug((CharSequence)("  " + classpathElement));
            surefireBooter.addClassPathUrl(classpathElement);
        }
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in " + this.getPluginName() + "-plugin: " + tc));
            if (this.isForkModeNever()) {
                this.setForkMode("once");
            }
            if (this.getJvm() != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.getJvm()));
            } else {
                this.setJvm(tc.findTool("java"));
            }
        }
        ForkConfiguration fork = new ForkConfiguration();
        fork.setForkMode(this.getForkMode());
        this.processSystemProperties(!fork.isForking());
        if (this.getLog().isDebugEnabled()) {
            this.showMap(this.getInternalSystemProperties(), "system property");
        }
        if (fork.isForking()) {
            List<String> args;
            this.setUseSystemClassLoader(this.getUseSystemClassLoader() == null ? Boolean.TRUE : this.getUseSystemClassLoader());
            fork.setUseSystemClassLoader(this.getUseSystemClassLoader().booleanValue());
            fork.setUseManifestOnlyJar(this.isUseManifestOnlyJar());
            fork.setSystemProperties(this.getInternalSystemProperties());
            if ("true".equals(this.getDebugForkedProcess())) {
                this.setDebugForkedProcess("-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
            }
            fork.setDebugLine(this.getDebugForkedProcess());
            if (this.getJvm() == null || "".equals(this.getJvm())) {
                this.setJvm(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
                this.getLog().debug((CharSequence)("Using JVM: " + this.getJvm()));
            }
            fork.setJvmExecutable(this.getJvm());
            if (this.getWorkingDirectory() != null) {
                fork.setWorkingDirectory(this.getWorkingDirectory());
            } else {
                fork.setWorkingDirectory(this.getBasedir());
            }
            fork.setArgLine(this.getArgLine());
            fork.setEnvironmentVariables(this.getEnvironmentVariables());
            if (this.getLog().isDebugEnabled()) {
                this.showMap(this.getEnvironmentVariables(), "environment variable");
                fork.setDebug(true);
            }
            if (this.getArgLine() != null && ((args = Arrays.asList(this.getArgLine().split(" "))).contains("-da") || args.contains("-disableassertions"))) {
                this.setEnableAssertions(false);
            }
        }
        surefireBooter.setFailIfNoTests(this.getFailIfNoTests() == null ? false : this.getFailIfNoTests());
        surefireBooter.setForkedProcessTimeoutInSeconds(this.getForkedProcessTimeoutInSeconds());
        surefireBooter.setRedirectTestOutputToFile(this.isRedirectTestOutputToFile());
        surefireBooter.setForkConfiguration(fork);
        surefireBooter.setChildDelegation(this.isChildDelegation());
        surefireBooter.setEnableAssertions(this.isEnableAssertions());
        surefireBooter.setReportsDirectory(this.getReportsDirectory());
        this.addReporters(surefireBooter, fork.isForking());
        return surefireBooter;
    }

    protected abstract String[] getDefaultIncludes();

    public List generateTestClasspath() throws DependencyResolutionRequiredException, MojoExecutionException {
        PatternIncludesArtifactFilter dependencyFilter;
        ArrayList<String> classpath = new ArrayList<String>(2 + this.getProject().getArtifacts().size());
        classpath.add(this.getTestClassesDirectory().getAbsolutePath());
        classpath.add(this.getClassesDirectory().getAbsolutePath());
        Set classpathArtifacts = this.getProject().getArtifacts();
        if (this.getClasspathDependencyScopeExclude() != null && !this.getClasspathDependencyScopeExclude().equals("")) {
            dependencyFilter = new ScopeArtifactFilter(this.getClasspathDependencyScopeExclude());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        if (this.getClasspathDependencyExcludes() != null) {
            dependencyFilter = new PatternIncludesArtifactFilter(this.getClasspathDependencyExcludes());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        Iterator iter = classpathArtifacts.iterator();
        while (iter.hasNext()) {
            File file;
            Artifact artifact = (Artifact)iter.next();
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            classpath.add(file.getPath());
        }
        if (this.getAdditionalClasspathElements() != null) {
            iter = this.getAdditionalClasspathElements().iterator();
            while (iter.hasNext()) {
                String classpathElement = (String)iter.next();
                classpath.add(classpathElement);
            }
        }
        return classpath;
    }

    private Set filterArtifacts(Set artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (filter.include(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private void showMap(Map map, String setting) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)map.get(key);
            this.getLog().debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    private void addProvider(SurefireBooter surefireBooter, String provider, String version, Artifact filteredArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact providerArtifact = this.getArtifactFactory().createDependencyArtifact("org.apache.maven.surefire", provider, VersionRange.createFromVersion((String)version), "jar", null, "test");
        ArtifactResolutionResult result = this.resolveArtifact(filteredArtifact, providerArtifact);
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("Adding to " + this.getPluginName() + " test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope()));
            surefireBooter.addSurefireClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.getArtifactFactory().createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.getArtifactResolver().resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), (ArtifactFilter)filter);
    }

    private void addArtifact(SurefireBooter surefireBooter, Artifact surefireArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("Adding to " + this.getPluginName() + " booter test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope()));
            surefireBooter.addSurefireBootClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    protected void processSystemProperties(boolean setInSystem) {
        String value;
        String key;
        String value2;
        String key2;
        Iterator<Object> i;
        if (this.getSystemProperties() != null) {
            i = this.getSystemProperties().keySet().iterator();
            while (i.hasNext()) {
                key2 = (String)i.next();
                value2 = (String)this.getSystemProperties().get(key2);
                this.getInternalSystemProperties().setProperty(key2, value2);
            }
        }
        if (this.getSystemPropertyVariables() != null) {
            i = this.getSystemPropertyVariables().keySet().iterator();
            while (i.hasNext()) {
                key2 = (String)i.next();
                value2 = (String)this.getSystemPropertyVariables().get(key2);
                if (value2 == null) continue;
                this.getInternalSystemProperties().setProperty(key2, value2);
            }
        }
        this.setOriginalSystemProperties((Properties)System.getProperties().clone());
        Properties userProperties = this.getUserProperties();
        Iterator<Object> it = userProperties.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            value = userProperties.getProperty(key);
            this.getInternalSystemProperties().setProperty(key, value);
        }
        this.getInternalSystemProperties().setProperty("basedir", this.getBasedir().getAbsolutePath());
        this.getInternalSystemProperties().setProperty("user.dir", this.getWorkingDirectory().getAbsolutePath());
        this.getInternalSystemProperties().setProperty("localRepository", this.getLocalRepository().getBasedir());
        if (setInSystem) {
            Iterator<Object> iter = this.getInternalSystemProperties().keySet().iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = this.getInternalSystemProperties().getProperty(key);
                System.setProperty(key, value);
            }
        }
    }

    private Properties getUserProperties() {
        Properties props = null;
        try {
            Method getUserProperties = this.getSession().getClass().getMethod("getUserProperties", null);
            props = (Properties)getUserProperties.invoke((Object)this.getSession(), null);
        }
        catch (Exception e) {
            String msg = "Build uses Maven 2.0.x, cannot propagate system properties from command line to tests (cf. SUREFIRE-121)";
            if (this.getLog().isDebugEnabled()) {
                this.getLog().warn((CharSequence)msg, (Throwable)e);
            }
            this.getLog().warn((CharSequence)msg);
        }
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    private void addReporters(SurefireBooter surefireBooter, boolean forking) {
        Boolean trimStackTrace = this.isTrimStackTrace();
        if (this.isUseFile()) {
            if (this.isPrintSummary()) {
                if (forking) {
                    surefireBooter.addReport(ForkingConsoleReporter.class.getName(), new Object[]{trimStackTrace});
                } else {
                    surefireBooter.addReport(ConsoleReporter.class.getName(), new Object[]{trimStackTrace});
                }
            }
            if (BRIEF_REPORT_FORMAT.equals(this.getReportFormat())) {
                surefireBooter.addReport(BriefFileReporter.class.getName(), new Object[]{this.getReportsDirectory(), trimStackTrace});
            } else if (PLAIN_REPORT_FORMAT.equals(this.getReportFormat())) {
                surefireBooter.addReport(FileReporter.class.getName(), new Object[]{this.getReportsDirectory(), trimStackTrace});
            }
        } else if (BRIEF_REPORT_FORMAT.equals(this.getReportFormat())) {
            surefireBooter.addReport(BriefConsoleReporter.class.getName(), new Object[]{trimStackTrace});
        } else if (PLAIN_REPORT_FORMAT.equals(this.getReportFormat())) {
            surefireBooter.addReport(DetailedConsoleReporter.class.getName(), new Object[]{trimStackTrace});
        }
        if (!this.isDisableXmlReport()) {
            surefireBooter.addReport(XMLReporter.class.getName(), new Object[]{this.getReportsDirectory(), trimStackTrace});
        }
    }

    protected void ensureWorkingDirectoryExists() throws MojoFailureException {
        if (!this.getWorkingDirectory().exists() && !this.getWorkingDirectory().mkdirs()) {
            throw new MojoFailureException("Cannot create workingDirectory " + this.getWorkingDirectory());
        }
        if (!this.getWorkingDirectory().isDirectory()) {
            throw new MojoFailureException("workingDirectory " + this.getWorkingDirectory() + " exists and is not a directory");
        }
    }

    protected void ensureParallelRunningCompatibility() throws MojoFailureException {
        if (this.isMavenParallel() && this.isForkModeNever()) {
            throw new MojoFailureException("parallel maven execution is not compatible with surefire forkmode NEVER");
        }
    }

    protected void warnIfUselessUseSystemClassLoaderParameter() {
        if (this.getUseSystemClassLoader() != null && this.isForkModeNever()) {
            this.getLog().warn((CharSequence)"useSystemClassloader setting has no effect when not forking");
        }
    }
}

