/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.booter.ProcessCheckerType;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.RunOrderParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.RunOrder;

class BooterSerializer {
    private final ForkConfiguration forkConfiguration;

    BooterSerializer(ForkConfiguration forkConfiguration) {
        this.forkConfiguration = forkConfiguration;
    }

    File serialize(KeyValueSource sourceProperties, ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, Object testSet, boolean readTestsFromInStream, Long pid, int forkNumber) throws IOException {
        RunOrderParameters runOrderParameters;
        DirectoryScannerParameters directoryScannerParameters;
        SurefireProperties properties = new SurefireProperties(sourceProperties);
        properties.setProperty("pluginPid", pid);
        AbstractPathConfiguration cp = startupConfiguration.getClasspathConfiguration();
        properties.setClasspath("classPathUrl.", cp.getTestClasspath());
        properties.setClasspath("surefireClassPathUrl.", cp.getProviderClasspath());
        properties.setProperty("enableAssertions", BooterSerializer.toString(cp.isEnableAssertions()));
        properties.setProperty("childDelegation", BooterSerializer.toString(cp.isChildDelegation()));
        ProcessCheckerType processChecker = startupConfiguration.getProcessChecker();
        properties.setNullableProperty("processChecker", processChecker == null ? null : processChecker.getType());
        TestArtifactInfo testNg = providerConfiguration.getTestArtifact();
        if (testNg != null) {
            properties.setProperty("testFwJarVersion", testNg.getVersion());
            properties.setNullableProperty("testFwJarClassifier", testNg.getClassifier());
        }
        properties.setProperty("preferTestsFromInStream", readTestsFromInStream);
        properties.setNullableProperty("forkTestSet", BooterSerializer.getTypeEncoded(testSet));
        TestRequest testSuiteDefinition = providerConfiguration.getTestSuiteDefinition();
        if (testSuiteDefinition != null) {
            properties.setProperty("testSuiteDefinitionTestSourceDirectory", testSuiteDefinition.getTestSourceDirectory());
            if (testSet instanceof File) {
                properties.addList(Collections.singletonList((File)testSet), "testSuiteXmlFiles");
            } else {
                properties.addList(testSuiteDefinition.getSuiteXmlFiles(), "testSuiteXmlFiles");
            }
            TestListResolver testFilter = testSuiteDefinition.getTestListResolver();
            properties.setProperty("requestedTest", testFilter == null ? "" : testFilter.getPluginParameterTest());
            int rerunFailingTestsCount = testSuiteDefinition.getRerunFailingTestsCount();
            properties.setNullableProperty("rerunFailingTestsCount", BooterSerializer.toString(rerunFailingTestsCount));
        }
        if ((directoryScannerParameters = providerConfiguration.getDirScannerParams()) != null) {
            properties.setProperty("failIfNoTests", BooterSerializer.toString(directoryScannerParameters.isFailIfNoTests()));
            properties.addList(directoryScannerParameters.getIncludes(), "includes");
            properties.addList(directoryScannerParameters.getExcludes(), "excludes");
            properties.addList(directoryScannerParameters.getSpecificTests(), "specificTest");
            properties.setProperty("testClassesDirectory", directoryScannerParameters.getTestClassesDirectory());
        }
        if ((runOrderParameters = providerConfiguration.getRunOrderParameters()) != null) {
            properties.setProperty("runOrder", RunOrder.asString((RunOrder[])runOrderParameters.getRunOrder()));
            properties.setProperty("runStatisticsFile", runOrderParameters.getRunStatisticsFile());
        }
        ReporterConfiguration reporterConfiguration = providerConfiguration.getReporterConfiguration();
        boolean rep = reporterConfiguration.isTrimStackTrace();
        File reportsDirectory = SurefireHelper.replaceForkThreadsInPath(reporterConfiguration.getReportsDirectory(), forkNumber);
        properties.setProperty("isTrimStackTrace", rep);
        properties.setProperty("reportsDirectory", reportsDirectory);
        ClassLoaderConfiguration classLoaderConfig = startupConfiguration.getClassLoaderConfiguration();
        properties.setProperty("useSystemClassLoader", BooterSerializer.toString(classLoaderConfig.isUseSystemClassLoader()));
        properties.setProperty("useManifestOnlyJar", BooterSerializer.toString(classLoaderConfig.isUseManifestOnlyJar()));
        properties.setProperty("failIfNoTests", BooterSerializer.toString(providerConfiguration.isFailIfNoTests()));
        properties.setProperty("providerConfiguration", startupConfiguration.getProviderClassName());
        properties.setProperty("failFastCount", BooterSerializer.toString(providerConfiguration.getSkipAfterFailureCount()));
        properties.setProperty("shutdown", providerConfiguration.getShutdown().name());
        List mainCliOptions = providerConfiguration.getMainCliOptions();
        if (mainCliOptions != null) {
            properties.addList(mainCliOptions, "mainCliOptions");
        }
        properties.setNullableProperty("systemExitTimeout", BooterSerializer.toString(providerConfiguration.getSystemExitTimeout()));
        File surefireTmpDir = this.forkConfiguration.getTempDirectory();
        boolean debug = this.forkConfiguration.isDebug();
        return SystemPropertyManager.writePropertiesFile((Properties)properties, (File)surefireTmpDir, (String)"surefire", (boolean)debug);
    }

    private static String getTypeEncoded(Object value) {
        if (value == null) {
            return null;
        }
        String valueToUse = value instanceof Class ? ((Class)value).getName() : value.toString();
        return value.getClass().getName() + "|" + valueToUse;
    }

    private static String toString(Object o) {
        return String.valueOf(o);
    }
}

