/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.runorder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.surefire.runorder.PrioritizedTest;
import org.apache.maven.plugin.surefire.runorder.Priority;
import org.apache.maven.plugin.surefire.runorder.RunEntryStatistics;
import org.apache.maven.plugin.surefire.runorder.ThreadedExecutionScheduler;
import org.apache.maven.surefire.report.ReportEntry;

public class RunEntryStatisticsMap {
    private final Map runEntryStatistics;
    private static final Pattern PARENS = Pattern.compile("^[^\\(\\)]+\\(([^\\\\(\\\\)]+)\\)$");

    public RunEntryStatisticsMap(Map runEntryStatistics) {
        this.runEntryStatistics = Collections.synchronizedMap(runEntryStatistics);
    }

    public RunEntryStatisticsMap() {
        this(new HashMap());
    }

    public static RunEntryStatisticsMap fromFile(File file) {
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                return RunEntryStatisticsMap.fromReader(fileReader);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        return new RunEntryStatisticsMap();
    }

    static RunEntryStatisticsMap fromReader(Reader fileReader) throws IOException {
        HashMap<String, RunEntryStatistics> result = new HashMap<String, RunEntryStatistics>();
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = bufferedReader.readLine();
        while (line != null) {
            if (!line.startsWith("#")) {
                RunEntryStatistics stats = RunEntryStatistics.fromString(line);
                result.put(stats.getTestName(), stats);
            }
            line = bufferedReader.readLine();
        }
        return new RunEntryStatisticsMap(result);
    }

    public void serialize(File file) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter(fos);
        ArrayList items = new ArrayList(this.runEntryStatistics.values());
        Collections.sort(items, new RunCountComparator());
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            RunEntryStatistics item = (RunEntryStatistics)iter.next();
            printWriter.println(item.getAsString());
        }
        printWriter.close();
    }

    public RunEntryStatistics findOrCreate(ReportEntry reportEntry) {
        RunEntryStatistics item = (RunEntryStatistics)this.runEntryStatistics.get(reportEntry.getName());
        return item != null ? item : RunEntryStatistics.fromReportEntry(reportEntry);
    }

    public RunEntryStatistics createNextGeneration(ReportEntry reportEntry) {
        RunEntryStatistics newItem = this.findOrCreate(reportEntry);
        Integer elapsed = reportEntry.getElapsed();
        return newItem.nextGeneration(elapsed != null ? elapsed : 0);
    }

    public RunEntryStatistics createNextGenerationFailure(ReportEntry reportEntry) {
        RunEntryStatistics newItem = this.findOrCreate(reportEntry);
        Integer elapsed = reportEntry.getElapsed();
        return newItem.nextGenerationFailure(elapsed != null ? elapsed : 0);
    }

    public void add(RunEntryStatistics item) {
        this.runEntryStatistics.put(item.getTestName(), item);
    }

    public List getPrioritizedTestsClassRunTime(List testsToRun, int threadCount) {
        List prioritizedTests = this.getPrioritizedTests(testsToRun, new TestRuntimeComparator());
        ThreadedExecutionScheduler threadedExecutionScheduler = new ThreadedExecutionScheduler(threadCount);
        Iterator prioritizedTest = prioritizedTests.iterator();
        while (prioritizedTest.hasNext()) {
            threadedExecutionScheduler.addTest((PrioritizedTest)prioritizedTest.next());
        }
        return threadedExecutionScheduler.getResult();
    }

    public List getPrioritizedTestsByFailureFirst(List testsToRun) {
        List prioritizedTests = this.getPrioritizedTests(testsToRun, new LeastFailureComparator());
        return this.transformToClasses(prioritizedTests);
    }

    private List getPrioritizedTests(List testsToRun, Comparator priorityComparator) {
        Map classPriorities = this.getPriorities(priorityComparator);
        ArrayList<PrioritizedTest> tests = new ArrayList<PrioritizedTest>();
        Iterator iter = testsToRun.iterator();
        while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            Priority pri = (Priority)classPriorities.get(clazz.getName());
            if (pri == null) {
                pri = Priority.newTestClassPriority(clazz.getName());
            }
            PrioritizedTest prioritizedTest = new PrioritizedTest(clazz, pri);
            tests.add(prioritizedTest);
        }
        Collections.sort(tests, new PrioritizedTestComparator());
        return tests;
    }

    private List transformToClasses(List tests) {
        ArrayList<Class> result = new ArrayList<Class>();
        for (int i = 0; i < tests.size(); ++i) {
            result.add(((PrioritizedTest)tests.get(i)).getClazz());
        }
        return result;
    }

    public Map getPriorities(Comparator priorityComparator) {
        HashMap<String, Priority> priorities = new HashMap<String, Priority>();
        Iterator iter = this.runEntryStatistics.keySet().iterator();
        while (iter.hasNext()) {
            String testNames = (String)iter.next();
            String clazzName = this.extractClassName(testNames);
            Priority priority = (Priority)priorities.get(clazzName);
            if (priority == null) {
                priority = new Priority(clazzName);
                priorities.put(clazzName, priority);
            }
            RunEntryStatistics itemStat = (RunEntryStatistics)this.runEntryStatistics.get(testNames);
            priority.addItem(itemStat);
        }
        ArrayList items = new ArrayList(priorities.values());
        Collections.sort(items, priorityComparator);
        HashMap<String, Priority> result = new HashMap<String, Priority>();
        int i = 0;
        Iterator iter2 = items.iterator();
        while (iter2.hasNext()) {
            Priority pri = (Priority)iter2.next();
            pri.setPriority(i++);
            result.put(pri.getClassName(), pri);
        }
        return result;
    }

    String extractClassName(String displayName) {
        Matcher m = PARENS.matcher(displayName);
        if (!m.find()) {
            return displayName;
        }
        return m.group(1);
    }

    class LeastFailureComparator
    implements Comparator {
        LeastFailureComparator() {
        }

        public int compare(Object o, Object o1) {
            Priority re = (Priority)o;
            Priority re1 = (Priority)o1;
            return re.getMinSuccessRate() - re1.getMinSuccessRate();
        }
    }

    class TestRuntimeComparator
    implements Comparator {
        TestRuntimeComparator() {
        }

        public int compare(Object o, Object o1) {
            Priority re = (Priority)o;
            Priority re1 = (Priority)o1;
            return re1.getTotalRuntime() - re.getTotalRuntime();
        }
    }

    class PrioritizedTestComparator
    implements Comparator {
        PrioritizedTestComparator() {
        }

        public int compare(Object o, Object o1) {
            PrioritizedTest re = (PrioritizedTest)o;
            PrioritizedTest re1 = (PrioritizedTest)o1;
            return re.getPriority() - re1.getPriority();
        }
    }

    class RunCountComparator
    implements Comparator {
        RunCountComparator() {
        }

        public int compare(Object o, Object o1) {
            RunEntryStatistics re = (RunEntryStatistics)o;
            RunEntryStatistics re1 = (RunEntryStatistics)o1;
            int runtime = re.getSuccessfulBuilds() - re1.getSuccessfulBuilds();
            if (runtime == 0) {
                return re.getRunTime() - re1.getRunTime();
            }
            return runtime;
        }
    }
}

