/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.suite;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;

public class AnnotationFilter {
    private List acceptedClasses = new LinkedList();
    private List rejectedClasses = new LinkedList();

    private void checkValidAnnotation(Class clazz) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException("Class is not an annotation: " + clazz.getName());
        }
    }

    public void accept(Class clazz) {
        this.checkValidAnnotation(clazz);
        this.acceptedClasses.add(clazz);
    }

    public void reject(Class clazz) {
        this.checkValidAnnotation(clazz);
        this.rejectedClasses.add(clazz);
    }

    public List filter(Class[] source) {
        LinkedList<Class> result = new LinkedList<Class>();
        int sourceLength = source.length;
        for (int i = 0; i < sourceLength; ++i) {
            Class sourceClass = source[i];
            if (!this.isClassAccepted(sourceClass) || this.isClassRejected(sourceClass)) continue;
            result.add(sourceClass);
        }
        return result;
    }

    private boolean isClassAccepted(Class sourceClass) {
        boolean b = this.acceptedClasses.isEmpty() || this.containsSome(sourceClass, this.acceptedClasses);
        return b;
    }

    private boolean isClassRejected(Class sourceClass) {
        boolean b = !this.rejectedClasses.isEmpty() && this.containsSome(sourceClass, this.rejectedClasses);
        return b;
    }

    private boolean containsSome(Class sourceClass, List annotations) {
        Annotation[] annotations1 = sourceClass.getAnnotations();
        int annotations1Length = annotations1.length;
        for (int i1 = 0; i1 < annotations1Length; ++i1) {
            Annotation annotation = annotations1[i1];
            int annotationsSize = annotations.size();
            for (int i = 0; i < annotationsSize; ++i) {
                Object filterAnnotation = annotations.get(i);
                if (!((Class)filterAnnotation).isAssignableFrom(annotation.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public List getAcceptedClasses() {
        return this.acceptedClasses;
    }

    public List getRejectedClasses() {
        return this.rejectedClasses;
    }
}

