/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.suite;

import org.apache.maven.surefire.suite.AnnotationFilter;

public class AnnotationFilterBuilder {
    public AnnotationFilter build(String includedAnnotations, String excludedAnnotations) {
        final AnnotationFilter filter = new AnnotationFilter();
        this.parseClassNames(includedAnnotations, new ParserCallback(){

            public void onNewClass(Class clazz) {
                filter.accept(clazz);
            }
        });
        this.parseClassNames(excludedAnnotations, new ParserCallback(){

            public void onNewClass(Class clazz) {
                filter.reject(clazz);
            }
        });
        return filter;
    }

    private void parseClassNames(String classNames, ParserCallback callback) {
        if (classNames != null) {
            String[] names = classNames.split(":");
            int namesLength = names.length;
            for (int i = 0; i < namesLength; ++i) {
                String className = names[i];
                try {
                    Class<?> filterClass = this.getClass().getClassLoader().loadClass(className);
                    callback.onNewClass(filterClass);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Error parsing class names", e);
                }
            }
        }
    }

    private static interface ParserCallback {
        public void onNewClass(Class var1);
    }
}

